*** Settings ***

Library  collective.ckeditor.tests.keyword.TestKeywords

Resource  plone/app/robotframework/keywords.robot
Resource  plone/app/robotframework/selenium.robot
Resource  plone/app/robotframework/saucelabs.robot

Library  Remote  ${PLONE_URL}/RobotRemote
Library  plone.app.robotframework.keywords.Debugging

Test Setup  Open SauceLabs test browser
Test Teardown  Run keywords  Report test status  Close all browsers

*** Test cases ***

Scenario: As an editor, I am using CKEditor
    Given a logged-in editor
    and a document
    When I edit the document
    Then CKEditor is used for the text field

Scenario: Use bold button
    Given a logged-in editor
    and a document
    When I edit the document
    and select some text
    and click the bold button
    and save the document
    Then the selected text is bold

Scenario: Use italic button
    Given a logged-in editor
    and a document
    When I edit the document
    and select some text
    and click the italic button
    and save the document
    Then the selected text is italic

*** Keywords *****************************************************************

# --- GIVEN ------------------------------------------------------------------

a logged-in editor
  Enable autologin as  Editor  Contributor

a document
  Create content  type=Document  id=document-to-edit  title=Document to edit  text=<p id="p1">paragraph1</p><p id="p2">paragraph2</p><p>paragraph3</p><p>paragraph4</p>
  Go to  ${PLONE_URL}/document-to-edit
  Page Should Contain  paragraph1
  Page Should Contain  paragraph4
  Page Should Contain Element  css=#p1
  Page Should Not Contain Element  css=#p1 strong

# --- WHEN -------------------------------------------------------------------
    
I edit the document
  Go to  ${PLONE_URL}/document-to-edit/edit

select some text
  Select Frame  css=iframe.cke_wysiwyg_frame
  Page Should Contain Element  css=#p1
  Mouse Select  css=#p1  20  0
  Unselect Frame

click the bold button
  Click Element  css=span.cke_button__bold_icon 

click the italic button
  Click Element  css=span.cke_button__italic_icon 

save the document
    Unselect Frame
    Sleep  1  Wait for the modification of the content
    Click Button  Save

# --- THEN -------------------------------------------------------------------

CKEditor is used for the text field
  Page should contain element  css=#archetypes-fieldname-text #cke_text #cke_1_contents iframe

the selected text is bold
  Page Should Contain Element  css=#p1 strong

the selected text is italic
  Page Should Contain Element  css=#p1 em
