/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive.scheduler.common.SortSpecifierContainer;
import org.ow2.proactive_grid_cloud_portal.common.dto.LoginForm;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobUsageData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobValidationData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.RestMapPage;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.RestPage;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerStatusData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerUserData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.UserJobData;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.JobAlreadyFinishedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.JobCreationRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.LogForwardingRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.NotConnectedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.PermissionRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SchedulerRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SubmissionClosedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.UnknownJobRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.UnknownTaskRestException;

@Path(value="/scheduler/")
public interface SchedulerRestInterface {
    @GET
    @Path(value="jobs")
    @Produces(value={"application/json"})
    public RestPage<String> jobs(@HeaderParam(value="sessionid") String var1, @QueryParam(value="index") @DefaultValue(value="-1") int var2, @QueryParam(value="limit") @DefaultValue(value="-1") int var3) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="jobsinfo")
    @Produces(value={"application/json", "application/xml"})
    public RestPage<UserJobData> jobsInfo(@HeaderParam(value="sessionid") String var1, @QueryParam(value="index") @DefaultValue(value="-1") int var2, @QueryParam(value="limit") @DefaultValue(value="-1") int var3) throws PermissionRestException, NotConnectedRestException;

    @GET
    @Path(value="jobsinfolist")
    @Produces(value={"application/json", "application/xml"})
    public List<UserJobData> jobsInfoList(@HeaderParam(value="sessionid") String var1, @QueryParam(value="jobsid") List<String> var2) throws PermissionRestException, NotConnectedRestException, UnknownJobRestException;

    @GET
    @GZIP
    @Path(value="revisionjobsinfo")
    @Produces(value={"application/json", "application/xml"})
    public RestMapPage<Long, ArrayList<UserJobData>> revisionAndJobsInfo(@HeaderParam(value="sessionid") String var1, @QueryParam(value="index") @DefaultValue(value="-1") int var2, @QueryParam(value="limit") @DefaultValue(value="-1") int var3, @QueryParam(value="myjobs") @DefaultValue(value="false") boolean var4, @QueryParam(value="pending") @DefaultValue(value="true") boolean var5, @QueryParam(value="running") @DefaultValue(value="true") boolean var6, @QueryParam(value="finished") @DefaultValue(value="true") boolean var7) throws PermissionRestException, NotConnectedRestException;

    @GET
    @Path(value="state/revision")
    @Produces(value={"application/json", "application/xml"})
    public long schedulerStateRevision(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException;

    @GET
    @Path(value="jobs/{jobid}")
    @Produces(value={"application/json", "application/xml"})
    public JobStateData listJobs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/result")
    @Produces(value={"application/json"})
    public JobResultData jobResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, PermissionRestException, UnknownJobRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/resultmap")
    @Produces(value={"application/json"})
    public Map<String, String> jobResultMap(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, PermissionRestException, UnknownJobRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/info")
    @Produces(value={"application/json"})
    public JobInfoData jobInfo(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, PermissionRestException, UnknownJobRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/result/value")
    @Produces(value={"application/json"})
    public Map<String, String> jobResultValue(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, PermissionRestException, UnknownJobRestException;

    @DELETE
    @Path(value="jobs/{jobid}")
    @Produces(value={"application/json"})
    public boolean removeJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/log/server")
    @Produces(value={"application/json"})
    public String jobServerLog(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/kill")
    @Produces(value={"application/json"})
    public boolean killJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/tasks")
    @Produces(value={"application/json"})
    public RestPage<String> getTasksNames(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/paginated")
    @Produces(value={"application/json"})
    public RestPage<String> getTasksNamesPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="-1") int var4) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<String> getJobTasksIdsByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/paginated")
    @Produces(value={"application/json"})
    public RestPage<String> getJobTasksIdsByTagPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3, @QueryParam(value="offset") @DefaultValue(value="0") int var4, @QueryParam(value="limit") @DefaultValue(value="-1") int var5) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="tasks")
    @Produces(value={"application/json"})
    public RestPage<String> getTaskIds(@HeaderParam(value="sessionid") String var1, @QueryParam(value="from") @DefaultValue(value="0") long var2, @QueryParam(value="to") @DefaultValue(value="0") long var4, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var6, @QueryParam(value="running") @DefaultValue(value="true") boolean var7, @QueryParam(value="pending") @DefaultValue(value="true") boolean var8, @QueryParam(value="finished") @DefaultValue(value="true") boolean var9, @QueryParam(value="offset") @DefaultValue(value="0") int var10, @QueryParam(value="limit") @DefaultValue(value="-1") int var11) throws NotConnectedRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="tasks/tag/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<String> getTaskIdsByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="tasktag") String var2, @QueryParam(value="from") @DefaultValue(value="0") long var3, @QueryParam(value="to") @DefaultValue(value="0") long var5, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var7, @QueryParam(value="running") @DefaultValue(value="true") boolean var8, @QueryParam(value="pending") @DefaultValue(value="true") boolean var9, @QueryParam(value="finished") @DefaultValue(value="true") boolean var10, @QueryParam(value="offset") @DefaultValue(value="0") int var11, @QueryParam(value="limit") @DefaultValue(value="-1") int var12) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/tags")
    @Produces(value={"application/json"})
    public List<String> getJobTaskTags(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/tags/startsWith/{prefix}")
    @Produces(value={"application/json"})
    public List<String> getJobTaskTagsPrefix(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="prefix") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/html")
    @Produces(value={"application/json;charset=utf-8"})
    public String getJobHtml(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws IOException, NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/xml")
    @Produces(value={"application/xml"})
    public String getJobContent(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException, SubmissionClosedRestException, JobCreationRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStates(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="50") int var4) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/filtered/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesFilteredPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="50") int var4, @QueryParam(value="statusFilter") @DefaultValue(value="") String var5) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/{tasktag}/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesByTagPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3, @QueryParam(value="offset") @DefaultValue(value="0") int var4, @QueryParam(value="limit") @DefaultValue(value="50") int var5) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/taskstates/{tasktag}/{statusFilter}/paginated")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getJobTaskStatesByTagByStatusPaginated(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="offset") @DefaultValue(value="0") int var3, @QueryParam(value="limit") @DefaultValue(value="50") int var4, @PathParam(value="tasktag") String var5, @PathParam(value="statusFilter") String var6) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="taskstates")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getTaskStates(@HeaderParam(value="sessionid") String var1, @QueryParam(value="from") @DefaultValue(value="0") long var2, @QueryParam(value="to") @DefaultValue(value="0") long var4, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var6, @QueryParam(value="running") @DefaultValue(value="true") boolean var7, @QueryParam(value="pending") @DefaultValue(value="true") boolean var8, @QueryParam(value="finished") @DefaultValue(value="true") boolean var9, @QueryParam(value="offset") @DefaultValue(value="0") int var10, @QueryParam(value="limit") @DefaultValue(value="-1") int var11, @QueryParam(value="sortparameters") SortSpecifierContainer var12) throws NotConnectedRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="taskstates/tag/{tasktag}")
    @Produces(value={"application/json"})
    public RestPage<TaskStateData> getTaskStatesByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="tasktag") String var2, @QueryParam(value="from") @DefaultValue(value="0") long var3, @QueryParam(value="to") @DefaultValue(value="0") long var5, @QueryParam(value="mytasks") @DefaultValue(value="false") boolean var7, @QueryParam(value="running") @DefaultValue(value="true") boolean var8, @QueryParam(value="pending") @DefaultValue(value="true") boolean var9, @QueryParam(value="finished") @DefaultValue(value="true") boolean var10, @QueryParam(value="offset") @DefaultValue(value="0") int var11, @QueryParam(value="limit") @DefaultValue(value="-1") int var12, @QueryParam(value="sortparameters") SortSpecifierContainer var13) throws NotConnectedRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/log/full")
    @Produces(value={"application/json"})
    public InputStream jobFullLogs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @QueryParam(value="sessionid") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException, IOException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/result/log/all")
    @Produces(value={"application/json"})
    public String jobLogs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @GET
    @Path(value="jobs/{jobid}/tasks/{taskname}")
    @Produces(value={"application/json"})
    public TaskStateData jobTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException, UnknownTaskRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/value")
    @Produces(value={"*/*"})
    public Serializable valueOfTaskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws Throwable;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/value")
    @Produces(value={"application/json"})
    public Map<String, String> valueOfTaskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws Throwable;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/metadata")
    @Produces(value={"*/*"})
    public Map<String, String> metadataOfTaskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws Throwable;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/metadata")
    @Produces(value={"application/json"})
    public Map<String, Map<String, String>> metadataOfTaskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws Throwable;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/results/precious/metadata")
    @Produces(value={"application/json"})
    public List<String> getPreciousTaskName(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/serializedvalue")
    @Produces(value={"*/*"})
    public byte[] serializedValueOfTaskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws Throwable;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/serializedvalue")
    @Produces(value={"application/json"})
    public Map<String, byte[]> serializedValueOfTaskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws Throwable;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result")
    @Produces(value={"application/json"})
    public TaskResultData taskResult(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result")
    @Produces(value={"application/json"})
    public List<TaskResultData> taskResultByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/all")
    @Produces(value={"application/json"})
    public String taskLog(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/log/all")
    @Produces(value={"application/json"})
    public String taskLogByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/err")
    @Produces(value={"application/json"})
    public String taskLogErr(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/log/err")
    @Produces(value={"application/json"})
    public String taskLogErrByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/out")
    @Produces(value={"application/json"})
    public String taskLogout(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/result/log/out")
    @Produces(value={"application/json"})
    public String taskLogoutByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/result/log/full")
    @Produces(value={"application/json"})
    public InputStream taskFullLogs(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3, @QueryParam(value="sessionid") String var4) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException, IOException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/{taskname}/log/server")
    @Produces(value={"application/json"})
    public String taskServerLog(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/tasks/tag/{tasktag}/log/server")
    @Produces(value={"application/json"})
    public String taskServerLogByTag(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="tasktag") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/pause")
    @Produces(value={"application/json"})
    public boolean pauseJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/restartAllInErrorTasks")
    @Produces(value={"application/json"})
    public boolean restartAllInErrorTasks(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/resume")
    @Produces(value={"application/json"})
    public boolean resumeJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @POST
    @Path(value="submitflat")
    @Produces(value={"application/json"})
    public JobIdData submitFlat(@HeaderParam(value="sessionid") String var1, @FormParam(value="commandFileContent") String var2, @FormParam(value="jobName") String var3, @FormParam(value="selectionScriptContent") String var4, @FormParam(value="selectionScriptExtension") String var5) throws NotConnectedRestException, IOException, JobCreationRestException, PermissionRestException, SubmissionClosedRestException;

    @POST
    @Path(value="{path:submit}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public JobIdData submit(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, MultipartFormDataInput var3, @Context UriInfo var4) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @GET
    @Path(value="jobs/{jobid}/{path:resubmit}")
    @Produces(value={"application/json"})
    public JobIdData reSubmit(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="path") PathSegment var3, @Context UriInfo var4) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException, UnknownJobRestException;

    @Consumes(value={"application/json"})
    @POST
    @Path(value="{path:plannings}")
    @Produces(value={"application/json"})
    public String submitPlannings(@HeaderParam(value="sessionid") String var1, @PathParam(value="path") PathSegment var2, Map<String, String> var3) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @POST
    @Path(value="jobs")
    @Produces(value={"application/json"})
    public JobIdData submitFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @PathParam(value="path") PathSegment var3, @Context UriInfo var4) throws JobCreationRestException, NotConnectedRestException, PermissionRestException, SubmissionClosedRestException, IOException;

    @POST
    @Path(value="dataspace/{spaceName:[a-zA-Z][a-zA-Z_0-9]*}{filePath:.*}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public boolean pushFile(@HeaderParam(value="sessionid") String var1, @PathParam(value="spaceName") String var2, @PathParam(value="filePath") String var3, MultipartFormDataInput var4) throws IOException, NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="dataspace/{spaceName:[a-zA-Z][a-zA-Z_0-9]*}{filePath:.*}")
    @Produces(value={"application/octet-stream"})
    public InputStream pullFile(@HeaderParam(value="sessionid") String var1, @PathParam(value="spaceName") String var2, @PathParam(value="filePath") String var3) throws IOException, NotConnectedRestException, PermissionRestException;

    @DELETE
    @Path(value="dataspace/{spaceName:[a-zA-Z][a-zA-Z_0-9]*}{filePath:.*}")
    @Produces(value={"application/json"})
    public boolean deleteFile(@HeaderParam(value="sessionid") String var1, @PathParam(value="spaceName") String var2, @PathParam(value="filePath") String var3) throws IOException, NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="disconnect")
    @Produces(value={"application/json"})
    public void disconnect(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="pause")
    @Produces(value={"application/json"})
    public boolean pauseScheduler(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="stop")
    @Produces(value={"application/json"})
    public boolean stopScheduler(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="resume")
    @Produces(value={"application/json"})
    public boolean resumeScheduler(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/priority/byname/{name}")
    public void schedulerChangeJobPriorityByName(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="name") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException, JobAlreadyFinishedRestException;

    @PUT
    @Path(value="jobs/{jobid}/priority/byvalue/{value}")
    public void schedulerChangeJobPriorityByValue(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="value") String var3) throws NumberFormatException, NotConnectedRestException, UnknownJobRestException, PermissionRestException, JobAlreadyFinishedRestException;

    @PUT
    @Path(value="freeze")
    @Produces(value={"application/json"})
    public boolean freezeScheduler(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    public SchedulerStatusData getSchedulerStatus(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="start")
    @Produces(value={"application/json"})
    public boolean startScheduler(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="kill")
    @Produces(value={"application/json"})
    public boolean killScheduler(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="shutdown")
    @Produces(value={"application/json"})
    public boolean shutdownScheduler(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @POST
    @Path(value="linkrm")
    @Produces(value={"application/json"})
    public boolean linkRm(@HeaderParam(value="sessionid") String var1, @FormParam(value="rmurl") String var2) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="isconnected")
    @Produces(value={"application/json"})
    public boolean isConnected(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="login")
    @Produces(value={"application/json"})
    public String login(@FormParam(value="username") String var1, @FormParam(value="password") String var2) throws LoginException, SchedulerRestException;

    @PUT
    @Path(value="session")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String loginOrRenewSession(@HeaderParam(value="sessionid") String var1, @FormParam(value="username") String var2, @FormParam(value="password") String var3) throws SchedulerRestException, LoginException, NotConnectedRestException;

    @PUT
    @Path(value="session")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String loginOrRenewSession(@HeaderParam(value="sessionid") String var1, @MultipartForm LoginForm var2) throws KeyException, SchedulerRestException, LoginException, NotConnectedRestException;

    @GET
    @Path(value="logins/sessionid/{sessionId}")
    @Produces(value={"application/json"})
    public String getLoginFromSessionId(@PathParam(value="sessionId") String var1);

    @GET
    @Path(value="logins/sessionid/{sessionId}/userdata")
    @Produces(value={"application/json"})
    public UserData getUserDataFromSessionId(@PathParam(value="sessionId") String var1);

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="login")
    @Produces(value={"application/json"})
    public String loginWithCredential(@MultipartForm LoginForm var1) throws KeyException, LoginException, SchedulerRestException;

    @GET
    @GZIP
    @Path(value="users")
    @Produces(value={"application/json"})
    public List<SchedulerUserData> getUsers(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="userspace")
    @Produces(value={"application/json"})
    public List<String> userspaceURIs(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="globalspace")
    @Produces(value={"application/json"})
    public List<String> globalspaceURIs(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="userswithjobs")
    @Produces(value={"application/json"})
    public List<SchedulerUserData> getUsersWithJobs(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="stats")
    @Produces(value={"application/json"})
    public Map<String, String> getStatistics(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="stats/myaccount")
    @Produces(value={"application/json"})
    public Map<String, String> getStatisticsOnMyAccount(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="createcredential")
    @Produces(value={"*/*"})
    public byte[] getCreateCredential(@MultipartForm LoginForm var1) throws LoginException, SchedulerRestException;

    @GET
    @Path(value="usage/myaccount")
    @Produces(value={"application/json"})
    public List<JobUsageData> getUsageOnMyAccount(@HeaderParam(value="sessionid") String var1, @QueryParam(value="startdate") Date var2, @QueryParam(value="enddate") Date var3) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="usage/account")
    @Produces(value={"application/json"})
    public List<JobUsageData> getUsageOnAccount(@HeaderParam(value="sessionid") String var1, @QueryParam(value="user") String var2, @QueryParam(value="startdate") Date var3, @QueryParam(value="enddate") Date var4) throws NotConnectedRestException, PermissionRestException;

    @GET
    @GZIP
    @Path(value="jobs/{jobid}/livelog")
    @Produces(value={"application/json"})
    public String getLiveLogJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException, LogForwardingRestException, IOException;

    @GET
    @Path(value="jobs/{jobid}/livelog/available")
    @Produces(value={"application/json"})
    public int getLiveLogJobAvailable(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException;

    @DELETE
    @Path(value="jobs/{jobid}/livelog")
    @Produces(value={"application/json"})
    public boolean deleteLiveLogJob(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2) throws NotConnectedRestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/restart")
    @Produces(value={"application/json"})
    public boolean restartTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/finishInErrorTask")
    @Produces(value={"application/json"})
    public boolean finishInErrorTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/restartInErrorTask")
    @Produces(value={"application/json"})
    public boolean restartInErrorTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/preempt")
    @Produces(value={"application/json"})
    public boolean preemptTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/tasks/{taskname}/kill")
    @Produces(value={"application/json"})
    public boolean killTask(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="taskname") String var3) throws NotConnectedRestException, UnknownJobRestException, UnknownTaskRestException, PermissionRestException;

    @POST
    @Path(value="{path:validate}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public JobValidationData validate(@PathParam(value="path") PathSegment var1, MultipartFormDataInput var2);

    @POST
    @Path(value="{path:validateurl}")
    @Produces(value={"application/json"})
    public JobValidationData validateFromUrl(@HeaderParam(value="sessionid") String var1, @HeaderParam(value="link") String var2, @PathParam(value="path") PathSegment var3) throws NotConnectedRestException;

    @POST
    @Path(value="/credentials/{key}")
    public void putThirdPartyCredential(@HeaderParam(value="sessionid") String var1, @PathParam(value="key") String var2, @FormParam(value="value") String var3) throws NotConnectedRestException, PermissionRestException, SchedulerRestException;

    @DELETE
    @Path(value="/credentials/{key}")
    public void removeThirdPartyCredential(@HeaderParam(value="sessionid") String var1, @PathParam(value="key") String var2) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="/credentials/")
    @Produces(value={"application/json"})
    public Set<String> thirdPartyCredentialsKeySet(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @PUT
    @Path(value="jobs/{jobid}/startat/{startAt}")
    @Produces(value={"application/json"})
    public boolean changeStartAt(@HeaderParam(value="sessionid") String var1, @PathParam(value="jobid") String var2, @PathParam(value="startAt") String var3) throws NotConnectedRestException, UnknownJobRestException, PermissionRestException;

    @GET
    @Path(value="configuration/portal")
    @Produces(value={"application/json"})
    public Map<Object, Object> getPortalConfiguration(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="properties")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchedulerPropertiesFromSessionId(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException;

    @GET
    @Path(value="job/{jobid}/permission/{method}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public boolean checkJobPermissionMethod(String var1, String var2, String var3) throws NotConnectedRestException, UnknownJobRestException;
}

