# -*- coding: utf-8 -*-
##
## Copyright (C) 2008 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""
Plone Article migration module from 4.1 betas to 4.1 final releases
"""
__version__ = "$Revision:  $"
# $Source:  $
# $Id:  $
__docformat__ = 'restructuredtext'

def stable419_4110(portal):
    """Reindexing Subject on all artices subcontents such they are not
    found on keyword searches
    """
    catalog = portal.portal_catalog
    types_to_reindex = ['FileInnerContentProxy', 'ImageInnerContentProxy',
        'LinkInnerContentProxy', 'InnerContentContainer']
    for brain in catalog.searchResults(portal_type=types_to_reindex):
        try:
            content = brain.getObject()
        except Exception:
            # Ghost brain ?
            continue
        content.reindexObject(idxs=['Subject'])
    return
