/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.SpelValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.ParseException;

public class SPELParserValidator
extends BaseParserValidator<String> {
    public static final String SPEL_TYPE = "SPEL";
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String SPEL_TYPE_REGEXP = "[Ss][Pp][Ee][Ll]";
    protected static final String LEFT_DELIMITER_REGEXP = "\\(";
    protected static final String RIGHT_DELIMITER_REGEXP = "\\)";

    public SPELParserValidator(String model) throws ModelSyntaxException {
        super(model);
    }

    @Override
    public String getType() {
        return SPEL_TYPE;
    }

    @Override
    public String getTypeRegexp() {
        return SPEL_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return String.class;
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        String spelRegexp = "^[Ss][Pp][Ee][Ll]\\((.+)\\)$";
        String spelString = this.parseAndGetOneGroup(model, spelRegexp);
        try {
            return new SpelValidator(spelString);
        }
        catch (ParseException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

