"""
setup
-----
"""

from Cython.Build import cythonize
from setuptools import setup, find_packages
from setuptools.extension import Extension


extensions = [
    Extension(
        ".cPadding",
        ["./Padding.*"],
        include_dirs=[],
        libraries=[],
    )
]

setup(
    name="cPadding",
    description="Padding methods for password based encryption",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/initbar/cPadding",
    author="Herbert Shin",
    author_email="h@init.bar",
    version="0.0.1",
    license="MIT",
    install_requires=["Cython==0.29.4"],
    python_requires=">=2.7",
    packages=find_packages(),
    ext_modules = cythonize(Extension("cPadding", sources=["Padding.pyx"])),
    zip_safe=False,
    classifiers=[
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
    ],
)
