/**
 * (This file was autogenerated by hob)
 *
 * @fileoverview
 * Various utility functions used by the code generated by hob
 */

/**
 * Cookie handling functions
 */
window.cookies = new function()
{
  /**
   * Set a cookie named "key" to the value "value" with expiry in "time "
   * seconds. If time is not set, time out after a year
   */
  this.set = function(key, value, time) 
  {
    document.cookie = (
      key + "=" + encodeURIComponent(value) +
      "; expires=" + 
      ( new Date( new Date().getTime() + ( time || 360*24*60*60*1000 ) ) ).toGMTString() + 
      "; path=/");
    return value;
  }

  /**
   * Get a cookie with name "key"
   */
  this.get = function(key) 
  {
    var value = new RegExp(key + "=([^;]*)").exec(document.cookie);
    return value && decodeURIComponent(value[1]);
  }

}

/**
 * Convenience function for loading a resource with XHR using the get method.
 * Will automatically append a "time" guery argument to avoid caching.
 * When the load is finished, callback will be invoced with context as its
 * "this" value
 */
XMLHttpRequest.prototype.loadResource = function(url, callback, context)
{
  this.onload = function()
  {
    callback(this, context);
  }
  this.open('GET', url + "?time=" + new Date().getTime() );
  this.send(null);
}