#!/usr/bin/env python

"""Visualize CladeCompare output file(s) in an HTML page.

If given one file:
    Display foreground and background consensus sequences as 2 rows, wrapped.
    Color of foreground cells corresponds to p-value (#stars).

If given multiple files:
    Display all foreground consensus sequences as N rows, wrapped.
    Background is [undecided] either the bottom row, if the same across all
    input seqs, or a separate block, or just not shown.
    Color of foreground cells corresponds to p-value (#stars).

"""

import argparse 
import logging

from cladecomparelib.report import do_single, do_multi, html_page_tpl


logging.basicConfig(level=logging.INFO,
                    format="%(module)s [@%(lineno)s]: %(message)s")

AP = argparse.ArgumentParser(__doc__)
AP.add_argument('outfiles', nargs='+',
                help="Output file(s) generated by cladecompare.py")
AP.add_argument('-p', '--pattern', 
                help="Pattern file (.pttrn) generated by cladecompare.py")
args = AP.parse_args()

if len(args.outfiles) == 1:
    title, contents = do_single(args.outfiles[0], args.pattern)
else:
    title, contents = do_multi(args.outfiles, args.pattern)
print html_page_tpl % dict(title=title, contents=contents)

