# -*- coding: utf-8 -*-
from pkg_resources import Requirement, resource_filename
from .rest_univmax import rest_functions
try:
    import ConfigParser as Config
except ImportError:
    import configparser as Config
import logging.config


__title__ = 'requests'
__version__ = '0.1'
__author__ = 'Dell EMC or its subsidieries'
__license__ = 'MIT'
__copyright__ = 'Copyright 2016 Dell EMC Inc'

# register configuration file
filename = resource_filename(Requirement.parse("PyU4V"), "PyU4V.conf")
LOG = logging.getLogger('PyU4V')
CONF_FILE = filename
logging.config.fileConfig(CONF_FILE)
CFG = Config.ConfigParser()
CFG.read(CONF_FILE)

