from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音轉方音符號吳守禮改良式模組 import 臺灣閩南語羅馬字拼音對照吳守禮方音聲母表
from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音轉方音符號吳守禮改良式模組 import 臺灣閩南語羅馬字拼音對照吳守禮方音韻母表
from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音轉方音符號吳守禮改良式模組 import 臺灣閩南語羅馬字拼音對照吳守禮方音聲調表
import re


_吳守禮方音對照臺灣閩南語羅馬字拼音聲母表 = {}
_吳守禮方音對照臺灣閩南語羅馬字拼音韻母表 = {}
_吳守禮方音對照臺灣閩南語羅馬字拼音聲調表 = {}
for 臺羅, 方音 in 臺灣閩南語羅馬字拼音對照吳守禮方音聲母表.items():
    _吳守禮方音對照臺灣閩南語羅馬字拼音聲母表[方音] = 臺羅.rstrip('i')
for 臺羅, 方音 in 臺灣閩南語羅馬字拼音對照吳守禮方音韻母表.items():
    _吳守禮方音對照臺灣閩南語羅馬字拼音韻母表[方音] = 臺羅
for 臺羅, 方音 in 臺灣閩南語羅馬字拼音對照吳守禮方音聲調表.items():
    if 臺羅 in ['1', '2', '3', '5', '7', '8', '9']:
        _吳守禮方音對照臺灣閩南語羅馬字拼音聲調表[方音] = 臺羅


class 方音符號吳守禮改良式:
    方音拼法 = re.compile('(˙|)({})({})({})\Z'.format(
                      '|'.join(_吳守禮方音對照臺灣閩南語羅馬字拼音聲母表),
                      '|'.join(_吳守禮方音對照臺灣閩南語羅馬字拼音韻母表),
                      '|'.join(_吳守禮方音對照臺灣閩南語羅馬字拼音聲調表),
                      )
                      )

    def __init__(self, 注音符號):
        第八調 = False
        if '㆐' in 注音符號:
            第八調 = True
            無第八調注音符號 = 注音符號.replace('㆐', '')
        else:
            無第八調注音符號 = 注音符號.replace('㆐', '')
        對應物件 = self.方音拼法.match(無第八調注音符號)
        if 對應物件 is None:
            self.音標 = None
        else:
            self.音標 = 注音符號
            self.輕, self.聲, self.韻, self.調 = 對應物件.group(1, 2, 3, 4)
            if 第八調:
                self.調 = '㆐'

    def 轉換到臺灣閩南語羅馬字拼音(self):
        if self.音標 is None:
            return None
        if self.輕:
            輕 = '0'
        else:
            輕 = ''
        韻 = _吳守禮方音對照臺灣閩南語羅馬字拼音韻母表[self.韻]
        調 = _吳守禮方音對照臺灣閩南語羅馬字拼音聲調表[self.調]
        if 調 == '1' and 韻[-1] in ['h', 'p', 't', 'k']:
            調 = '4'
        return ''.join([
                       輕,
                       _吳守禮方音對照臺灣閩南語羅馬字拼音聲母表[self.聲],
                       韻,
                       調,
                       ])

    def 預設音標(self):
        return self.轉換到臺灣閩南語羅馬字拼音()
