/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.util.CancelTask;

public class AggregationNew
extends Aggregation {
    public AggregationNew(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, AggregationIF.Type.JOIN_NEW, recheckS);
    }

    protected void buildDataset(boolean isNew, CancelTask cancelTask) throws IOException {
        DataType coordType;
        this.buildCoords(cancelTask);
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, isNew ? null : new Aggregation.MyReplaceVariableCheck());
        String dimName = this.getDimensionName();
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(dimName);
        if (joinAggCoord == null) {
            coordType = this.getCoordinateType();
            joinAggCoord = new VariableDS(this.ncDataset, null, null, dimName, coordType, dimName, null, null);
            this.ncDataset.addVariable(null, joinAggCoord);
        } else {
            coordType = joinAggCoord.getDataType();
            joinAggCoord.setDimensions(dimName);
            if (!isNew) {
                joinAggCoord.setCachedData(null, false);
            }
        }
        joinAggCoord.setProxyReader(this);
        if (this.isDate()) {
            joinAggCoord.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
        }
        for (String varname : this.getVariables()) {
            Variable aggVar = this.ncDataset.getRootGroup().findVariable(varname);
            if (aggVar == null) {
                logger.error(this.ncDataset.getLocation() + " aggNewDimension cant find variable " + varname);
                continue;
            }
            VariableDS vagg = new VariableDS(this.ncDataset, null, null, aggVar.getShortName(), aggVar.getDataType(), dimName + " " + aggVar.getDimensionsString(), null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(aggVar, vagg);
            Attribute att = vagg.findAttribute("_CoordinateAxes");
            if (att != null) {
                String axes = dimName + " " + att.getStringValue();
                vagg.addAttribute(new Attribute("_CoordinateAxes", axes));
            }
            this.ncDataset.removeVariable(null, aggVar.getShortName());
            this.ncDataset.addVariable(null, vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        this.ncDataset.finish();
        this.makeProxies(typicalDataset, this.ncDataset);
        typical.close();
    }
}

