/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.ddf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import loci.poi.ddf.EscherArrayProperty;
import loci.poi.ddf.EscherBoolProperty;
import loci.poi.ddf.EscherComplexProperty;
import loci.poi.ddf.EscherProperties;
import loci.poi.ddf.EscherProperty;
import loci.poi.ddf.EscherRGBProperty;
import loci.poi.ddf.EscherShapePathProperty;
import loci.poi.ddf.EscherSimpleProperty;
import loci.poi.util.LittleEndian;

public class EscherPropertyFactory {
    public List createProperties(byte[] data, int offset, short numProperties) {
        ArrayList<EscherProperty> results = new ArrayList<EscherProperty>();
        int pos = offset;
        for (int i = 0; i < numProperties; ++i) {
            short propId = LittleEndian.getShort(data, pos);
            int propData = LittleEndian.getInt(data, pos + 2);
            short propNumber = (short)(propId & 0x3FFF);
            boolean isComplex = (propId & Short.MIN_VALUE) != 0;
            boolean isBlipId = (propId & 0x4000) != 0;
            byte propertyType = EscherProperties.getPropertyType(propNumber);
            if (propertyType == 1) {
                results.add(new EscherBoolProperty(propId, propData));
            } else if (propertyType == 2) {
                results.add(new EscherRGBProperty(propId, propData));
            } else if (propertyType == 3) {
                results.add(new EscherShapePathProperty(propId, propData));
            } else if (!isComplex) {
                results.add(new EscherSimpleProperty(propId, propData));
            } else if (propertyType == 5) {
                results.add(new EscherArrayProperty(propId, new byte[propData]));
            } else {
                results.add(new EscherComplexProperty(propId, new byte[propData]));
            }
            pos += 6;
        }
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            EscherProperty p = (EscherProperty)iterator.next();
            if (!(p instanceof EscherComplexProperty)) continue;
            if (p instanceof EscherArrayProperty) {
                pos += ((EscherArrayProperty)p).setArrayData(data, pos);
                continue;
            }
            byte[] complexData = ((EscherComplexProperty)p).getComplexData();
            System.arraycopy(data, pos, complexData, 0, complexData.length);
            pos += complexData.length;
        }
        return results;
    }
}

