# -*- coding: utf-8 -*-
from 臺灣言語工具.翻譯.摩西工具.語句編碼器 import 語句編碼器
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.解析整理.物件譀鏡 import 物件譀鏡
from 臺灣言語工具.解析整理.字物件篩仔 import 字物件篩仔
from 臺灣言語工具.基本元素.公用變數 import 分詞符號

_分析器 = 拆文分析器()
_譀鏡 = 物件譀鏡()
_篩仔 = 字物件篩仔()


def _斷詞轉斷字編碼(self, 斷詞語句):
    句物件 = _分析器.轉做句物件(斷詞語句)
    字陣列 = _篩仔.篩出字物件(句物件)
    孤字 = []
    for 字物件 in 字陣列:
        孤字.append(_譀鏡.看分詞(字物件))
    斷字語句 = 分詞符號.join(孤字)
    return super(self.__class__, self).編碼(斷字語句)


def 斷詞轉斷字編碼器():
    return type('斷詞編碼器', (語句編碼器,), {'編碼': _斷詞轉斷字編碼})
