/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.brunel.data.Field;
import org.brunel.data.summary.DimensionField;
import org.brunel.data.summary.Fit;

public class MeasureField
extends DimensionField {
    public final String measureFunction;
    public String option;
    public Map<String, Fit> fits = new HashMap<String, Fit>();

    public MeasureField(Field field, String rename, String measureFunction) {
        super(field, rename == null && field == null ? measureFunction : rename);
        this.measureFunction = field != null && measureFunction.equals("mean") && !field.isNumeric() ? "mode" : measureFunction;
    }

    public Fit getFit(ArrayList<Field> groupFields, int index) {
        return this.fits.get(this.makeKey(groupFields, index));
    }

    public void setFit(ArrayList<Field> groupFields, int index, Fit fit) {
        this.fits.put(this.makeKey(groupFields, index), fit);
    }

    private String makeKey(ArrayList<Field> groupFields, int index) {
        String key = "|";
        for (Field f : groupFields) {
            key = key + f.value(index) + "|";
        }
        return key;
    }

    public boolean isPercent() {
        return this.measureFunction.equals("percent");
    }

    @Override
    public String toString() {
        if (this.field != null && this.field.name.equals(this.rename)) {
            return this.label();
        }
        return this.label() + "[->" + this.rename + "]";
    }

    @Override
    public String label() {
        if (this.measureFunction.equals("sum") && this.field.name.equals("#count")) {
            return this.field.label;
        }
        if (this.measureFunction.equals("percent") && this.field.name.equals("#count")) {
            return "Percent";
        }
        String a = this.measureFunction.substring(0, 1).toUpperCase();
        String b = this.measureFunction.substring(1);
        return a + b + "(" + (this.field == null ? "" : this.field.label) + ")";
    }
}

