/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.stats;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.brunel.data.Data;
import org.brunel.data.Field;

public class NominalStats {
    public static void populate(Field f) {
        Object[] naturalOrder;
        HashMap<Object, Integer> count = new HashMap<Object, Integer>();
        HashSet<Object> modes = new HashSet<Object>();
        int N = f.rowCount();
        int maxCount = 0;
        int valid = 0;
        for (int i = 0; i < N; ++i) {
            Object o = f.value(i);
            if (o == null) continue;
            ++valid;
            Integer c = (Integer)count.get(o);
            int value = c == null ? 1 : c + 1;
            count.put(o, value);
            if (value > maxCount) {
                modes.clear();
            }
            if (value < maxCount) continue;
            modes.add(o);
            maxCount = value;
        }
        f.set("n", N);
        f.set("unique", count.size());
        f.set("valid", valid);
        if (modes.isEmpty()) {
            f.set("mode", null);
        } else {
            Object[] sortedModes = modes.toArray(new Object[modes.size()]);
            Data.sort(sortedModes);
            f.set("mode", sortedModes[(sortedModes.length - 1) / 2]);
        }
        if (f.propertyTrue("categoriesOrdered")) {
            naturalOrder = f.categories();
        } else {
            if (f.name.equals("#selection")) {
                if (!count.containsKey("\u2717")) {
                    count.put("\u2717", 0);
                }
                if (!count.containsKey("\u2713")) {
                    count.put("\u2713", 0);
                }
                naturalOrder = new Object[]{"\u2717", "\u2713"};
            } else {
                Set cats = count.keySet();
                naturalOrder = cats.toArray(new Object[cats.size()]);
                Data.sort(naturalOrder);
            }
            f.set("categories", naturalOrder);
        }
        int[] counts = new int[naturalOrder.length];
        for (int i = 0; i < naturalOrder.length; ++i) {
            counts[i] = (Integer)count.get(naturalOrder[i]);
        }
        f.set("categoryCounts", counts);
    }

    public static boolean creates(String key) {
        return "n".equals(key) || "mode".equals(key) || "unique".equals(key) || "valid".equals(key) || "categories".equals(key) || "categoryCounts".equals(key);
    }
}

