/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.HashMap;
import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.auto.NumericScale;
import org.brunel.data.modify.DataOperation;
import org.brunel.data.summary.FieldRowComparison;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.Range;

public class Transform
extends DataOperation {
    public static Dataset transform(Dataset base, String command) {
        if (base.rowCount() == 0) {
            return base;
        }
        List<String[]> operations = Transform.map(command, "=");
        if (operations == null) {
            return base;
        }
        Field[] fields = new Field[base.fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String op = null;
            for (String[] o : operations) {
                if (!o[0].equals(base.fields[i].name)) continue;
                op = o[1];
            }
            fields[i] = Transform.modify(base.fields[i], op);
        }
        return base.replaceFields(fields);
    }

    private static Field modify(Field field, String operation) {
        String option;
        if (operation == null) {
            return field;
        }
        String[] parts = operation.split(":");
        String name = parts[0].trim();
        String string = option = parts.length > 1 ? parts[1].trim() : null;
        if (name.equals("bin")) {
            int desiredBinCount = option == null ? -1 : Integer.parseInt(option);
            return Transform.bin(field, desiredBinCount);
        }
        if (name.equals("rank")) {
            return Transform.rank(field, "ascending".equals(option));
        }
        return field;
    }

    private static Field rank(Field f, boolean ascending) {
        int N = f.rowCount();
        FieldRowComparison comparison = new FieldRowComparison(new Field[]{f}, new boolean[]{ascending}, true);
        int[] order = comparison.makeSortedOrder(N);
        Object[] ranks = new Object[N];
        int p = 0;
        while (p < N) {
            int q;
            int rowP = order[p];
            for (q = p + 1; q < N && f.compareRows(rowP, order[q]) == 0; ++q) {
            }
            for (int i = p; i < q; ++i) {
                ranks[order[i]] = (double)(p + q + 1) / 2.0;
            }
            p = q;
        }
        Field result = Data.makeColumnField(f.name, f.label, ranks);
        result.set("numeric", true);
        return result;
    }

    public static Field bin(Field f, int desiredBinCount) {
        Field field = f.preferCategorical() ? Transform.binCategorical(f, desiredBinCount) : Transform.binNumeric(f, desiredBinCount);
        field.set("binned", true);
        return field;
    }

    private static Field binCategorical(Field f, int desiredBinCount) {
        Object[] categories;
        if (desiredBinCount < 1) {
            desiredBinCount = 7;
        }
        if ((categories = f.categories()).length <= desiredBinCount) {
            return f;
        }
        Integer[] order = Data.order((int[])f.property("categoryCounts"), false);
        HashMap<Object, Object> newNames = new HashMap<Object, Object>();
        for (int i = 0; i < order.length; ++i) {
            newNames.put(categories[order[i]], i < desiredBinCount - 1 ? categories[order[i]] : "\u2026");
        }
        Object[] data = new Object[f.rowCount()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = newNames.get(f.value(i));
        }
        return Data.makeColumnField(f.name, f.label, data);
    }

    private static Field binNumeric(Field f, int desiredBinCount) {
        NumericScale scale = Auto.makeNumericScale(f, true, new double[]{0.0, 0.0}, 0.0, desiredBinCount + 1, true);
        Double[] divisions = scale.divisions;
        boolean isDate = f.isDate();
        DateFormat dateFormat = isDate ? (DateFormat)((Object)f.property("dateFormat")) : null;
        Range[] ranges = Transform.makeBinRanges(divisions, dateFormat, scale.granular);
        Object[] data = Transform.binData(f, divisions, ranges);
        Field result = Data.makeColumnField(f.name, f.label, data);
        if (f.isDate()) {
            result.set("date", true);
        }
        result.set("numeric", true);
        result.set("categories", ranges);
        result.set("transform", f.property("transform"));
        return result;
    }

    private static Range[] makeBinRanges(Double[] divisions, DateFormat dateFormat, boolean nameByCenter) {
        Range[] ranges = new Range[divisions.length - 1];
        for (int i = 0; i < ranges.length; ++i) {
            Double a = divisions[i];
            Double b = divisions[i + 1];
            ranges[i] = dateFormat == null ? Range.makeNumeric(a, b, nameByCenter) : Range.makeDate(a, b, nameByCenter, dateFormat);
        }
        return ranges;
    }

    private static Object[] binData(Field f, Double[] divisions, Range[] ranges) {
        Object[] data = new Object[f.rowCount()];
        for (int i = 0; i < data.length; ++i) {
            Double d = Data.asNumeric(f.value(i));
            if (d == null) continue;
            int n = Data.indexOf(d, divisions);
            data[i] = ranges[Math.min(n, ranges.length - 1)];
        }
        return data;
    }
}

