/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.match;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.brunel.action.Action;
import org.brunel.action.ActionUtil;
import org.brunel.action.Param;
import org.brunel.build.util.DataCache;
import org.brunel.data.Dataset;
import org.brunel.match.ActionChoice;
import org.brunel.match.ActionParameterChoice;
import org.brunel.match.BestActionParameterSet;
import org.brunel.model.VisItem;

public class BestMatch {
    private static final int PARAMETER_CHOICE_MAX = 20;

    public static Action match(Dataset originalData, Dataset newData, Action a) {
        ArrayList<BestActionParameterSet> parmSets = BestMatch.buildActionParameterSets(originalData, newData, a);
        ArrayList<ActionChoice> choices = BestMatch.buildActionChoices(a, parmSets);
        return ((ActionChoice)choices.get(0)).getAction();
    }

    public static Action match(String brunel, String newData) throws IOException {
        Action action = Action.parse(brunel);
        VisItem item = action.apply(null);
        if (item.getDataSets().length != 1) {
            throw new IllegalStateException("Data matching currently only supports Brunel syntax with a single data source. Could not match for Brunel: " + brunel);
        }
        Dataset originalDataset = item.getDataSets()[0];
        Dataset newDataset = DataCache.get(newData);
        Action a = BestMatch.match(originalDataset, newDataset, action);
        Param newDataParam = Param.makeString(newData);
        a = ActionUtil.replaceDataParameters(a, newDataParam);
        return a.simplify();
    }

    private static ArrayList<BestActionParameterSet> buildActionParameterSets(Dataset originalData, Dataset newData, Action orignalAction) {
        Param[] parms = ActionUtil.parameters(orignalAction);
        ArrayList<BestActionParameterSet> choices = new ArrayList<BestActionParameterSet>(parms.length);
        for (int i = 0; i < parms.length; ++i) {
            choices.add(new BestActionParameterSet(originalData, newData, parms, i, 20));
        }
        return choices;
    }

    private static ArrayList<ActionChoice> buildActionChoices(Action originalAction, List<BestActionParameterSet> parmSets) {
        ArrayList<ActionChoice> choices = new ArrayList<ActionChoice>();
        while (BestMatch.maxSize(parmSets) > 1) {
            ActionParameterChoice[] parmChoice = new ActionParameterChoice[parmSets.size()];
            ArrayList<String> usedFields = new ArrayList<String>();
            for (int i = 0; i < parmChoice.length; ++i) {
                BestActionParameterSet parmSet = parmSets.get(i);
                parmChoice[i] = parmSet.pullNextActionParameterChoice(usedFields);
                int duelEncodedIndex = parmChoice[i].getDualEncodedLinkIndex();
                String field = parmChoice[i].getField();
                if (duelEncodedIndex >= 0) {
                    String f = parmChoice[duelEncodedIndex].getField();
                    Param p = Param.makeField(f).addModifiers(parmChoice[i].getActionParameter().modifiers());
                    parmChoice[i] = new ActionParameterChoice(p, parmChoice[i].getScore());
                }
                if (field == null) continue;
                usedFields.add(field);
            }
            choices.add(ActionChoice.makeActionChoice(originalAction, parmChoice));
        }
        Collections.sort(choices);
        return choices;
    }

    private static int maxSize(List<BestActionParameterSet> parmSets) {
        int size = 0;
        for (BestActionParameterSet p : parmSets) {
            size = Math.max(size, p.size());
        }
        return size;
    }
}

