/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.brunel.build.util.ContentReader;
import org.brunel.build.util.DatasetCache;
import org.brunel.build.util.SimpleCache;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.io.CSV;
import org.brunel.util.GeneratedData;

public class DataCache {
    public static final String SAMPLE_DATA_LOCATION = "http://brunel.mybluemix.net/sample_data/";
    private static DatasetCache localCache = new SimpleCache();
    private static DatasetCache userCache = null;

    public static synchronized void useCache(DatasetCache cache) {
        userCache = cache;
    }

    public static synchronized void store(String dataKey, Dataset data) {
        localCache.store(dataKey, data);
        if (userCache != null) {
            userCache.store(dataKey, data);
        }
    }

    public static synchronized Dataset get(String dataKey) throws IOException {
        return DataCache.get(dataKey, null);
    }

    public static synchronized Dataset get(String dataKey, InputStream is) throws IOException {
        Dataset dataset;
        if (dataKey == null) {
            return null;
        }
        boolean useCache = true;
        URI uri = DataCache.makeURI(dataKey);
        if (uri != null && uri.getScheme() != null) {
            Dataset data;
            if (uri.getScheme().equals("sample")) {
                uri = DataCache.makeURI(SAMPLE_DATA_LOCATION + uri.getSchemeSpecificPart());
            } else if (uri.getScheme().equals("refresh")) {
                uri = DataCache.makeURI(uri.toString().replace("refresh", "http"));
                useCache = false;
            } else if (uri.getScheme().equals("generate")) {
                data = GeneratedData.make(uri.getSchemeSpecificPart());
                localCache.store(dataKey, data);
            } else if (uri.getScheme().equals("raw")) {
                data = Dataset.make((Field[])CSV.read((String)dataKey.substring(4).replaceAll(";", "\n")));
                localCache.store(dataKey, data);
            }
        }
        Dataset dataset2 = dataset = useCache ? localCache.retrieve(dataKey) : null;
        if (dataset != null) {
            return dataset;
        }
        if (userCache != null && useCache && (dataset = userCache.retrieve(dataKey)) != null) {
            localCache.store(dataKey, dataset);
        }
        if (dataset != null) {
            return dataset;
        }
        String content = is == null ? ContentReader.readContentFromUrl(uri) : ContentReader.readContent(is);
        dataset = Dataset.make((Field[])CSV.read((String)content));
        localCache.store(dataKey, dataset);
        if (userCache != null) {
            userCache.store(dataKey, dataset);
        }
        return dataset;
    }

    private static URI makeURI(String key) {
        try {
            key = key.replaceAll(" ", "%20");
            return new URI(key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

