/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.brunel.action.Action;
import org.brunel.action.ActionStep;
import org.brunel.action.Param;
import org.brunel.action.parse.GrammarItem;
import org.brunel.action.parse.ParseGrammar;
import org.brunel.data.Data;
import org.brunel.model.VisException;

public class Parser {
    private final ParseGrammar grammar = ParseGrammar.instance();

    public static Action parse(String text) {
        Parser parse = new Parser();
        List<BrunelToken> tokens = parse.tokenize(text);
        return parse.makeActionFromTokens(tokens, text);
    }

    private static int findQuoteEnd(String text, int start, char quoteChar) {
        for (int i = start + 1; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != quoteChar) continue;
            return i + 1;
        }
        return text.length();
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    private static Param parseModifier(BrunelToken t) {
        String content = t.content;
        if (content.length() == 0) {
            throw new IllegalStateException("Empty modifier");
        }
        Param result = Parser.parseModifier(content);
        t.parsedType = result.type().toString();
        return result;
    }

    private static Param parseModifier(String content) {
        List<Param> list;
        Double d;
        Param result = Data.isQuoted((String)content) ? Param.makeString(Data.deQuote((String)content)) : ((d = Data.asNumeric((Object)content)) != null ? Param.makeNumber(d) : ((list = Parser.tryAsDashSeparatedList(content)) != null ? Param.makeList(list) : Param.makeOption(content.toLowerCase())));
        return result;
    }

    private static List<Param> tryAsDashSeparatedList(String content) {
        String[] parts = content.split("-");
        if (parts.length < 2) {
            return null;
        }
        ArrayList<Param> list = new ArrayList<Param>();
        for (String p : parts) {
            list.add(Parser.parseModifier(p));
        }
        return list;
    }

    public Action makeActionFromTokens(List<BrunelToken> tokens, String text) {
        try {
            if (tokens.isEmpty()) {
                throw new IllegalStateException("Empty action string");
            }
            List<ActionStep> actions = this.getActionSteps(tokens);
            return new Action(actions.toArray(new ActionStep[actions.size()]));
        }
        catch (Exception e) {
            throw VisException.makeParsing(e, text);
        }
    }

    Param parseField(String param, String errorMessage) {
        String fieldName = this.asField(param);
        if (fieldName == null) {
            throw new IllegalStateException(errorMessage + ": " + param);
        }
        return Param.makeField(fieldName);
    }

    public List<BrunelToken> tokenize(String text) {
        try {
            ArrayList<BrunelToken> list = new ArrayList<BrunelToken>();
            int runStart = 0;
            while (runStart < text.length()) {
                char c = text.charAt(runStart);
                if (Character.isWhitespace(c)) {
                    ++runStart;
                    continue;
                }
                int runEnd = this.findRunEnd(text, runStart, c);
                list.add(new BrunelToken(text, runStart, runEnd));
                runStart = runEnd;
            }
            return list;
        }
        catch (Exception e) {
            throw VisException.makeParsing(e, text);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<ActionStep> getActionSteps(List<BrunelToken> tokens) {
        ArrayList<ActionStep> actions = new ArrayList<ActionStep>();
        for (int at = 0; at < tokens.size(); ++at) {
            ActionStep action;
            boolean openingParenthesisNext;
            BrunelToken s = tokens.get(at);
            GrammarItem definition = this.grammar.get(s.content);
            if (definition == null) {
                if (Character.isJavaIdentifierStart(s.content.charAt(0))) throw new IllegalStateException("Unknown action '" + s + "'");
                throw new IllegalStateException("Expected an action, but found '" + s.content + "'");
            }
            boolean bl = openingParenthesisNext = at < tokens.size() - 1 && tokens.get((int)(at + 1)).content.equals("(");
            if (!openingParenthesisNext) {
                if (!definition.mayHaveNoContent()) throw new IllegalStateException("Expected parameter list for " + s.content + ", but there was none");
                action = new ActionStep(s.content, new Param[0]);
            } else {
                if (definition.hasNoContent()) {
                    throw new IllegalStateException("Unexpected parameter list for " + s.content + " -- this command has no parameters");
                }
                this.expect("(", tokens.get(++at));
                int parametersEnd = this.findParametersEnd(tokens, ++at);
                if (parametersEnd < at + 1) {
                    throw new IllegalArgumentException("Empty parameters in " + s);
                }
                Stack<Param> params = new Stack<Param>();
                boolean expectParameter = true;
                boolean foundOption = false;
                boolean foundParam = false;
                for (int i = at; i < parametersEnd; ++i) {
                    BrunelToken token = tokens.get(i);
                    if (expectParameter) {
                        Param p = this.parseParameter(token, definition, foundOption, foundParam);
                        if (p.type() == Param.Type.option) {
                            foundOption = true;
                        } else {
                            foundParam = true;
                        }
                        token.parsedType = p.type().toString();
                        params.push(p);
                        expectParameter = false;
                        continue;
                    }
                    if (":".equals(token.content)) {
                        Param modifier;
                        token.parsedType = "syntax";
                        if (i > parametersEnd - 2) {
                            throw new IllegalStateException("Unterminated option ':'");
                        }
                        BrunelToken nextToken = tokens.get(++i);
                        if (nextToken.content.equals("[")) {
                            nextToken.parsedType = "syntax";
                            ArrayList<Param> listContent = new ArrayList<Param>();
                            while (i < parametersEnd) {
                                nextToken = tokens.get(++i);
                                listContent.add(Parser.parseModifier(nextToken));
                                nextToken = tokens.get(++i);
                                if (nextToken.content.equals("]")) {
                                    nextToken.parsedType = "syntax";
                                    break;
                                }
                                if (!nextToken.content.equals(",")) {
                                    throw new IllegalStateException("Expected comma or closing bracket, but was: " + nextToken.content);
                                }
                                nextToken.parsedType = "syntax";
                            }
                            modifier = Param.makeList(listContent);
                        } else {
                            modifier = Parser.parseModifier(nextToken);
                        }
                        params.push(((Param)params.pop()).addModifiers(modifier));
                        continue;
                    }
                    if (",".equals(token.content)) {
                        token.parsedType = "syntax";
                        expectParameter = true;
                        continue;
                    }
                    this.expect(",' or ':'", token);
                    expectParameter = true;
                }
                Param[] parameters = params.toArray(new Param[params.size()]);
                action = new ActionStep(s.content, parameters);
                at = parametersEnd;
            }
            actions.add(action);
            s.parsedType = "name";
        }
        return actions;
    }

    private String asField(String param) {
        if (param.startsWith("#")) {
            if (param.equalsIgnoreCase("#all")) {
                return "#all";
            }
            if (param.equalsIgnoreCase("#row")) {
                return "#row";
            }
            if (param.equalsIgnoreCase("#count")) {
                return "#count";
            }
            if (param.equalsIgnoreCase("#series")) {
                return "#series";
            }
            if (param.equalsIgnoreCase("#values")) {
                return "#values";
            }
            if (param.equalsIgnoreCase("#selection")) {
                return "#selection";
            }
            throw new IllegalStateException("Unknown special field: " + param);
        }
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && c >= '0' && c <= '9' || c == '_' || c == '%' || c == '$') continue;
            return null;
        }
        return param;
    }

    private void expect(String expected, BrunelToken actual) {
        if (!expected.equals(actual.content)) {
            throw new IllegalStateException("Expected token '" + expected + "', but was '" + actual.content + "'");
        }
        actual.parsedType = "syntax";
    }

    private int findParametersEnd(List<BrunelToken> tokens, int at) {
        while (at < tokens.size()) {
            if (tokens.get((int)at).content.equals(")")) {
                tokens.get((int)at).parsedType = "syntax";
                return at;
            }
            ++at;
        }
        throw new IllegalStateException("Unterminated parameters list");
    }

    private int findRunEnd(String text, int start, char startChar) {
        int end;
        if (Parser.isQuote(startChar)) {
            return Parser.findQuoteEnd(text, start, startChar);
        }
        if (this.isSpecialChar(startChar)) {
            return start + 1;
        }
        for (end = start + 1; end < text.length(); ++end) {
            char c = text.charAt(end);
            if (!this.isSpecialChar(c) && !Character.isWhitespace(c) && !Parser.isQuote(c)) continue;
            return end;
        }
        return end;
    }

    private boolean isSpecialChar(char startChar) {
        return startChar == ',' || startChar == '(' || startChar == ')' || startChar == '[' || startChar == ']' || startChar == ':';
    }

    private Param parseParameter(BrunelToken token, GrammarItem definition, boolean foundOption, boolean foundParameter) {
        String content = token.content;
        if (definition.isOption(content)) {
            if (foundOption && !definition.mayHaveMultipleOptions()) {
                throw new IllegalStateException("Only one option parameter allowed for " + definition.name);
            }
            if (definition.isOption(content)) {
                return Param.makeOption(content);
            }
            throw new IllegalStateException("Unknown option for " + definition.name + ": " + content + ". Expected one of " + definition.options());
        }
        if (Data.isQuoted((String)content)) {
            if (definition.allowsParameter("STRING", foundParameter)) {
                return Param.makeString(Data.deQuote((String)content));
            }
            throw new IllegalStateException(definition.name + " does not have string parameters: " + content);
        }
        Double d = Data.asNumeric((Object)content);
        if (d != null) {
            if (definition.allowsParameter("NUMBER", foundParameter)) {
                return Param.makeNumber(d);
            }
            throw new IllegalStateException(definition.name + " does not have numeric parameters: " + content);
        }
        if (!definition.allowsParameter("FIELD", foundParameter)) {
            throw new IllegalStateException(definition.name + " does not have field parameters: " + content);
        }
        if (this.asField(content) == null) {
            if (content.startsWith("#")) {
                throw new IllegalStateException("Unknown special field: " + content);
            }
            throw new IllegalStateException("Illegal field name: " + content);
        }
        return Param.makeField(content);
    }

    public static class BrunelToken {
        public final String content;
        public final int start;
        public final int end;
        public String parsedType;

        public BrunelToken(String all, int start, int end) {
            this.start = start;
            this.end = end;
            this.content = all.substring(start, end);
            this.parsedType = "?";
        }

        public String toString() {
            return this.content + '(' + this.parsedType + ')';
        }
    }
}

