#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup
from CoreServiceLibrary.version import VERSION

requirements = [
    'tox',
    'coverage',
    'robotframework'
]

test_requirements = [
    # TODO: put package test requirements here
]

CLASSIFIERS = """
Development Status :: 5 - Production/Stable
License :: Public Domain
Operating System :: OS Independent
Programming Language :: Python
Topic :: Software Development :: Testing
"""[1:-1]

setup(
    name='robotframework-coreservicelibrary',
    version=VERSION,
    description="robotframework coreservice",
    author="Traitanit Huangsri",
    author_email='traitanit.hua@ascendcorp.com',
    url='https://bitbucket.org/ascendcorp/robotframework-coreservicelibrary.git',
    packages=[
        'CoreServiceLibrary'
    ],
    package_dir={'robotframework-coreservicelibrary':
                 'CoreServiceLibrary'},
    include_package_data=True,
    install_requires=requirements,
    zip_safe=False,
    keywords='robotframework-coreservicelibrary',
    classifiers=CLASSIFIERS.splitlines(),
    test_suite='tests',
    tests_require=test_requirements
)
