# -*- coding: utf-8 -*-
from _ast import keyword

import requests
import json
from robot.api import logger
from robot.api.deco import keyword
from version import VERSION
from utils import Utils

__author__ = 'Traitanit Huangsri'
__email__ = 'traitanit.hua@ascendcorp.com'
__version__ = VERSION


class CoreServiceLibraryKeywords(object):

    sign_on_url = '/core-service-web/tmn-security/signon'
    get_tmn_id_url = '/core-service-web/trustedpartner/tmnid'
    get_tmn_profile_url = '/core-service-web/profiles'
    sign_on_sha256_url = '/core-service-web/v2/tmn-security/ewallet/signin'
    update_kyc_profile_url = '/core-service-web/kyc/profiles'
    get_balance_url = '/core-service-web/profiles/'

    headers = {
        'content-type': 'application/json; charset=utf-8'
    }
    headers_with_authentication = {
        'content-type': 'application/json; charset=utf-8',
        'tmn-x-access-key': '1881A99AAF2C267E0FE976AED4C53CBE3C4DAA4D2D094846B48ECA33DE99FB03'
    }

    def __init__(self, endpoint, tmn_x_access_key='1881A99AAF2C267E0FE976AED4C53CBE3C4DAA4D2D094846B48ECA33DE99FB03',timeout=60.0):
        # type: (object, object) -> object
        self.endpoint = endpoint
        self.timeout = timeout
        self.tmn_x_access_key = tmn_x_access_key

    @keyword('Sign On')
    def sign_on_api(self, initiator, pin):
        """Login to core-service-web (SHA-1)
        
        Arguments:
            - initiator: e-mail or mobile number
            - pin: password of e-mail or mobile number pin
        
        Return sessionId if login success, otherwise keyword status will be failed.
        """
        data = {
            "requestTransactionId": Utils.generate_transaction_id(),
            "initiator": initiator,
            "pin": Utils.hash_sha1(initiator+pin),
            "channelId": "40"
        }
        logger.info("Request: " + json.dumps(data))
        response = requests.post(self.endpoint + self.sign_on_url, data=json.dumps(data), headers=self.headers,
                                 verify=False, timeout=self.timeout)
        logger.info("Response: " + response.text)
        if response.status_code is not 200:
            raise Exception("HTTP Response Status Code is not 200 OK")

        response_json = response.json()
        if response_json['resultCode'] != "0":
            raise Exception("Response resultCode is not 0")

        return response_json['sessionId']

    @keyword('Get TMN Profile by Mobile')
    def get_tmn_profile(self, mobile):
        """Get TMN Profile by Mobile No

        Argument:
            - Mobile Nmber

        Return
        """
        tmn_id = self.get_tmn_id_by_mobile(mobile)
        response = requests.get(self.endpoint + self.get_tmn_profile_url + '/' + tmn_id, verify=False, timeout=self.timeout, headers=self.headers_with_authentication)
        return response.content

    def get_tmn_id_by_mobile(self,mobile_no):
        response = requests.get(self.endpoint + self.get_tmn_id_url + '/' + mobile_no, verify=False, timeout=self.timeout, headers=self.headers_with_authentication)
        json_data = json.loads(response.content)
        tmn_id = json_data["tmnId"]
        return tmn_id

    @keyword('update kyc profile')
    def update_kyc_profile(self, mobile, kyc_profile_dict):
        """Update kyc profile

        Argument:
            - Mobile Number
            - Dictionary of [  "thaiId": "1212121212121",
                              "fullName": "wallet.yummy",
                              "firstnameEn": "wallet.yummy",
                              "lastnameEn": "wallet.yummy",
                              "dateOfBirth": "20170101",
                              "title": "Mr.",
                              "occupation": "QA Engineer",
                              "address": "AIA Capital Center 18,19,32th floor, Ratchadapisek Road, Huaykwang",
                              "province": "Bangkok",
                              "postalCode": "10310"
                            ]
        Return
        """
        tmn_id = self.get_tmn_id_by_mobile(mobile)
        data = json.dumps(kyc_profile_dict)
        response = requests.post(self.endpoint + self.update_kyc_profile_url + '/' + tmn_id, data=data, headers=self.headers_with_authentication,
                                 verify=False, timeout=self.timeout)
        return response

    @keyword('Get Balance')
    def get_balance_api(self, initiator):
        """Get Balance

        Arguments:
            - sessionId: session id
            - tmnId: tmn id

        Return sessionId if login success, otherwise keyword status will be failed.
        """

        response = requests.get(self.endpoint + self.get_balance_url + initiator, headers=self.headers_with_authentication,
                                verify=False, timeout=self.timeout)
        logger.info("Response: " + response.text)
        if response.status_code is not 200:
            raise Exception("HTTP Response Status Code is not 200 OK")

        response_json = response.json()
        if response_json['resultCode'] != "0":
            raise Exception("Response resultCode is not 0")

        print ("ewalletBalance:" + str(response_json['ewalletBalance']))
        print ("availableBalance:" + str(response_json['availableBalance']))
        print ("pendingBalance:" + str(response_json['pendingBalance']))
        return str(response_json['ewalletBalance'])