/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ow2.proactive.scripting.Script;

public class VariableSubstitutor {
    public static final int MAXIMUM_DEPTH = 5;

    private VariableSubstitutor() {
    }

    public static Map<String, String> filterAndUpdate(Map<String, String> input, Map<String, ? extends Serializable> variables) {
        HashMap<String, String> result = new HashMap<String, String>(variables.size());
        for (Map.Entry<String, String> entry : input.entrySet()) {
            result.put(entry.getKey(), VariableSubstitutor.filterAndUpdate(entry.getValue(), variables));
        }
        return result;
    }

    public static Map<String, Serializable> resolveVariables(Map<String, Serializable> variables, Map<String, Serializable> dictionary) {
        HashMap<String, Serializable> resolvedVariables = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> entry : variables.entrySet()) {
            if (entry.getValue() instanceof String) {
                String resolvedValue = VariableSubstitutor.filterAndUpdate(entry.getValue().toString(), dictionary);
                resolvedVariables.put(entry.getKey(), (Serializable)((Object)resolvedValue));
                continue;
            }
            resolvedVariables.put(entry.getKey(), entry.getValue());
        }
        return resolvedVariables;
    }

    public static String filterAndUpdate(String input, Map<? extends Serializable, ? extends Serializable> variables) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String output = input;
        Map<String, String> substitutes = VariableSubstitutor.buildSubstitutes(variables);
        output = VariableSubstitutor.replaceRecursively(output, substitutes);
        return output;
    }

    private static String replaceRecursively(String value, Map<String, String> substitutes) {
        boolean anyReplacement;
        String output = value;
        int depthCount = 0;
        do {
            anyReplacement = false;
            ++depthCount;
            for (Map.Entry<String, String> replacement : substitutes.entrySet()) {
                if (replacement.getValue() == null) continue;
                String newOutput = output.replace(replacement.getKey(), replacement.getValue());
                anyReplacement = anyReplacement || !newOutput.equals(output);
                output = newOutput;
            }
        } while (anyReplacement && depthCount < 5);
        return output;
    }

    public static void filterAndUpdate(Script<?> script, Map<? extends Serializable, ? extends Serializable> variables) {
        script.setScript(VariableSubstitutor.filterAndUpdate(script.getScript(), variables));
        Serializable[] params = script.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                params[i] = VariableSubstitutor.filterAndUpdate(params[i].toString(), variables);
            }
        }
    }

    public static Map<String, String> buildSubstitutes(Map<? extends Serializable, ? extends Serializable> variables) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (variables != null) {
            for (Map.Entry<? extends Serializable, ? extends Serializable> variable : variables.entrySet()) {
                if (variable.getValue() == null) continue;
                String key = variable.getKey().toString();
                String value = variable.getValue().toString();
                replacements.put("$" + key, value);
                replacements.put("$" + key.toUpperCase().replace(".", "_"), value);
                replacements.put("${" + key + "}", value);
            }
        }
        return replacements;
    }
}

