/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.objectweb.proactive.annotation.PublicAPI;
import org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.task.CommonAttribute;
import org.ow2.proactive.scheduler.common.task.ForkEnvironment;
import org.ow2.proactive.scheduler.common.task.ParallelEnvironment;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.ow2.proactive.scheduler.common.task.dataspaces.InputAccessMode;
import org.ow2.proactive.scheduler.common.task.dataspaces.InputSelector;
import org.ow2.proactive.scheduler.common.task.dataspaces.OutputAccessMode;
import org.ow2.proactive.scheduler.common.task.dataspaces.OutputSelector;
import org.ow2.proactive.scheduler.common.task.flow.FlowBlock;
import org.ow2.proactive.scheduler.common.task.flow.FlowScript;
import org.ow2.proactive.scheduler.common.task.util.IntegerWrapper;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SelectionScript;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="task")
public abstract class Task
extends CommonAttribute {
    protected String name = "NOT SET";
    protected String flowBlock = FlowBlock.NONE.toString();
    protected String description = null;
    protected String tag = null;
    protected List<InputSelector> inputFiles = null;
    protected List<OutputSelector> outputFiles = null;
    protected ParallelEnvironment parallelEnvironment = null;
    protected List<SelectionScript> sScripts;
    protected Script<?> preScript;
    protected Script<?> postScript;
    protected Script<?> cScript;
    protected FlowScript flowScript;
    protected boolean preciousResult;
    protected boolean preciousLogs;
    protected boolean runAsMe;
    @XmlTransient
    private List<Task> dependences = null;
    protected long wallTime = 0L;
    protected ForkEnvironment forkEnvironment;
    protected Map<String, TaskVariable> variables = Collections.synchronizedMap(new LinkedHashMap());
    private static final long serialVersionUID = 810L;

    public void addDependence(Task task) {
        if (this.dependences == null) {
            this.dependences = new ArrayList<Task>();
        }
        this.dependences.add(task);
    }

    public void addDependences(List<Task> tasks) {
        if (this.dependences == null) {
            this.dependences = new ArrayList<Task>();
        }
        for (Task t : tasks) {
            this.addDependence(t);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPreciousResult() {
        return this.preciousResult;
    }

    public void setPreciousResult(boolean preciousResult) {
        this.preciousResult = preciousResult;
    }

    public boolean isPreciousLogs() {
        return this.preciousLogs;
    }

    public void setPreciousLogs(boolean preciousLogs) {
        this.preciousLogs = preciousLogs;
    }

    public boolean isRunAsMe() {
        return this.runAsMe;
    }

    public void setRunAsMe(boolean runAsMe) {
        this.runAsMe = runAsMe;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (name.length() > 255) {
            throw new IllegalArgumentException("The name is too long, it must have 255 chars length max : " + name);
        }
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public FlowBlock getFlowBlock() {
        return FlowBlock.parse(this.flowBlock);
    }

    public void setFlowBlock(FlowBlock fb) {
        this.flowBlock = fb.toString();
    }

    public Script<?> getPreScript() {
        return this.preScript;
    }

    public void setPreScript(Script<?> preScript) {
        this.preScript = preScript;
        this.preScript.overrideDefaultScriptName("PreScript");
    }

    public Script<?> getPostScript() {
        return this.postScript;
    }

    public FlowScript getFlowScript() {
        return this.flowScript;
    }

    public void setFlowScript(FlowScript s) {
        this.flowScript = s;
    }

    public void setPostScript(Script<?> postScript) {
        this.postScript = postScript;
        this.postScript.overrideDefaultScriptName("PostScript");
    }

    public Script<?> getCleaningScript() {
        return this.cScript;
    }

    public void setCleaningScript(Script<?> cleaningScript) {
        this.cScript = cleaningScript;
        this.cScript.overrideDefaultScriptName("CleanScript");
    }

    public boolean isParallel() {
        return this.parallelEnvironment != null && this.parallelEnvironment.getNodesNumber() >= 1;
    }

    public ParallelEnvironment getParallelEnvironment() {
        return this.parallelEnvironment;
    }

    public void setParallelEnvironment(ParallelEnvironment parallelEnvironment) {
        this.parallelEnvironment = parallelEnvironment;
    }

    public List<SelectionScript> getSelectionScripts() {
        if (this.sScripts == null || this.sScripts.size() == 0) {
            return null;
        }
        return this.sScripts;
    }

    public void setSelectionScript(SelectionScript selScript) {
        if (selScript == null) {
            throw new IllegalArgumentException("The given selection script cannot be null !");
        }
        ArrayList<SelectionScript> selScriptsList = new ArrayList<SelectionScript>();
        selScriptsList.add(selScript);
        this.setSelectionScripts(selScriptsList);
    }

    public void setSelectionScripts(List<SelectionScript> selScriptsList) {
        this.sScripts = selScriptsList;
    }

    public void addSelectionScript(SelectionScript selectionScript) {
        if (selectionScript == null) {
            throw new IllegalArgumentException("The given selection script cannot be null !");
        }
        if (this.sScripts == null) {
            this.sScripts = new ArrayList<SelectionScript>();
        }
        this.sScripts.add(selectionScript);
    }

    @XmlTransient
    public List<Task> getDependencesList() {
        return this.dependences;
    }

    public int getNumberOfNodesNeeded() {
        return this.isParallel() ? this.getParallelEnvironment().getNodesNumber() : 1;
    }

    public long getWallTime() {
        return this.wallTime;
    }

    public String getWorkingDir() {
        if (this.forkEnvironment == null) {
            return null;
        }
        return this.forkEnvironment.getWorkingDir();
    }

    public void setWallTime(long walltime) {
        if (walltime < 0L) {
            throw new IllegalArgumentException("The walltime must be a positive or nul integer value (>=0) !");
        }
        this.wallTime = walltime;
    }

    public boolean isWallTimeSet() {
        return this.wallTime > 0L;
    }

    @Deprecated
    public void setNumberOfNeededNodes(int numberOfNodesNeeded) {
        if (this.parallelEnvironment != null) {
            throw new IllegalStateException("Cannot set numberOfNodesNeeded as it could be inconsistent with the parallel environment");
        }
        this.parallelEnvironment = new ParallelEnvironment(numberOfNodesNeeded);
    }

    public void addInputFiles(FileSelector files, InputAccessMode mode) {
        if (files == null) {
            throw new IllegalArgumentException("Argument files is null");
        }
        if (this.inputFiles == null) {
            this.inputFiles = new ArrayList<InputSelector>();
        }
        this.inputFiles.add(new InputSelector(files, mode));
    }

    public void addOutputFiles(FileSelector files, OutputAccessMode mode) {
        if (files == null) {
            throw new IllegalArgumentException("Argument files is null");
        }
        if (this.outputFiles == null) {
            this.outputFiles = new ArrayList<OutputSelector>();
        }
        this.outputFiles.add(new OutputSelector(files, mode));
    }

    public void addInputFiles(String filesToInclude, InputAccessMode mode) {
        if (filesToInclude == null) {
            throw new IllegalArgumentException("Argument filesToInclude is null");
        }
        if (this.inputFiles == null) {
            this.inputFiles = new ArrayList<InputSelector>();
        }
        this.inputFiles.add(new InputSelector(new FileSelector(new String[]{filesToInclude}), mode));
    }

    public void addOutputFiles(String filesToInclude, OutputAccessMode mode) {
        if (filesToInclude == null) {
            throw new IllegalArgumentException("Argument filesToInclude is null");
        }
        if (this.outputFiles == null) {
            this.outputFiles = new ArrayList<OutputSelector>();
        }
        this.outputFiles.add(new OutputSelector(new FileSelector(new String[]{filesToInclude}), mode));
    }

    public List<InputSelector> getInputFilesList() {
        return this.inputFiles;
    }

    public List<OutputSelector> getOutputFilesList() {
        return this.outputFiles;
    }

    public void setVariables(Map<String, TaskVariable> variables) {
        Job.verifyVariableMap(variables);
        this.variables = Collections.synchronizedMap(new LinkedHashMap<String, TaskVariable>(variables));
    }

    public Map<String, TaskVariable> getVariables() {
        return this.variables;
    }

    public Map<String, String> getVariablesOverriden(Job job) {
        LinkedHashMap<String, String> taskVariables = new LinkedHashMap<String, String>();
        if (job != null) {
            taskVariables.putAll(job.getVariablesAsReplacementMap());
        }
        for (TaskVariable variable : this.getVariables().values()) {
            if (variable.isJobInherited()) continue;
            taskVariables.put(variable.getName(), variable.getValue());
        }
        return taskVariables;
    }

    public String toString() {
        return this.name;
    }

    public String display() {
        String nl = System.lineSeparator();
        return "Task '" + this.name + "' : " + nl + "\tDescription = '" + this.description + "'" + nl + (this.restartTaskOnError.isSet() ? "\trestartTaskOnError = '" + this.restartTaskOnError.getValue() + '\'' + nl : "") + (this.onTaskError.isSet() ? "\tonTaskError = '" + this.onTaskError.getValue() + '\'' + nl : "") + (this.maxNumberOfExecution.isSet() ? "\tmaxNumberOfExecution = '" + ((IntegerWrapper)this.maxNumberOfExecution.getValue()).getIntegerValue() + '\'' + nl : "") + "\ttag = " + this.tag + nl + "\tvariables = {" + nl + Joiner.on((char)'\n').withKeyValueSeparator("=").join(this.variables) + nl + "}" + nl + "\tgenericInformation = {" + nl + Joiner.on((char)'\n').withKeyValueSeparator("=").join(this.genericInformation) + nl + "}" + nl + "\tInputFiles = " + this.inputFiles + nl + "\tOutputFiles = " + this.outputFiles + nl + "\tParallelEnvironment = " + this.parallelEnvironment + nl + "\tFlowBlock = '" + this.flowBlock + "'" + nl + "\tSelectionScripts = " + this.displaySelectionScripts() + nl + "\tForkEnvironment = " + this.forkEnvironment + nl + "\tPreScript = " + (this.preScript != null ? this.preScript.display() : null) + nl + "\tPostScript = " + (this.postScript != null ? this.postScript.display() : null) + nl + "\tCleanScript = " + (this.cScript != null ? this.cScript.display() : null) + nl + "\tFlowScript = " + (this.flowScript != null ? this.flowScript.display() : null) + nl + "\tPreciousResult = " + this.preciousResult + nl + "\tPreciousLogs = " + this.preciousLogs + nl + "\tRunAsMe = " + this.runAsMe + nl + "\tWallTime = " + this.wallTime + nl + "\tDependences = " + this.dependences;
    }

    private String displaySelectionScripts() {
        if (this.sScripts == null) {
            return null;
        }
        String answer = "{ ";
        for (int i = 0; i < this.sScripts.size(); ++i) {
            SelectionScript ss = this.sScripts.get(i);
            if (ss == null) continue;
            answer = answer + ss.display() + (i < this.sScripts.size() - 1 ? " , " : "");
        }
        answer = answer + " }";
        return answer;
    }

    public ForkEnvironment getForkEnvironment() {
        return this.forkEnvironment;
    }

    public void setForkEnvironment(ForkEnvironment forkEnvironment) {
        this.forkEnvironment = forkEnvironment;
    }
}

