/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobType;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.JobFactory;
import org.ow2.proactive.scheduler.common.job.factories.XMLAttributes;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorRegistry;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorService;
import org.ow2.proactive.scheduler.common.task.CommonAttribute;
import org.ow2.proactive.scheduler.common.task.ForkEnvironment;
import org.ow2.proactive.scheduler.common.task.JavaTask;
import org.ow2.proactive.scheduler.common.task.NativeTask;
import org.ow2.proactive.scheduler.common.task.OnTaskError;
import org.ow2.proactive.scheduler.common.task.ParallelEnvironment;
import org.ow2.proactive.scheduler.common.task.RestartMode;
import org.ow2.proactive.scheduler.common.task.ScriptTask;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.ow2.proactive.scheduler.common.task.dataspaces.InputAccessMode;
import org.ow2.proactive.scheduler.common.task.dataspaces.OutputAccessMode;
import org.ow2.proactive.scheduler.common.task.flow.FlowActionType;
import org.ow2.proactive.scheduler.common.task.flow.FlowBlock;
import org.ow2.proactive.scheduler.common.task.flow.FlowScript;
import org.ow2.proactive.scheduler.common.util.VariableSubstitutor;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.ow2.proactive.scripting.ForkEnvironmentScript;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SelectionScript;
import org.ow2.proactive.scripting.SimpleScript;
import org.ow2.proactive.scripting.TaskScript;
import org.ow2.proactive.topology.descriptor.ThresholdProximityDescriptor;
import org.ow2.proactive.topology.descriptor.TopologyDescriptor;
import org.ow2.proactive.utils.Tools;

public class StaxJobFactory
extends JobFactory {
    public static final Logger logger = Logger.getLogger(StaxJobFactory.class);
    public static final String MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES = "Unable to instanciate job validation factories";
    private XMLInputFactory xmlInputFactory = null;
    private String relativePathRoot = "./";

    StaxJobFactory() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    @Override
    public Job createJob(String filePath) throws JobCreationException {
        return this.createJob(filePath, null);
    }

    @Override
    public Job createJob(String filePath, Map<String, String> replacementVariables) throws JobCreationException {
        try {
            File file = new File(filePath);
            return this.createJob(file, replacementVariables);
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
    }

    @Override
    public Job createJob(URI filePath) throws JobCreationException {
        return this.createJob(filePath, null);
    }

    @Override
    public Job createJob(URI filePath, Map<String, String> replacementVariables) throws JobCreationException {
        try {
            File file = new File(filePath);
            return this.createJob(file, replacementVariables);
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
    }

    private Job createJob(File file, Map<String, String> replacementVariables) throws JobCreationException {
        try {
            Job job;
            if (!file.exists()) {
                throw new FileNotFoundException("This file has not been found: " + file.getAbsolutePath());
            }
            File updatedFile = this.validate(file);
            this.relativePathRoot = updatedFile.getParentFile().getAbsolutePath();
            HashMap<String, ArrayList<String>> dependencies = new HashMap<String, ArrayList<String>>();
            try (FileInputStream inputStream = new FileInputStream(updatedFile);){
                XMLStreamReader xmlsr = PASchedulerProperties.FILE_ENCODING.isSet() ? this.xmlInputFactory.createXMLStreamReader(inputStream, PASchedulerProperties.FILE_ENCODING.getValueAsString()) : this.xmlInputFactory.createXMLStreamReader(inputStream);
                job = this.createJob(xmlsr, replacementVariables, dependencies);
                xmlsr.close();
            }
            this.makeDependences(job, dependencies);
            this.validate((TaskFlowJob)job);
            logger.debug((Object)"Job successfully created!");
            this.displayJobInfo(job);
            return job;
        }
        catch (JobCreationException jce) {
            jce.pushTag(XMLTags.JOB.getXMLName());
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
    }

    private File validate(File file) throws VerifierConfigurationException, JobCreationException {
        ImmutableMap<String, JobValidatorService> factories;
        try {
            factories = JobValidatorRegistry.getInstance().getRegisteredFactories();
        }
        catch (Exception e) {
            logger.error((Object)MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES, (Throwable)e);
            throw new VerifierConfigurationException(MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES, e);
        }
        File updatedFile = file;
        try {
            for (JobValidatorService factory : factories.values()) {
                updatedFile = factory.validateJob(updatedFile);
            }
        }
        catch (JobValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobValidationException(true, (Throwable)e);
        }
        return updatedFile;
    }

    private TaskFlowJob validate(TaskFlowJob job) throws VerifierConfigurationException, JobCreationException {
        ImmutableMap<String, JobValidatorService> factories;
        try {
            factories = JobValidatorRegistry.getInstance().getRegisteredFactories();
        }
        catch (Exception e) {
            throw new VerifierConfigurationException(MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES, e);
        }
        TaskFlowJob updatedJob = job;
        try {
            for (JobValidatorService factory : factories.values()) {
                updatedJob = factory.validateJob(updatedJob);
            }
        }
        catch (JobValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobValidationException(e);
        }
        return updatedJob;
    }

    private Job createJob(XMLStreamReader cursorRoot, Map<String, String> replacementVariables, Map<String, ArrayList<String>> dependencies) throws JobCreationException {
        String current = null;
        try {
            Job job = null;
            while (cursorRoot.hasNext()) {
                int eventType = cursorRoot.next();
                if (eventType != 1) continue;
                current = cursorRoot.getLocalName();
                if (XMLTags.JOB.matches(current)) {
                    job = this.createAndFillJob(cursorRoot, replacementVariables);
                    continue;
                }
                if (!XMLTags.TASK.matches(current)) continue;
                this.fillJobWithTasks(cursorRoot, job, dependencies);
            }
            if (job != null) {
                StaxJobFactory.resolveCleaningScripts((TaskFlowJob)job, job.getVariablesAsReplacementMap());
            }
            return job;
        }
        catch (JobCreationException jce) {
            if (XMLTags.TASK.matches(current)) {
                jce.pushTag(XMLTags.TASK_FLOW.getXMLName());
            }
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, null, e);
        }
    }

    private JobVariable newJobVariable(Map.Entry<String, String> entry) {
        return new JobVariable(entry.getKey(), entry.getValue(), null);
    }

    private Job createAndFillJob(XMLStreamReader cursorJob, Map<String, String> replacementVariables) throws JobCreationException {
        int i;
        Job commonPropertiesHolder = new Job(){
            private static final long serialVersionUID = 810L;

            @Override
            public JobId getId() {
                throw new RuntimeException("Not Available!");
            }

            @Override
            public JobType getType() {
                throw new RuntimeException("Not Available!");
            }
        };
        HashMap<String, String> delayedJobAttributes = new HashMap<String, String>();
        int attrLen = cursorJob.getAttributeCount();
        for (i = 0; i < attrLen; ++i) {
            String attributeName = cursorJob.getAttributeLocalName(i);
            String attributeValue = cursorJob.getAttributeValue(i);
            delayedJobAttributes.put(attributeName, attributeValue);
        }
        Job job = commonPropertiesHolder;
        try {
            boolean shouldContinue = true;
            if (replacementVariables != null) {
                commonPropertiesHolder.getVariables().putAll(replacementVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::newJobVariable)));
            }
            while (shouldContinue && cursorJob.hasNext()) {
                int eventType = cursorJob.next();
                switch (eventType) {
                    case 1: {
                        String current = cursorJob.getLocalName();
                        if (XMLTags.VARIABLES.matches(current)) {
                            commonPropertiesHolder.getVariables().putAll(this.createJobVariables(cursorJob, replacementVariables));
                            break;
                        }
                        if (XMLTags.COMMON_GENERIC_INFORMATION.matches(current)) {
                            commonPropertiesHolder.setGenericInformation(this.getGenericInformation(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                            break;
                        }
                        if (XMLTags.JOB_CLASSPATHES.matches(current)) {
                            logger.warn((Object)("Element " + XMLTags.JOB_CLASSPATHES.getXMLName() + " is no longer supported. Please define a " + XMLTags.FORK_ENVIRONMENT.getXMLName() + " per task if needed."));
                            break;
                        }
                        if (XMLTags.COMMON_DESCRIPTION.matches(current)) {
                            commonPropertiesHolder.setDescription(this.getDescription(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                            break;
                        }
                        if (XMLTags.DS_INPUT_SPACE.matches(current)) {
                            commonPropertiesHolder.setInputSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                            break;
                        }
                        if (XMLTags.DS_OUTPUT_SPACE.matches(current)) {
                            commonPropertiesHolder.setOutputSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                            break;
                        }
                        if (XMLTags.DS_GLOBAL_SPACE.matches(current)) {
                            commonPropertiesHolder.setGlobalSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                            break;
                        }
                        if (XMLTags.DS_USER_SPACE.matches(current)) {
                            commonPropertiesHolder.setUserSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                            break;
                        }
                        if (!XMLTags.TASK_FLOW.matches(current)) break;
                        job = new TaskFlowJob();
                        shouldContinue = false;
                    }
                }
            }
            this.handleJobAttributes(commonPropertiesHolder, delayedJobAttributes);
            if (job != commonPropertiesHolder) {
                job.setDescription(commonPropertiesHolder.getDescription());
                job.setName(commonPropertiesHolder.getName());
                job.setPriority(commonPropertiesHolder.getPriority());
                job.setProjectName(commonPropertiesHolder.getProjectName());
                job.setOnTaskError(commonPropertiesHolder.getOnTaskErrorProperty().getValue());
                job.setRestartTaskOnError(commonPropertiesHolder.getRestartTaskOnError());
                job.setMaxNumberOfExecution(commonPropertiesHolder.getMaxNumberOfExecution());
                job.setGenericInformation(commonPropertiesHolder.getGenericInformation());
                job.setInputSpace(commonPropertiesHolder.getInputSpace());
                job.setOutputSpace(commonPropertiesHolder.getOutputSpace());
                job.setGlobalSpace(commonPropertiesHolder.getGlobalSpace());
                job.setUserSpace(commonPropertiesHolder.getUserSpace());
                job.setVariables(commonPropertiesHolder.getVariables());
            }
            return job;
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorJob.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String temporaryAttribute = null;
            if (cursorJob.isStartElement() && cursorJob.getAttributeCount() > i) {
                temporaryAttribute = cursorJob.getAttributeLocalName(i);
            }
            throw new JobCreationException(cursorJob.getLocalName(), temporaryAttribute, e);
        }
    }

    private void handleJobAttributes(Job commonPropertiesHolder, Map<String, String> delayedJobAttributes) throws JobCreationException {
        for (Map.Entry<String, String> delayedAttribute : delayedJobAttributes.entrySet()) {
            String attributeName = delayedAttribute.getKey();
            String attributeValue = delayedAttribute.getValue();
            if (XMLAttributes.COMMON_NAME.matches(attributeName)) {
                commonPropertiesHolder.setName(this.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap()));
                continue;
            }
            if (XMLAttributes.JOB_PRIORITY.matches(attributeName)) {
                commonPropertiesHolder.setPriority(JobPriority.findPriority(this.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (XMLAttributes.COMMON_CANCEL_JOB_ON_ERROR.matches(attributeName)) {
                this.handleCancelJobOnErrorAttribute(commonPropertiesHolder, this.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap()));
                continue;
            }
            if (XMLAttributes.COMMON_RESTART_TASK_ON_ERROR.matches(attributeName)) {
                commonPropertiesHolder.setRestartTaskOnError(RestartMode.getMode(this.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (XMLAttributes.COMMON_ON_TASK_ERROR.matches(attributeName)) {
                commonPropertiesHolder.setOnTaskError(OnTaskError.getInstance(this.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (XMLAttributes.COMMON_MAX_NUMBER_OF_EXECUTION.matches(attributeName)) {
                commonPropertiesHolder.setMaxNumberOfExecution(Integer.parseInt(this.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (!XMLAttributes.JOB_PROJECT_NAME.matches(attributeName)) continue;
            commonPropertiesHolder.setProjectName(this.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap()));
        }
    }

    private void handleCancelJobOnErrorAttribute(CommonAttribute commonPropertiesHolder, String attributeValue) {
        logger.warn((Object)(XMLAttributes.COMMON_CANCEL_JOB_ON_ERROR.getXMLName() + " attribute is deprecated and no longer supported from schema 3.4+. Please use on task error policy to define task error behaviour. The attribute 'cancelJobOnError=\"true\"' is translated into 'onTaskError=\"cancelJob\"'."));
        if (attributeValue != null && attributeValue.equalsIgnoreCase("true")) {
            commonPropertiesHolder.setOnTaskError(OnTaskError.CANCEL_JOB);
        }
    }

    private Map<String, JobVariable> createJobVariables(XMLStreamReader cursorVariables, Map<String, String> replacementVariables) throws JobCreationException {
        LinkedHashMap<String, JobVariable> variablesMap = new LinkedHashMap<String, JobVariable>();
        try {
            while (cursorVariables.hasNext()) {
                int eventType = cursorVariables.next();
                switch (eventType) {
                    case 1: {
                        if (!XMLTags.VARIABLE.matches(cursorVariables.getLocalName())) break;
                        Map<String, String> attributesAsMap = this.getAttributesAsMap(cursorVariables, null);
                        String name = attributesAsMap.get(XMLAttributes.VARIABLE_NAME.getXMLName());
                        String value = attributesAsMap.get(XMLAttributes.VARIABLE_VALUE.getXMLName());
                        String model = attributesAsMap.get(XMLAttributes.VARIABLE_MODEL.getXMLName());
                        variablesMap.put(name, new JobVariable(name, value, model));
                        break;
                    }
                    case 2: {
                        if (!XMLTags.VARIABLES.matches(cursorVariables.getLocalName())) break;
                        return this.replaceVariablesInJobVariablesMap(variablesMap, replacementVariables);
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorVariables.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorVariables.isStartElement() && cursorVariables.getAttributeCount() == 1) {
                attrtmp = cursorVariables.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorVariables.getLocalName(), attrtmp, e);
        }
        return variablesMap;
    }

    protected Map<String, JobVariable> replaceVariablesInJobVariablesMap(Map<String, JobVariable> variablesMap, Map<String, String> replacementVariables) throws JobCreationException {
        HashMap<String, String> updatedReplacementVariables = new HashMap<String, String>();
        HashMap<String, JobVariable> updatedVariablesMap = new HashMap<String, JobVariable>(variablesMap);
        for (JobVariable jobVariable : updatedVariablesMap.values()) {
            updatedReplacementVariables.put(jobVariable.getName(), jobVariable.getValue());
        }
        if (replacementVariables != null) {
            updatedReplacementVariables.putAll(replacementVariables);
        }
        for (Map.Entry entry : updatedReplacementVariables.entrySet()) {
            if (updatedVariablesMap.containsKey(entry.getKey())) {
                JobVariable jobVariable = updatedVariablesMap.get(entry.getKey());
                jobVariable.setValue(this.replace((String)entry.getValue(), updatedReplacementVariables));
                if (jobVariable.getModel() == null) continue;
                jobVariable.setModel(this.replace(jobVariable.getModel(), updatedReplacementVariables));
                continue;
            }
            updatedVariablesMap.put((String)entry.getKey(), new JobVariable((String)entry.getKey(), this.replace((String)entry.getValue(), updatedReplacementVariables), null));
        }
        return updatedVariablesMap;
    }

    private Map<String, TaskVariable> createTaskVariables(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        HashMap<String, TaskVariable> variablesMap = new HashMap<String, TaskVariable>();
        try {
            while (cursorVariables.hasNext()) {
                int eventType = cursorVariables.next();
                if (eventType == 1 && XMLTags.VARIABLE.matches(cursorVariables.getLocalName())) {
                    TaskVariable taskVariable = this.getTaskVariable(cursorVariables, variables);
                    variablesMap.put(taskVariable.getName(), taskVariable);
                    continue;
                }
                if (eventType != 2 || !XMLTags.VARIABLES.matches(cursorVariables.getLocalName())) continue;
                return variablesMap;
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorVariables.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorVariables.isStartElement() && cursorVariables.getAttributeCount() == 1) {
                attrtmp = cursorVariables.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorVariables.getLocalName(), attrtmp, e);
        }
        return variablesMap;
    }

    private TaskVariable getTaskVariable(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        TaskVariable taskVariable = new TaskVariable();
        Map<String, String> attributesAsMap = this.getAttributesAsMap(cursorVariables, variables);
        taskVariable.setName(attributesAsMap.get(XMLAttributes.VARIABLE_NAME.getXMLName()));
        taskVariable.setValue(attributesAsMap.get(XMLAttributes.VARIABLE_VALUE.getXMLName()));
        taskVariable.setModel(attributesAsMap.get(XMLAttributes.VARIABLE_MODEL.getXMLName()));
        if (attributesAsMap.containsKey(XMLAttributes.VARIABLE_JOB_INHERITED.getXMLName())) {
            taskVariable.setJobInherited(Boolean.valueOf(attributesAsMap.get(XMLAttributes.VARIABLE_JOB_INHERITED.getXMLName())));
        }
        return taskVariable;
    }

    private Map<String, String> getAttributesAsMap(XMLStreamReader cursorVariables, Map<String, String> replacementVariables) throws JobCreationException {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < cursorVariables.getAttributeCount(); ++i) {
            result.put((Object)cursorVariables.getAttributeLocalName(i), (Object)this.replace(cursorVariables.getAttributeValue(i), replacementVariables));
        }
        return result.build();
    }

    private HashMap<String, String> getGenericInformation(XMLStreamReader cursorInfo, Map<String, String> variables) throws JobCreationException {
        HashMap<String, String> infos = new HashMap<String, String>();
        try {
            while (cursorInfo.hasNext()) {
                int eventType = cursorInfo.next();
                switch (eventType) {
                    case 1: {
                        if (!XMLTags.COMMON_INFO.matches(cursorInfo.getLocalName())) break;
                        Map<String, String> attributesAsMap = this.getAttributesAsMap(cursorInfo, variables);
                        String name = attributesAsMap.get(XMLAttributes.COMMON_NAME.getXMLName());
                        String value = attributesAsMap.get(XMLAttributes.COMMON_VALUE.getXMLName());
                        infos.put(name, value);
                        break;
                    }
                    case 2: {
                        if (!XMLTags.COMMON_GENERIC_INFORMATION.matches(cursorInfo.getLocalName())) break;
                        return infos;
                    }
                }
            }
            return infos;
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorInfo.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorInfo.isStartElement() && cursorInfo.getAttributeCount() == 1) {
                attrtmp = cursorInfo.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorInfo.getLocalName(), attrtmp, e);
        }
    }

    private String getDescription(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        try {
            String description = "";
            int eventType = cursorVariables.next();
            if (eventType == 4) {
                description = this.replace(cursorVariables.getText(), variables);
            } else if (eventType == 2) {
                return description;
            }
            while (cursorVariables.next() != 2) {
            }
            return description;
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException((String)null, null, e);
        }
    }

    private String getIOSpace(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        try {
            String url = this.replace(cursorVariables.getAttributeValue(0), variables);
            while (cursorVariables.next() != 2) {
            }
            return url;
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            String temporaryAttribute = null;
            if (cursorVariables.isStartElement() && cursorVariables.getAttributeCount() == 1) {
                temporaryAttribute = cursorVariables.getAttributeLocalName(0);
            }
            throw new JobCreationException((String)null, temporaryAttribute, e);
        }
    }

    private void fillJobWithTasks(XMLStreamReader cursorTask, Job job, Map<String, ArrayList<String>> dependencies) throws JobCreationException {
        if (job == null) {
            throw new JobCreationException(XMLTags.JOB.getXMLName(), null, null);
        }
        XMLTags current = null;
        try {
            int eventType = -1;
            block7: while (cursorTask.hasNext()) {
                if ((eventType = eventType == -1 ? cursorTask.getEventType() : cursorTask.next()) != 1 || !XMLTags.TASK.matches(cursorTask.getLocalName())) continue;
                switch (job.getType()) {
                    case TASKSFLOW: {
                        current = XMLTags.TASK;
                        Task t = this.createTask(cursorTask, job, dependencies);
                        ((TaskFlowJob)job).addTask(t);
                        continue block7;
                    }
                    case PARAMETER_SWEEPING: {
                        current = XMLTags.TASK;
                        throw new RuntimeException("Job parameter sweeping is not yet implemented!");
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, null, e);
        }
    }

    private Task createTask(XMLStreamReader cursorTask, Job job, Map<String, ArrayList<String>> dependencies) throws JobCreationException {
        int i = 0;
        XMLTags currentTag = null;
        String current = null;
        String taskName = null;
        try {
            CommonAttribute toReturn = null;
            Task tmpTask = new Task(){
                private static final long serialVersionUID = 810L;
            };
            int attrLen = cursorTask.getAttributeCount();
            for (i = 0; i < attrLen; ++i) {
                String attributeName = cursorTask.getAttributeLocalName(i);
                String attributeValue = cursorTask.getAttributeValue(i);
                if (XMLAttributes.COMMON_NAME.matches(attributeName)) {
                    tmpTask.setName(attributeValue);
                    taskName = attributeValue;
                    continue;
                }
                if (XMLAttributes.TASK_NB_NODES.matches(attributeName)) {
                    int numberOfNodesNeeded = Integer.parseInt(this.replace(attributeValue, tmpTask.getVariablesOverriden(job)));
                    tmpTask.setParallelEnvironment(new ParallelEnvironment(numberOfNodesNeeded));
                    continue;
                }
                if (XMLAttributes.COMMON_CANCEL_JOB_ON_ERROR.matches(attributeName)) {
                    this.handleCancelJobOnErrorAttribute(tmpTask, attributeValue);
                    continue;
                }
                if (XMLAttributes.COMMON_ON_TASK_ERROR.matches(attributeName)) {
                    tmpTask.setOnTaskError(OnTaskError.getInstance(this.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.COMMON_RESTART_TASK_ON_ERROR.matches(attributeName)) {
                    tmpTask.setRestartTaskOnError(RestartMode.getMode(this.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.COMMON_MAX_NUMBER_OF_EXECUTION.matches(attributeName)) {
                    tmpTask.setMaxNumberOfExecution(Integer.parseInt(this.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.TASK_PRECIOUS_RESULT.matches(attributeName)) {
                    tmpTask.setPreciousResult(Boolean.parseBoolean(this.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.TASK_PRECIOUS_LOGS.matches(attributeName)) {
                    tmpTask.setPreciousLogs(Boolean.parseBoolean(this.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.TASK_WALLTIME.matches(attributeName)) {
                    tmpTask.setWallTime(Tools.formatDate((String)this.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (!XMLAttributes.TASK_RUN_AS_ME.matches(attributeName)) continue;
                tmpTask.setRunAsMe(Boolean.parseBoolean(this.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
            }
            boolean shouldContinue = true;
            while (shouldContinue && cursorTask.hasNext()) {
                int eventType = cursorTask.next();
                switch (eventType) {
                    case 1: {
                        current = cursorTask.getLocalName();
                        currentTag = null;
                        if (XMLTags.COMMON_GENERIC_INFORMATION.matches(current)) {
                            tmpTask.setGenericInformation(this.getGenericInformation(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.VARIABLES.matches(current)) {
                            Map<String, TaskVariable> taskVariablesMap = this.createTaskVariables(cursorTask, tmpTask.getVariablesOverriden(job));
                            tmpTask.setVariables(taskVariablesMap);
                            break;
                        }
                        if (XMLTags.COMMON_DESCRIPTION.matches(current)) {
                            tmpTask.setDescription(this.getDescription(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.DS_INPUT_FILES.matches(current)) {
                            this.setIOFIles(cursorTask, XMLTags.DS_INPUT_FILES.getXMLName(), tmpTask, tmpTask.getVariablesOverriden(job));
                            break;
                        }
                        if (XMLTags.DS_OUTPUT_FILES.matches(current)) {
                            this.setIOFIles(cursorTask, XMLTags.DS_OUTPUT_FILES.getXMLName(), tmpTask, tmpTask.getVariablesOverriden(job));
                            break;
                        }
                        if (XMLTags.PARALLEL_ENV.matches(current)) {
                            tmpTask.setParallelEnvironment(this.createParallelEnvironment(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.SCRIPT_SELECTION.matches(current)) {
                            tmpTask.setSelectionScripts(this.createSelectionScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.FORK_ENVIRONMENT.matches(current)) {
                            tmpTask.setForkEnvironment(this.createForkEnvironment(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.SCRIPT_PRE.matches(current)) {
                            tmpTask.setPreScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.SCRIPT_POST.matches(current)) {
                            tmpTask.setPostScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.SCRIPT_CLEANING.matches(current)) {
                            tmpTask.setCleaningScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.FLOW.matches(current)) {
                            tmpTask.setFlowScript(this.createControlFlowScript(cursorTask, tmpTask, tmpTask.getVariablesOverriden(job)));
                            break;
                        }
                        if (XMLTags.TASK_DEPENDENCES.matches(current)) {
                            currentTag = XMLTags.TASK_DEPENDENCES;
                            dependencies.putAll(this.createDependences(cursorTask, tmpTask));
                            break;
                        }
                        if (XMLTags.JAVA_EXECUTABLE.matches(current)) {
                            toReturn = new JavaTask();
                            this.setJavaExecutable((JavaTask)toReturn, cursorTask, tmpTask.getVariablesOverriden(job));
                            break;
                        }
                        if (XMLTags.NATIVE_EXECUTABLE.matches(current)) {
                            toReturn = new NativeTask();
                            this.setNativeExecutable((NativeTask)toReturn, cursorTask);
                            break;
                        }
                        if (!XMLTags.SCRIPT_EXECUTABLE.matches(current)) break;
                        toReturn = new ScriptTask();
                        ((ScriptTask)toReturn).setScript(new TaskScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job))));
                        break;
                    }
                    case 2: {
                        current = cursorTask.getLocalName();
                        if (!XMLTags.TASK.matches(cursorTask.getLocalName())) break;
                        shouldContinue = false;
                    }
                }
            }
            StaxJobFactory.autoCopyfields(CommonAttribute.class, tmpTask, toReturn);
            StaxJobFactory.autoCopyfields(Task.class, tmpTask, toReturn);
            if (toReturn != null) {
                if (toReturn.getRestartTaskOnErrorProperty().isSet()) {
                    toReturn.setRestartTaskOnError(toReturn.getRestartTaskOnError());
                }
                if (toReturn.getMaxNumberOfExecutionProperty().isSet()) {
                    toReturn.setMaxNumberOfExecution(toReturn.getMaxNumberOfExecution());
                }
            }
            return toReturn;
        }
        catch (JobCreationException jce) {
            jce.setTaskName(taskName);
            if (currentTag != null) {
                jce.pushTag(currentTag);
            } else {
                jce.pushTag(current);
            }
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorTask.isStartElement() && cursorTask.getAttributeCount() > i) {
                attrtmp = cursorTask.getAttributeLocalName(i);
            }
            if (currentTag != null) {
                throw new JobCreationException(currentTag, attrtmp, e);
            }
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private void setIOFIles(XMLStreamReader cursorTask, String endTag, Task task, Map<String, String> variables) throws JobCreationException {
        int i = 0;
        try {
            boolean shouldContinue = true;
            block7: while (shouldContinue && cursorTask.hasNext()) {
                int eventType = cursorTask.next();
                switch (eventType) {
                    case 1: {
                        String current = cursorTask.getLocalName();
                        if (!XMLTags.DS_FILES.matches(current)) break;
                        int attrLen = cursorTask.getAttributeCount();
                        FileSelector selector = null;
                        String accessMode = null;
                        for (i = 0; i < attrLen; ++i) {
                            String attrName = cursorTask.getAttributeLocalName(i);
                            if (XMLAttributes.DS_INCLUDES.matches(attrName)) {
                                if (selector == null) {
                                    selector = new FileSelector();
                                }
                                selector.setIncludes(new String[]{cursorTask.getAttributeValue(i)});
                            } else if (XMLAttributes.DS_EXCLUDES.matches(attrName)) {
                                if (selector == null) {
                                    selector = new FileSelector();
                                }
                                selector.setExcludes(new String[]{this.replace(cursorTask.getAttributeValue(i), variables)});
                            } else if (XMLAttributes.DS_ACCESS_MODE.matches(attrName)) {
                                accessMode = cursorTask.getAttributeValue(i);
                            }
                            if (selector == null || accessMode == null) continue;
                            if (XMLTags.DS_INPUT_FILES.matches(endTag)) {
                                task.addInputFiles(selector, InputAccessMode.getAccessMode(accessMode));
                                continue;
                            }
                            task.addOutputFiles(selector, OutputAccessMode.getAccessMode(accessMode));
                        }
                        continue block7;
                    }
                    case 2: {
                        if (!cursorTask.getLocalName().equals(endTag)) break;
                        shouldContinue = false;
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorTask.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorTask.isStartElement() && cursorTask.getAttributeCount() > i) {
                attrtmp = cursorTask.getAttributeLocalName(i);
            }
            throw new JobCreationException(cursorTask.getLocalName(), attrtmp, e);
        }
    }

    private Map<String, ArrayList<String>> createDependences(XMLStreamReader cursorDepends, Task t) throws JobCreationException {
        try {
            HashMap<String, ArrayList<String>> dependencies = new HashMap<String, ArrayList<String>>();
            ArrayList<String> depends = new ArrayList<String>(0);
            while (cursorDepends.hasNext()) {
                int eventType = cursorDepends.next();
                switch (eventType) {
                    case 1: {
                        if (!XMLTags.TASK_DEPENDENCES_TASK.matches(cursorDepends.getLocalName())) break;
                        depends.add(cursorDepends.getAttributeValue(0));
                        break;
                    }
                    case 2: {
                        if (!XMLTags.TASK_DEPENDENCES.matches(cursorDepends.getLocalName())) break;
                        dependencies.put(t.getName(), depends);
                        return dependencies;
                    }
                }
            }
            return dependencies;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorDepends.isStartElement() && cursorDepends.getAttributeCount() == 1) {
                attrtmp = cursorDepends.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorDepends.getLocalName(), attrtmp, e);
        }
    }

    private FlowScript createControlFlowScript(XMLStreamReader cursorTask, Task tmpTask, Map<String, String> variables) throws JobCreationException {
        String attrName;
        String type = null;
        String target = null;
        String targetElse = null;
        String targetJoin = null;
        int event = -1;
        for (int i = 0; i < cursorTask.getAttributeCount(); ++i) {
            String attrName2 = cursorTask.getAttributeLocalName(i);
            if (!XMLAttributes.FLOW_BLOCK.matches(attrName2)) continue;
            tmpTask.setFlowBlock(FlowBlock.parse(this.replace(cursorTask.getAttributeValue(i), variables)));
        }
        try {
            while (cursorTask.hasNext() && (event = cursorTask.next()) != 1) {
                if (event != 2 || !XMLTags.FLOW.matches(cursorTask.getLocalName())) continue;
                return null;
            }
        }
        catch (Exception e) {
            throw new JobCreationException(XMLTags.FLOW.getXMLName(), null, e);
        }
        if (event != 1) {
            throw new JobCreationException(XMLTags.FLOW.getXMLName(), null, null);
        }
        String tag = null;
        if (XMLTags.FLOW_REPLICATE.matches(cursorTask.getLocalName())) {
            type = FlowActionType.REPLICATE.toString();
            tag = XMLTags.FLOW_REPLICATE.getXMLName();
        } else if (XMLTags.FLOW_IF.matches(cursorTask.getLocalName())) {
            type = FlowActionType.IF.toString();
            tag = XMLTags.FLOW_IF.getXMLName();
            for (int i = 0; i < cursorTask.getAttributeCount(); ++i) {
                attrName = cursorTask.getAttributeLocalName(i);
                if (XMLAttributes.FLOW_TARGET.matches(attrName)) {
                    target = cursorTask.getAttributeValue(i);
                    continue;
                }
                if (XMLAttributes.FLOW_ELSE.matches(attrName)) {
                    targetElse = cursorTask.getAttributeValue(i);
                    continue;
                }
                if (!XMLAttributes.FLOW_CONTINUATION.matches(attrName)) continue;
                targetJoin = cursorTask.getAttributeValue(i);
            }
        } else if (XMLTags.FLOW_LOOP.matches(cursorTask.getLocalName())) {
            type = FlowActionType.LOOP.toString();
            tag = XMLTags.FLOW_LOOP.getXMLName();
            for (int i = 0; i < cursorTask.getAttributeCount(); ++i) {
                attrName = cursorTask.getAttributeLocalName(i);
                if (!XMLAttributes.FLOW_TARGET.matches(attrName)) continue;
                target = cursorTask.getAttributeValue(i);
            }
        }
        FlowScript sc = null;
        try {
            Script<?> internalScript = this.createScript(cursorTask, ScriptType.FLOW, variables);
            switch (FlowActionType.parse(type)) {
                case IF: {
                    sc = FlowScript.createIfFlowScript(internalScript, target, targetElse, targetJoin);
                    break;
                }
                case REPLICATE: {
                    sc = FlowScript.createReplicateFlowScript(internalScript);
                    break;
                }
                case LOOP: {
                    sc = FlowScript.createLoopFlowScript(internalScript, target);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new JobCreationException(tag, null, e);
        }
        try {
            while (cursorTask.hasNext() && (event = cursorTask.next()) != 2) {
            }
        }
        catch (XMLStreamException e) {
            throw new JobCreationException(tag, null, (Exception)e);
        }
        if (event != 2) {
            throw new JobCreationException(tag, null, null);
        }
        return sc;
    }

    private ParallelEnvironment createParallelEnvironment(XMLStreamReader cursorTask, Map<String, String> variables) throws JobCreationException {
        int event = -1;
        int nodesNumber = 0;
        TopologyDescriptor topologyDescriptor = null;
        try {
            String value;
            String attrName;
            int i;
            for (i = 0; i < cursorTask.getAttributeCount(); ++i) {
                attrName = cursorTask.getAttributeLocalName(i);
                if (!XMLAttributes.TASK_NB_NODES.matches(attrName)) continue;
                value = this.replace(cursorTask.getAttributeValue(i), variables);
                nodesNumber = Integer.parseInt(value);
            }
            while (cursorTask.hasNext() && (event = cursorTask.next()) != 1) {
                if (event != 2 || !XMLTags.PARALLEL_ENV.matches(cursorTask.getLocalName())) continue;
                return new ParallelEnvironment(nodesNumber, TopologyDescriptor.ARBITRARY);
            }
            if (XMLTags.TOPOLOGY.matches(cursorTask.getLocalName())) {
                while (cursorTask.hasNext() && (event = cursorTask.next()) != 1) {
                    if (event != 2 || !XMLTags.TOPOLOGY.matches(cursorTask.getLocalName())) continue;
                    throw new RuntimeException("Incorrect topology description");
                }
                if (XMLTags.TOPOLOGY_ARBITRARY.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.ARBITRARY;
                } else if (XMLTags.TOPOLOGY_BEST_PROXIMITY.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.BEST_PROXIMITY;
                } else if (XMLTags.TOPOLOGY_THRESHOLD_PROXIMITY.matches(cursorTask.getLocalName())) {
                    for (i = 0; i < cursorTask.getAttributeCount(); ++i) {
                        attrName = cursorTask.getAttributeLocalName(i);
                        if (!XMLAttributes.TOPOLOGY_THRESHOLD.matches(attrName)) continue;
                        value = this.replace(cursorTask.getAttributeValue(i), variables);
                        long threshold = Long.parseLong(value);
                        topologyDescriptor = new ThresholdProximityDescriptor(threshold);
                    }
                } else if (XMLTags.TOPOLOGY_SINGLE_HOST.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.SINGLE_HOST;
                } else if (XMLTags.TOPOLOGY_SINGLE_HOST_EXCLUSIVE.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.SINGLE_HOST_EXCLUSIVE;
                } else if (XMLTags.TOPOLOGY_MULTIPLE_HOSTS_EXCLUSIVE.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.MULTIPLE_HOSTS_EXCLUSIVE;
                } else if (XMLTags.TOPOLOGY_DIFFERENT_HOSTS_EXCLUSIVE.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.DIFFERENT_HOSTS_EXCLUSIVE;
                }
            }
        }
        catch (Exception e) {
            throw new JobCreationException(XMLTags.TOPOLOGY.getXMLName(), null, e);
        }
        return new ParallelEnvironment(nodesNumber, topologyDescriptor);
    }

    private Script<?> createScript(XMLStreamReader cursorScript, ScriptType type, Map<String, String> variables) throws JobCreationException {
        String attrtmp = null;
        String currentScriptTag = cursorScript.getLocalName();
        String current = null;
        try {
            boolean isDynamic = true;
            SimpleScript toReturn = null;
            int eventType = -1;
            while (cursorScript.hasNext()) {
                eventType = type == ScriptType.SELECTION && eventType == -1 ? cursorScript.getEventType() : cursorScript.next();
                switch (eventType) {
                    case 1: {
                        current = cursorScript.getLocalName();
                        if (XMLTags.SCRIPT_CODE.matches(current)) {
                            int ev;
                            String language = null;
                            String content = "";
                            if (cursorScript.getAttributeCount() > 0) {
                                language = cursorScript.getAttributeValue(0);
                                attrtmp = cursorScript.getAttributeLocalName(0);
                            }
                            if (cursorScript.next() == 4) {
                                content = cursorScript.getText();
                            }
                            toReturn = new SimpleScript(content, language);
                            do {
                                ev = cursorScript.next();
                            } while (!XMLTags.SCRIPT_CODE.matches(current) || ev != 2);
                            break;
                        }
                        if (XMLTags.SCRIPT_FILE.matches(current)) {
                            int ev;
                            String path = null;
                            String url = null;
                            String language = null;
                            for (int i = 0; i < cursorScript.getAttributeCount(); ++i) {
                                attrtmp = cursorScript.getAttributeLocalName(i);
                                if (XMLAttributes.SCRIPT_URL.matches(attrtmp)) {
                                    url = this.replace(cursorScript.getAttributeValue(i), variables);
                                    continue;
                                }
                                if (XMLAttributes.LANGUAGE.matches(attrtmp)) {
                                    language = this.replace(cursorScript.getAttributeValue(i), variables);
                                    continue;
                                }
                                if (XMLAttributes.PATH.matches(attrtmp)) {
                                    path = this.checkPath(cursorScript.getAttributeValue(i), variables);
                                    continue;
                                }
                                throw new JobCreationException("Unrecognized attribute : " + attrtmp);
                            }
                            while (!((ev = cursorScript.next()) == 1 && XMLTags.SCRIPT_ARGUMENTS.matches(cursorScript.getLocalName()) || ev == 2)) {
                            }
                            if (url != null) {
                                if (language != null) {
                                    toReturn = new SimpleScript(new URL(url), language, (Serializable[])this.getArguments(cursorScript));
                                    break;
                                }
                                toReturn = new SimpleScript(new URL(url), (Serializable[])this.getArguments(cursorScript));
                                break;
                            }
                            if (path != null) {
                                toReturn = new SimpleScript(new File(path), (Serializable[])this.getArguments(cursorScript));
                                break;
                            }
                            attrtmp = null;
                            throw new JobCreationException("Invalid script file definition, one of path/url attributes must be declared");
                        }
                        if (XMLTags.SCRIPT_ARGUMENTS.matches(current)) {
                            toReturn = new SimpleScript(toReturn.getScript(), toReturn.getEngineName(), (Serializable[])this.getArguments(cursorScript));
                            break;
                        }
                        if (!XMLTags.SCRIPT_SCRIPT.matches(current) || cursorScript.getAttributeCount() <= 0) break;
                        isDynamic = !"static".equals(cursorScript.getAttributeValue(0));
                        break;
                    }
                    case 2: {
                        if (!cursorScript.getLocalName().equals(currentScriptTag)) break;
                        if (type == ScriptType.SELECTION) {
                            return new SelectionScript(toReturn, isDynamic);
                        }
                        return toReturn;
                    }
                }
            }
            return toReturn;
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private List<SelectionScript> createSelectionScript(XMLStreamReader cursorScript, Map<String, String> variables) throws JobCreationException {
        ArrayList<SelectionScript> scripts = new ArrayList<SelectionScript>(0);
        String selectionTag = cursorScript.getLocalName();
        String current = null;
        try {
            while (cursorScript.hasNext()) {
                int eventType = cursorScript.next();
                switch (eventType) {
                    case 1: {
                        current = cursorScript.getLocalName();
                        if (!XMLTags.SCRIPT_SCRIPT.matches(current)) break;
                        SelectionScript newOne = (SelectionScript)this.createScript(cursorScript, ScriptType.SELECTION, variables);
                        scripts.add(newOne);
                        break;
                    }
                    case 2: {
                        current = cursorScript.getLocalName();
                        if (!current.equals(selectionTag)) break;
                        if (scripts.size() == 0) {
                            return null;
                        }
                        return scripts;
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, null, e);
        }
        return scripts;
    }

    private Script<?> createScript(XMLStreamReader cursorScript, Map<String, String> variables) throws JobCreationException {
        try {
            return this.createScript(cursorScript, ScriptType.OTHER, variables);
        }
        catch (JobCreationException jce) {
            jce.pushTag(XMLTags.SCRIPT_SCRIPT.getXMLName());
            throw jce;
        }
    }

    private String[] getArguments(XMLStreamReader cursorArgs) throws JobCreationException {
        if (XMLTags.SCRIPT_ARGUMENTS.matches(cursorArgs.getLocalName())) {
            ArrayList<String> args = new ArrayList<String>(0);
            try {
                while (cursorArgs.hasNext()) {
                    int eventType = cursorArgs.next();
                    switch (eventType) {
                        case 1: {
                            if (!XMLTags.SCRIPT_ARGUMENT.matches(cursorArgs.getLocalName())) break;
                            args.add(cursorArgs.getAttributeValue(0));
                            break;
                        }
                        case 2: {
                            if (!XMLTags.SCRIPT_ARGUMENTS.matches(cursorArgs.getLocalName())) break;
                            return args.toArray(new String[args.size()]);
                        }
                    }
                }
                return args.toArray(new String[args.size()]);
            }
            catch (Exception e) {
                String temporaryAttribute = null;
                if (cursorArgs.isStartElement() && cursorArgs.getAttributeCount() == 1) {
                    temporaryAttribute = cursorArgs.getAttributeLocalName(0);
                }
                throw new JobCreationException(cursorArgs.getLocalName(), temporaryAttribute, e);
            }
        }
        return null;
    }

    private void setNativeExecutable(NativeTask nativeTask, XMLStreamReader cursorExec) throws JobCreationException {
        block15: {
            int i = 0;
            String current = null;
            try {
                while (cursorExec.next() != 1) {
                }
                current = cursorExec.getLocalName();
                ArrayList<String> command = new ArrayList<String>(0);
                if (XMLTags.NATIVE_TASK_STATIC_COMMAND.matches(cursorExec.getLocalName())) {
                    String attr_ = null;
                    String current_ = null;
                    try {
                        for (i = 0; i < cursorExec.getAttributeCount(); ++i) {
                            String attrName;
                            attr_ = attrName = cursorExec.getAttributeLocalName(i);
                            if (XMLAttributes.TASK_COMMAND_VALUE.matches(attrName)) {
                                command.add(cursorExec.getAttributeValue(i));
                            }
                            if (!XMLAttributes.TASK_WORKDING_DIR.matches(attrName)) continue;
                            logger.warn((Object)(XMLAttributes.TASK_WORKDING_DIR.getXMLName() + " attribute no longer supported. Please use a forkEnvironment for defining a working directory."));
                        }
                        while (cursorExec.hasNext()) {
                            int eventType = cursorExec.next();
                            switch (eventType) {
                                case 1: {
                                    current_ = cursorExec.getLocalName();
                                    if (!XMLTags.SCRIPT_ARGUMENT.matches(cursorExec.getLocalName())) break;
                                    command.add(cursorExec.getAttributeValue(0));
                                    break;
                                }
                                case 2: {
                                    if (!XMLTags.NATIVE_EXECUTABLE.matches(cursorExec.getLocalName())) break;
                                    nativeTask.setCommandLine(command.toArray(new String[command.size()]));
                                    return;
                                }
                            }
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        throw new JobCreationException(current_, attr_, e);
                    }
                }
                throw new RuntimeException("Unknown command type: " + cursorExec.getLocalName());
            }
            catch (JobCreationException jce) {
                jce.pushTag(current);
                throw jce;
            }
            catch (Exception e) {
                String temporaryAttribute = null;
                if (cursorExec.isStartElement() && cursorExec.getAttributeCount() > 0) {
                    temporaryAttribute = cursorExec.getAttributeLocalName(i);
                }
                throw new JobCreationException(current, temporaryAttribute, e);
            }
        }
    }

    private void setJavaExecutable(JavaTask javaTask, XMLStreamReader cursorExec, Map<String, String> variables) throws JobCreationException {
        int i = 0;
        String current = cursorExec.getLocalName();
        try {
            int attrCount = cursorExec.getAttributeCount();
            for (i = 0; i < attrCount; ++i) {
                String attrName = cursorExec.getAttributeLocalName(i);
                if (!XMLAttributes.TASK_CLASS_NAME.matches(attrName)) continue;
                javaTask.setExecutableClassName(cursorExec.getAttributeValue(i));
            }
            while (cursorExec.hasNext()) {
                int eventType = cursorExec.next();
                switch (eventType) {
                    case 1: {
                        current = cursorExec.getLocalName();
                        if (XMLTags.FORK_ENVIRONMENT.matches(current)) {
                            ForkEnvironment forkEnv = this.createForkEnvironment(cursorExec, variables);
                            javaTask.setForkEnvironment(forkEnv);
                            break;
                        }
                        if (!XMLTags.TASK_PARAMETER.matches(current)) break;
                        Map<String, String> attributesAsMap = this.getAttributesAsMap(cursorExec, variables);
                        String name = attributesAsMap.get(XMLAttributes.VARIABLE_NAME.getXMLName());
                        String value = attributesAsMap.get(XMLAttributes.VARIABLE_VALUE.getXMLName());
                        javaTask.addArgument(this.replace(name, variables), (Serializable)((Object)value));
                        break;
                    }
                    case 2: {
                        if (!XMLTags.JAVA_EXECUTABLE.matches(cursorExec.getLocalName())) break;
                        return;
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorExec.isStartElement() && cursorExec.getAttributeCount() > 0) {
                attrtmp = cursorExec.getAttributeLocalName(i);
            }
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private ForkEnvironment createForkEnvironment(XMLStreamReader cursorExec, Map<String, String> variables) throws JobCreationException {
        ForkEnvironment forkEnv = new ForkEnvironment();
        int i = 0;
        String current = cursorExec.getLocalName();
        try {
            int attrCount = cursorExec.getAttributeCount();
            for (i = 0; i < attrCount; ++i) {
                String attrName = cursorExec.getAttributeLocalName(i);
                if (XMLAttributes.FORK_JAVA_HOME.matches(attrName)) {
                    forkEnv.setJavaHome(this.replace(cursorExec.getAttributeValue(i), variables));
                }
                if (!XMLAttributes.TASK_WORKDING_DIR.matches(attrName)) continue;
                forkEnv.setWorkingDir(this.replace(cursorExec.getAttributeValue(i), variables));
            }
            while (cursorExec.hasNext()) {
                int eventType = cursorExec.next();
                switch (eventType) {
                    case 1: {
                        current = cursorExec.getLocalName();
                        if (XMLTags.FORK_SYSTEM_PROPERTY.matches(current)) {
                            attrCount = cursorExec.getAttributeCount();
                            String name = null;
                            String value = null;
                            for (i = 0; i < attrCount; ++i) {
                                String attrName = cursorExec.getAttributeLocalName(i);
                                if (XMLAttributes.COMMON_NAME.matches(attrName)) {
                                    name = this.replace(cursorExec.getAttributeValue(i), variables);
                                }
                                if (!XMLAttributes.COMMON_VALUE.matches(attrName)) continue;
                                value = this.replace(cursorExec.getAttributeValue(i), variables);
                            }
                            forkEnv.addSystemEnvironmentVariable(name, value);
                            break;
                        }
                        if (XMLTags.FORK_JVM_ARG.matches(current)) {
                            forkEnv.addJVMArgument(this.replace(cursorExec.getAttributeValue(0), variables));
                            break;
                        }
                        if (XMLTags.JOB_PATH_ELEMENT.matches(current)) {
                            forkEnv.addAdditionalClasspath(this.replace(cursorExec.getAttributeValue(0), variables));
                            break;
                        }
                        if (!XMLTags.SCRIPT_ENV.matches(current)) break;
                        forkEnv.setEnvScript((Script<?>)new ForkEnvironmentScript(this.createScript(cursorExec, variables)));
                        break;
                    }
                    case 2: {
                        if (!XMLTags.FORK_ENVIRONMENT.matches(cursorExec.getLocalName())) break;
                        return forkEnv;
                    }
                }
            }
            return forkEnv;
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorExec.isStartElement() && cursorExec.getAttributeCount() > 0) {
                attrtmp = cursorExec.getAttributeLocalName(i);
            }
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private void makeDependences(Job job, Map<String, ArrayList<String>> dependencies) throws JobCreationException {
        if (dependencies != null && dependencies.size() > 0 && job.getType() == JobType.TASKSFLOW) {
            TaskFlowJob tfj = (TaskFlowJob)job;
            for (Task t : tfj.getTasks()) {
                ArrayList<String> names = dependencies.get(t.getName());
                if (names == null) continue;
                for (String name : names) {
                    if (tfj.getTask(name) == null) {
                        throw new JobCreationException("Unknown dependence: " + name);
                    }
                    t.addDependence(tfj.getTask(name));
                }
            }
        }
    }

    private String replace(String str, Map<String, String> variables) throws JobCreationException {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (Map.Entry<Object, Object> o : System.getProperties().entrySet()) {
            replacements.put(o.getKey().toString(), o.getValue().toString());
        }
        if (variables != null) {
            replacements.putAll(variables);
        }
        return VariableSubstitutor.filterAndUpdate(str, replacements);
    }

    private String checkPath(String path, Map<String, String> variables) throws JobCreationException {
        if (path == null || "".equals(path)) {
            return path;
        }
        File f = new File(path = this.replace(path, variables));
        if (f.isAbsolute()) {
            return path;
        }
        return this.relativePathRoot + File.separator + path;
    }

    private void displayJobInfo(Job job) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("type: " + job.getType()));
            logger.debug((Object)("name: " + job.getName()));
            logger.debug((Object)("description: " + job.getDescription()));
            logger.debug((Object)("projectName: " + job.getProjectName()));
            logger.debug((Object)("variables: " + job.getVariables()));
            logger.debug((Object)("priority: " + job.getPriority()));
            logger.debug((Object)("onTaskError: " + job.getOnTaskErrorProperty().getValue().toString()));
            logger.debug((Object)("restartTaskOnError: " + job.getRestartTaskOnError()));
            logger.debug((Object)("maxNumberOfExecution: " + job.getMaxNumberOfExecution()));
            logger.debug((Object)("inputSpace: " + job.getInputSpace()));
            logger.debug((Object)("outputSpace: " + job.getOutputSpace()));
            logger.debug((Object)("genericInformation: " + job.getGenericInformation()));
            logger.debug((Object)"TASKS ------------------------------------------------");
            ArrayList<Task> tasks = new ArrayList<Task>();
            switch (job.getType()) {
                case TASKSFLOW: {
                    tasks.addAll(((TaskFlowJob)job).getTasks());
                    break;
                }
            }
            for (Task t : tasks) {
                logger.debug((Object)("name: " + t.getName()));
                logger.debug((Object)("description: " + t.getDescription()));
                logger.debug((Object)("parallel: " + t.isParallel()));
                logger.debug((Object)("nbNodes: " + (t.getParallelEnvironment() == null ? "1" : Integer.valueOf(t.getParallelEnvironment().getNodesNumber()))));
                logger.debug((Object)("onTaskError: " + t.getOnTaskErrorProperty().getValue().toString()));
                logger.debug((Object)("preciousResult: " + t.isPreciousResult()));
                logger.debug((Object)("preciousLogs: " + t.isPreciousLogs()));
                logger.debug((Object)("restartTaskOnError: " + t.getRestartTaskOnError()));
                logger.debug((Object)("maxNumberOfExecution: " + t.getMaxNumberOfExecution()));
                logger.debug((Object)("walltime: " + t.getWallTime()));
                logger.debug((Object)("selectionScripts: " + t.getSelectionScripts()));
                logger.debug((Object)("preScript: " + t.getPreScript()));
                logger.debug((Object)("postScript: " + t.getPostScript()));
                logger.debug((Object)("cleaningScript: " + t.getCleaningScript()));
                try {
                    logger.debug((Object)("inputFileList: length=" + t.getInputFilesList().size()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    logger.debug((Object)("outputFileList: length=" + t.getOutputFilesList().size()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (t.getDependencesList() != null) {
                    String dep = "dependence: ";
                    for (Task tdep : t.getDependencesList()) {
                        dep = dep + tdep.getName() + " ";
                    }
                    logger.debug((Object)dep);
                } else {
                    logger.debug((Object)"dependence: null");
                }
                logger.debug((Object)("genericInformation: " + t.getGenericInformation()));
                logger.debug((Object)("variables: " + t.getVariables()));
                if (t instanceof JavaTask) {
                    logger.debug((Object)("class: " + ((JavaTask)t).getExecutableClassName()));
                    try {
                        logger.debug((Object)("args: " + ((JavaTask)t).getArguments()));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Cannot get args: " + e.getMessage()), (Throwable)e);
                    }
                    logger.debug((Object)("fork: " + ((JavaTask)t).isFork()));
                } else if (t instanceof NativeTask) {
                    logger.debug((Object)("commandLine: " + Arrays.toString(((NativeTask)t).getCommandLine())));
                } else if (t instanceof ScriptTask) {
                    logger.debug((Object)("script: " + ((ScriptTask)t).getScript()));
                }
                ForkEnvironment forkEnvironment = t.getForkEnvironment();
                if (forkEnvironment != null) {
                    logger.debug((Object)("javaHome: " + forkEnvironment.getJavaHome()));
                    logger.debug((Object)("systemEnvironment: " + forkEnvironment.getSystemEnvironment()));
                    logger.debug((Object)("jvmArguments: " + forkEnvironment.getJVMArguments()));
                    logger.debug((Object)("classpath: " + forkEnvironment.getAdditionalClasspath()));
                    logger.debug((Object)("envScript: " + forkEnvironment.getEnvScript()));
                }
                logger.debug((Object)"--------------------------------------------------");
            }
        }
    }

    private static <T> void autoCopyfields(Class<T> klass, T from, T to) throws IllegalArgumentException, IllegalAccessException {
        for (Field f : klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            Object newValue = f.get(from);
            if (newValue == null && f.get(to) != null) continue;
            f.set(to, newValue);
        }
    }

    private static void resolveCleaningScripts(TaskFlowJob job, Map<String, String> replacementVariables) {
        for (Task task : job.getTasks()) {
            Script<?> cScript = task.getCleaningScript();
            if (cScript == null) continue;
            VariableSubstitutor.filterAndUpdate(cScript, replacementVariables);
        }
    }

    private static enum ScriptType {
        SELECTION,
        FLOW,
        OTHER;

    }
}

