/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.Attribute;
import org.ow2.proactive.scheduler.common.job.factories.Schemas;
import org.ow2.proactive.scheduler.common.job.factories.XMLAttributes;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;
import org.ow2.proactive.scheduler.common.task.ForkEnvironment;
import org.ow2.proactive.scheduler.common.task.JavaTask;
import org.ow2.proactive.scheduler.common.task.NativeTask;
import org.ow2.proactive.scheduler.common.task.ParallelEnvironment;
import org.ow2.proactive.scheduler.common.task.ScriptTask;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.ow2.proactive.scheduler.common.task.dataspaces.InputSelector;
import org.ow2.proactive.scheduler.common.task.dataspaces.OutputSelector;
import org.ow2.proactive.scheduler.common.task.flow.FlowActionType;
import org.ow2.proactive.scheduler.common.task.flow.FlowBlock;
import org.ow2.proactive.scheduler.common.task.flow.FlowScript;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SelectionScript;
import org.ow2.proactive.topology.descriptor.ArbitraryTopologyDescriptor;
import org.ow2.proactive.topology.descriptor.BestProximityDescriptor;
import org.ow2.proactive.topology.descriptor.DifferentHostsExclusiveDescriptor;
import org.ow2.proactive.topology.descriptor.MultipleHostsExclusiveDescriptor;
import org.ow2.proactive.topology.descriptor.SingleHostDescriptor;
import org.ow2.proactive.topology.descriptor.SingleHostExclusiveDescriptor;
import org.ow2.proactive.topology.descriptor.ThresholdProximityDescriptor;
import org.ow2.proactive.topology.descriptor.TopologyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Job2XMLTransformer {
    public static Logger logger = Logger.getLogger(Job2XMLTransformer.class);
    public static final String XSD_LOCATION = "urn:proactive:jobdescriptor:dev ../../src/scheduler/src/org/ow2/proactive/scheduler/common/xml/schemas/jobdescriptor/dev/schedulerjob.xsd";

    public InputStream jobToxml(TaskFlowJob job) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element rootJob = this.createRootJobElement(doc, job);
        doc.appendChild(rootJob);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("indent", "yes");
        if (PASchedulerProperties.FILE_ENCODING.isSet()) {
            trans.setOutputProperty("encoding", PASchedulerProperties.FILE_ENCODING.getValueAsString());
        } else {
            trans.setOutputProperty("encoding", "UTF-8");
        }
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        byte[] array = baos.toByteArray();
        return new ByteArrayInputStream(array);
    }

    public String jobToxmlString(TaskFlowJob job) throws TransformerException, ParserConfigurationException, IOException {
        InputStream is = this.jobToxml(job);
        String answer = IOUtils.toString((InputStream)is, (String)"UTF-8");
        return answer;
    }

    public void job2xmlFile(TaskFlowJob job, File f) throws ParserConfigurationException, TransformerException, IOException {
        String xmlString = this.jobToxmlString(job);
        try (FileWriter fw = new FileWriter(f);){
            fw.write(xmlString);
        }
    }

    private Element createRootJobElement(Document doc, TaskFlowJob job) {
        Element rootJob = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), "job");
        rootJob.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", XSD_LOCATION);
        this.setAttribute(rootJob, XMLAttributes.JOB_PROJECT_NAME, job.getProjectName(), true);
        this.setAttribute(rootJob, XMLAttributes.JOB_PRIORITY, job.getPriority().toString());
        if (job.getOnTaskErrorProperty().isSet()) {
            this.setAttribute(rootJob, XMLAttributes.COMMON_ON_TASK_ERROR, job.getOnTaskErrorProperty().getValue().toString(), true);
        }
        if (job.getMaxNumberOfExecutionProperty().isSet()) {
            this.setAttribute(rootJob, XMLAttributes.COMMON_MAX_NUMBER_OF_EXECUTION, Integer.toString(job.getMaxNumberOfExecution()));
        }
        this.setAttribute(rootJob, XMLAttributes.COMMON_NAME, job.getName(), true);
        if (job.getRestartTaskOnErrorProperty().isSet()) {
            this.setAttribute(rootJob, XMLAttributes.COMMON_RESTART_TASK_ON_ERROR, job.getRestartTaskOnError().toString());
        }
        if (job.getVariables() != null && !job.getVariables().isEmpty()) {
            Element variablesE = this.createJobVariablesElement(doc, job.getVariables());
            rootJob.appendChild(variablesE);
        }
        if (job.getDescription() != null) {
            Element descrNode = this.createElement(doc, XMLTags.COMMON_DESCRIPTION.getXMLName(), job.getDescription(), new Attribute[0]);
            rootJob.appendChild(descrNode);
        }
        if (job.getGenericInformation() != null && job.getGenericInformation().size() > 0) {
            Element genericInfo = this.createGenericInformation(doc, job.getGenericInformation());
            rootJob.appendChild(genericInfo);
        }
        if (job.getInputSpace() != null) {
            Element inputspace = this.createElement(doc, XMLTags.DS_INPUT_SPACE.getXMLName(), null, new Attribute(XMLAttributes.DS_URL.getXMLName(), job.getInputSpace()));
            rootJob.appendChild(inputspace);
        }
        if (job.getOutputSpace() != null) {
            Element outputSpace = this.createElement(doc, XMLTags.DS_OUTPUT_SPACE.getXMLName(), null, new Attribute(XMLAttributes.DS_URL.getXMLName(), job.getOutputSpace()));
            rootJob.appendChild(outputSpace);
        }
        if (job.getGlobalSpace() != null) {
            Element globalSpace = this.createElement(doc, XMLTags.DS_GLOBAL_SPACE.getXMLName(), null, new Attribute(XMLAttributes.DS_URL.getXMLName(), job.getGlobalSpace()));
            rootJob.appendChild(globalSpace);
        }
        if (job.getUserSpace() != null) {
            Element userSpace = this.createElement(doc, XMLTags.DS_USER_SPACE.getXMLName(), null, new Attribute(XMLAttributes.DS_URL.getXMLName(), job.getUserSpace()));
            rootJob.appendChild(userSpace);
        }
        Element taskFlow = this.createTaskFlowElement(doc, job);
        rootJob.appendChild(taskFlow);
        return rootJob;
    }

    private Element createElement(Document doc, String tagName, String elementText, Attribute ... attribs) {
        Element el = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), tagName);
        for (Attribute a : attribs) {
            el.setAttribute(a.getName(), a.getValue());
        }
        if (elementText != null) {
            Text text = doc.createTextNode(elementText);
            el.appendChild(text);
        }
        return el;
    }

    private Element createJobVariablesElement(Document doc, Map<String, JobVariable> jobVariables) {
        if (jobVariables == null) {
            return null;
        }
        Element variablesE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.VARIABLES.getXMLName());
        for (String name : jobVariables.keySet()) {
            Element variableE = this.createElement(doc, XMLTags.VARIABLE.getXMLName(), null, new Attribute(XMLAttributes.VARIABLE_NAME.getXMLName(), name), new Attribute(XMLAttributes.VARIABLE_VALUE.getXMLName(), jobVariables.get(name).getValue()), new Attribute(XMLAttributes.VARIABLE_MODEL.getXMLName(), jobVariables.get(name).getModel()));
            variablesE.appendChild(variableE);
        }
        return variablesE;
    }

    private Element createTaskVariablesElement(Document doc, Map<String, TaskVariable> variables) {
        if (variables == null) {
            return null;
        }
        Element variablesE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.VARIABLES.getXMLName());
        for (TaskVariable variable : variables.values()) {
            Element variableE = this.createElement(doc, XMLTags.VARIABLE.getXMLName(), null, new Attribute(XMLAttributes.VARIABLE_NAME.getXMLName(), variable.getName()), new Attribute(XMLAttributes.VARIABLE_VALUE.getXMLName(), variable.getValue()), new Attribute(XMLAttributes.VARIABLE_MODEL.getXMLName(), variable.getModel()), new Attribute(XMLAttributes.VARIABLE_JOB_INHERITED.getXMLName(), String.valueOf(variable.isJobInherited())));
            variablesE.appendChild(variableE);
        }
        return variablesE;
    }

    private Element createGenericInformation(Document doc, Map<String, String> info) {
        if (info == null) {
            return null;
        }
        Element el = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.COMMON_GENERIC_INFORMATION.getXMLName());
        for (String name : info.keySet()) {
            Element infoElement = this.createElement(doc, XMLTags.COMMON_INFO.getXMLName(), null, new Attribute(XMLAttributes.COMMON_NAME.getXMLName(), name), new Attribute(XMLAttributes.COMMON_VALUE.getXMLName(), info.get(name)));
            el.appendChild(infoElement);
        }
        return el;
    }

    private void setAttribute(Element e, XMLAttributes attrib, String attribVal) {
        if (attribVal == null) {
            return;
        }
        e.setAttribute(attrib.getXMLName(), attribVal.toLowerCase());
    }

    private void setAttribute(Element e, XMLAttributes attrib, String attribVal, boolean caseSensitive) {
        if (attribVal == null) {
            return;
        }
        if (caseSensitive) {
            e.setAttribute(attrib.getXMLName(), attribVal);
        } else {
            this.setAttribute(e, attrib, attribVal);
        }
    }

    private Element createTaskFlowElement(Document doc, TaskFlowJob job) {
        Element taskFlowElement = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TASK_FLOW.getXMLName());
        ArrayList<Task> tasks = job.getTasks();
        for (Task task : tasks) {
            Element taskE = this.createTaskElement(doc, task);
            taskFlowElement.appendChild(taskE);
        }
        return taskFlowElement;
    }

    private Element createTaskElement(Document doc, Task task) {
        List<OutputSelector> outputFiles;
        Script<?> cleanScript;
        Script<?> postScript;
        Script<?> preScript;
        List<SelectionScript> list;
        Element parallelEnvE;
        List<InputSelector> inputFiles;
        List<Task> dependencies;
        Element taskE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TASK.getXMLName());
        if (task.getOnTaskErrorProperty().isSet()) {
            this.setAttribute(taskE, XMLAttributes.COMMON_ON_TASK_ERROR, task.getOnTaskErrorProperty().getValue().toString(), true);
        }
        if (task.getMaxNumberOfExecutionProperty().isSet()) {
            this.setAttribute(taskE, XMLAttributes.COMMON_MAX_NUMBER_OF_EXECUTION, Integer.toString(task.getMaxNumberOfExecution()));
        }
        this.setAttribute(taskE, XMLAttributes.COMMON_NAME, task.getName(), true);
        if (task.getRestartTaskOnErrorProperty().isSet()) {
            this.setAttribute(taskE, XMLAttributes.COMMON_RESTART_TASK_ON_ERROR, task.getRestartTaskOnError().toString());
        }
        if (task.getWallTime() != 0L) {
            this.setAttribute(taskE, XMLAttributes.TASK_WALLTIME, Job2XMLTransformer.formatDate(task.getWallTime()));
        }
        if (task.isRunAsMe()) {
            this.setAttribute(taskE, XMLAttributes.TASK_RUN_AS_ME, "true");
        }
        if (task.isPreciousResult()) {
            this.setAttribute(taskE, XMLAttributes.TASK_PRECIOUS_RESULT, "true");
        }
        if (task.isPreciousLogs()) {
            this.setAttribute(taskE, XMLAttributes.TASK_PRECIOUS_LOGS, "true");
        }
        if (task.getDescription() != null) {
            Element descrNode = this.createElement(doc, XMLTags.COMMON_DESCRIPTION.getXMLName(), task.getDescription(), new Attribute[0]);
            taskE.appendChild(descrNode);
        }
        if (task.getVariables() != null && !task.getVariables().isEmpty()) {
            Element variablesE = this.createTaskVariablesElement(doc, task.getVariables());
            taskE.appendChild(variablesE);
        }
        if (task.getGenericInformation() != null && task.getGenericInformation().size() > 0) {
            Element genericInfoE = this.createGenericInformation(doc, task.getGenericInformation());
            taskE.appendChild(genericInfoE);
        }
        if ((dependencies = task.getDependencesList()) != null && dependencies.size() > 0) {
            Element dependsE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TASK_DEPENDENCES.getXMLName());
            for (Task task2 : dependencies) {
                Element dependsTask = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TASK_DEPENDENCES_TASK.getXMLName());
                this.setAttribute(dependsTask, XMLAttributes.TASK_DEPENDS_REF, task2.getName(), true);
                dependsE.appendChild(dependsTask);
            }
            taskE.appendChild(dependsE);
        }
        if ((inputFiles = task.getInputFilesList()) != null) {
            Element inputFilesE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.DS_INPUT_FILES.getXMLName());
            for (InputSelector inputSelector : inputFiles) {
                FileSelector fs = inputSelector.getInputFiles();
                Element filesE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.DS_FILES.getXMLName());
                if (!fs.getIncludes().isEmpty()) {
                    this.setAttribute(filesE, XMLAttributes.DS_INCLUDES, (String)fs.getIncludes().iterator().next(), true);
                }
                if (!fs.getExcludes().isEmpty()) {
                    this.setAttribute(filesE, XMLAttributes.DS_EXCLUDES, (String)fs.getExcludes().iterator().next(), true);
                }
                if (inputSelector.getMode() != null) {
                    this.setAttribute(filesE, XMLAttributes.DS_ACCESS_MODE, inputSelector.getMode().toString(), true);
                }
                inputFilesE.appendChild(filesE);
            }
            taskE.appendChild(inputFilesE);
        }
        if ((parallelEnvE = this.createParallelEnvironment(doc, task)) != null) {
            taskE.appendChild(parallelEnvE);
        }
        if ((list = task.getSelectionScripts()) != null && list.size() > 0) {
            Element selectionE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_SELECTION.getXMLName());
            for (SelectionScript selectionScript : list) {
                Element scriptE = this.createScriptElement(doc, (Script)selectionScript);
                selectionE.appendChild(scriptE);
            }
            taskE.appendChild(selectionE);
        }
        if (task.getForkEnvironment() != null) {
            Element forkEnvE = this.createForkEnvironmentElement(doc, task.getForkEnvironment());
            taskE.appendChild(forkEnvE);
        }
        if ((preScript = task.getPreScript()) != null) {
            Element preE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_PRE.getXMLName());
            Element scriptE = this.createScriptElement(doc, preScript);
            preE.appendChild(scriptE);
            taskE.appendChild(preE);
        }
        Element executableE = null;
        if (task instanceof JavaTask) {
            executableE = this.createJavaExecutableElement(doc, (JavaTask)task);
        } else if (task instanceof NativeTask) {
            executableE = this.createNativeExecutableElement(doc, (NativeTask)task);
        } else if (task instanceof ScriptTask) {
            executableE = this.createScriptExecutableElement(doc, (ScriptTask)task);
        }
        taskE.appendChild(executableE);
        Element controlFlowE = this.createFlowControlElement(doc, task);
        if (controlFlowE != null) {
            taskE.appendChild(controlFlowE);
        }
        if ((postScript = task.getPostScript()) != null) {
            Element postE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_POST.getXMLName());
            Element scriptE = this.createScriptElement(doc, postScript);
            postE.appendChild(scriptE);
            taskE.appendChild(postE);
        }
        if ((cleanScript = task.getCleaningScript()) != null) {
            Element cleanE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_CLEANING.getXMLName());
            Element scriptE = this.createScriptElement(doc, cleanScript);
            cleanE.appendChild(scriptE);
            taskE.appendChild(cleanE);
        }
        if ((outputFiles = task.getOutputFilesList()) != null) {
            Element outputFilesE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.DS_OUTPUT_FILES.getXMLName());
            for (OutputSelector outputSelector : outputFiles) {
                FileSelector fs = outputSelector.getOutputFiles();
                Element filesE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.DS_FILES.getXMLName());
                if (!fs.getIncludes().isEmpty()) {
                    this.setAttribute(filesE, XMLAttributes.DS_INCLUDES, (String)fs.getIncludes().iterator().next(), true);
                }
                if (!fs.getExcludes().isEmpty()) {
                    this.setAttribute(filesE, XMLAttributes.DS_EXCLUDES, (String)fs.getExcludes().iterator().next(), true);
                }
                if (outputSelector.getMode() != null) {
                    this.setAttribute(filesE, XMLAttributes.DS_ACCESS_MODE, outputSelector.getMode().toString(), true);
                }
                outputFilesE.appendChild(filesE);
            }
            taskE.appendChild(outputFilesE);
        }
        return taskE;
    }

    private Element createParallelEnvironment(Document doc, Task task) {
        ParallelEnvironment penv = task.getParallelEnvironment();
        if (penv == null) {
            return null;
        }
        Element parallelEnvE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.PARALLEL_ENV.getXMLName());
        this.setAttribute(parallelEnvE, XMLAttributes.TASK_NB_NODES, Integer.toString(penv.getNodesNumber()));
        TopologyDescriptor topologyDescr = penv.getTopologyDescriptor();
        if (topologyDescr != null) {
            Element topologyE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY.getXMLName());
            Element topologyDescrE = null;
            if (topologyDescr instanceof ArbitraryTopologyDescriptor) {
                topologyDescrE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY_ARBITRARY.getXMLName());
            } else if (topologyDescr instanceof ThresholdProximityDescriptor) {
                topologyDescrE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY_THRESHOLD_PROXIMITY.getXMLName());
                long threshold = ((ThresholdProximityDescriptor)topologyDescr).getThreshold();
                topologyDescrE.setAttribute(XMLAttributes.TOPOLOGY_THRESHOLD.getXMLName(), Long.toString(threshold));
            } else if (topologyDescr instanceof BestProximityDescriptor) {
                topologyDescrE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY_BEST_PROXIMITY.getXMLName());
            } else if (topologyDescr instanceof SingleHostExclusiveDescriptor) {
                topologyDescrE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY_SINGLE_HOST_EXCLUSIVE.getXMLName());
            } else if (topologyDescr instanceof SingleHostDescriptor) {
                topologyDescrE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY_SINGLE_HOST.getXMLName());
            } else if (topologyDescr instanceof MultipleHostsExclusiveDescriptor) {
                topologyDescrE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY_MULTIPLE_HOSTS_EXCLUSIVE.getXMLName());
            }
            if (topologyDescr instanceof DifferentHostsExclusiveDescriptor) {
                topologyDescrE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TOPOLOGY_DIFFERENT_HOSTS_EXCLUSIVE.getXMLName());
            }
            if (topologyDescrE != null) {
                topologyE.appendChild(topologyDescrE);
            }
            parallelEnvE.appendChild(topologyE);
        }
        return parallelEnvE;
    }

    private Element createFlowControlElement(Document doc, Task task) {
        FlowScript flowScript;
        Element controlFlowE = null;
        if (task.getFlowBlock() != FlowBlock.NONE) {
            controlFlowE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FLOW.getXMLName());
            this.setAttribute(controlFlowE, XMLAttributes.FLOW_BLOCK, task.getFlowBlock().toString());
        }
        if ((flowScript = task.getFlowScript()) != null) {
            Element flowActionE = null;
            if (flowScript.getActionType().equals(FlowActionType.IF.toString())) {
                flowActionE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FLOW_IF.getXMLName());
                this.setAttribute(flowActionE, XMLAttributes.FLOW_TARGET, flowScript.getActionTarget(), true);
                this.setAttribute(flowActionE, XMLAttributes.FLOW_ELSE, flowScript.getActionTargetElse(), true);
                this.setAttribute(flowActionE, XMLAttributes.FLOW_CONTINUATION, flowScript.getActionContinuation(), true);
            }
            if (flowScript.getActionType().equals(FlowActionType.LOOP.toString())) {
                flowActionE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FLOW_LOOP.getXMLName());
                this.setAttribute(flowActionE, XMLAttributes.FLOW_TARGET, flowScript.getActionTarget(), true);
            }
            if (flowScript.getActionType().equals(FlowActionType.REPLICATE.toString())) {
                flowActionE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FLOW_REPLICATE.getXMLName());
            }
            if (flowActionE != null) {
                if (controlFlowE == null) {
                    controlFlowE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FLOW.getXMLName());
                }
                Element scriptE = this.createScriptElement(doc, flowScript);
                flowActionE.appendChild(scriptE);
                controlFlowE.appendChild(flowActionE);
            }
        }
        return controlFlowE;
    }

    private Element createScriptElement(Document doc, Script script) {
        Element scriptElement = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_SCRIPT.getXMLName());
        if (script.getScriptUrl() != null && script.getScript() == null) {
            Serializable[] params;
            Element fileE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_FILE.getXMLName());
            this.setAttribute(fileE, XMLAttributes.SCRIPT_URL, script.getScriptUrl().toExternalForm(), true);
            if (script.getEngineName() != null) {
                this.setAttribute(fileE, XMLAttributes.LANGUAGE, script.getEngineName(), true);
            }
            if ((params = script.getParameters()) != null) {
                Element parametersE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_ARGUMENTS.getXMLName());
                for (Serializable param : params) {
                    Element parameterE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_ARGUMENT.getXMLName());
                    this.setAttribute(parameterE, XMLAttributes.COMMON_VALUE, param.toString(), true);
                    parametersE.appendChild(parameterE);
                }
                fileE.appendChild(parametersE);
            }
            scriptElement.appendChild(fileE);
        } else {
            Element codeE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_CODE.getXMLName());
            this.setAttribute(codeE, XMLAttributes.LANGUAGE, script.getEngineName(), true);
            codeE.appendChild(doc.createCDATASection(script.getScript()));
            scriptElement.appendChild(codeE);
            Serializable[] params = script.getParameters();
            if (params != null) {
                Element parametersE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_ARGUMENTS.getXMLName());
                for (Serializable param : params) {
                    Element parameterE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_ARGUMENT.getXMLName());
                    this.setAttribute(parameterE, XMLAttributes.COMMON_VALUE, param.toString(), true);
                    parametersE.appendChild(parameterE);
                }
                scriptElement.appendChild(parametersE);
            }
        }
        return scriptElement;
    }

    private Element createJavaExecutableElement(Document doc, JavaTask t) {
        Element executableE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.JAVA_EXECUTABLE.getXMLName());
        this.setAttribute(executableE, XMLAttributes.TASK_CLASS_NAME, t.getExecutableClassName(), true);
        try {
            Map<String, Serializable> args = t.getArguments();
            if (args != null && args.size() > 0) {
                Element paramsE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TASK_PARAMETERS.getXMLName());
                for (String name : args.keySet()) {
                    Serializable val = args.get(name);
                    Element paramE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.TASK_PARAMETER.getXMLName());
                    this.setAttribute(paramE, XMLAttributes.COMMON_NAME, name, true);
                    this.setAttribute(paramE, XMLAttributes.COMMON_VALUE, val.toString(), true);
                    paramsE.appendChild(paramE);
                }
                executableE.appendChild(paramsE);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not add arguments for Java Executable element of task " + t.getName()), (Throwable)e);
        }
        return executableE;
    }

    private Element createForkEnvironmentElement(Document doc, ForkEnvironment fe) {
        List<String> additionalCP;
        List<String> args;
        Element forkEnvE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FORK_ENVIRONMENT.getXMLName());
        this.setAttribute(forkEnvE, XMLAttributes.TASK_WORKDING_DIR, fe.getWorkingDir(), true);
        this.setAttribute(forkEnvE, XMLAttributes.FORK_JAVA_HOME, fe.getJavaHome(), true);
        if (fe.getSystemEnvironment() != null && fe.getSystemEnvironment().keySet().size() > 0) {
            Element sysEnvE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FORK_SYSTEM_PROPERTIES.getXMLName());
            if (fe.getSystemEnvironment() != null) {
                for (Map.Entry<String, String> entry : fe.getSystemEnvironment().entrySet()) {
                    Element element = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.VARIABLE.getXMLName());
                    this.setAttribute(element, XMLAttributes.COMMON_NAME, entry.getKey());
                    this.setAttribute(element, XMLAttributes.COMMON_VALUE, entry.getValue());
                    sysEnvE.appendChild(element);
                }
            }
            forkEnvE.appendChild(sysEnvE);
        }
        if ((args = fe.getJVMArguments()) != null && args.size() > 0) {
            Element jvmArgsE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FORK_JVM_ARGS.getXMLName());
            for (String string : args) {
                Element argE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FORK_JVM_ARG.getXMLName());
                this.setAttribute(argE, XMLAttributes.COMMON_VALUE, string, true);
                jvmArgsE.appendChild(argE);
            }
            forkEnvE.appendChild(jvmArgsE);
        }
        if ((additionalCP = fe.getAdditionalClasspath()) != null && additionalCP.size() > 0) {
            Element element = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FORK_ADDITIONAL_CLASSPATH.getXMLName());
            for (String pathElement : additionalCP) {
                Element pathE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.FORK_PATH_ELEMENT.getXMLName());
                this.setAttribute(pathE, XMLAttributes.PATH, pathElement, true);
                element.appendChild(pathE);
            }
            forkEnvE.appendChild(element);
        }
        if (fe.getEnvScript() != null) {
            Element element = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_ENV.getXMLName());
            Element element2 = this.createScriptElement(doc, fe.getEnvScript());
            element.appendChild(element2);
            forkEnvE.appendChild(element);
        }
        return forkEnvE;
    }

    private Element createNativeExecutableElement(Document doc, NativeTask t) {
        Element nativeExecE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.NATIVE_EXECUTABLE.getXMLName());
        String[] cmd = t.getCommandLine();
        if (cmd != null && cmd.length > 0) {
            Element staticCmdE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.NATIVE_TASK_STATIC_COMMAND.getXMLName());
            this.setAttribute(staticCmdE, XMLAttributes.TASK_COMMAND_VALUE, cmd[0], true);
            if (cmd.length > 1) {
                Element argsE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.NATIVE_TASK_ARGUMENTS.getXMLName());
                for (int i = 1; i < cmd.length; ++i) {
                    Element argE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.NATIVE_TASK_ARGUMENT.getXMLName());
                    this.setAttribute(argE, XMLAttributes.COMMON_VALUE, cmd[i], true);
                    argsE.appendChild(argE);
                }
                staticCmdE.appendChild(argsE);
            }
            nativeExecE.appendChild(staticCmdE);
        } else {
            logger.error((Object)("The task " + t.getName() + " does not define a command"));
        }
        return nativeExecE;
    }

    private Element createScriptExecutableElement(Document doc, ScriptTask t) {
        Element scriptExecE = doc.createElementNS(Schemas.SCHEMA_LATEST.getNamespace(), XMLTags.SCRIPT_EXECUTABLE.getXMLName());
        Element scriptE = this.createScriptElement(doc, (Script)t.getScript());
        scriptExecE.appendChild(scriptE);
        return scriptExecE;
    }

    private static String formatDate(long millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        String formatted = String.format("%02d:%02d:%02d", hours, minutes, seconds);
        return formatted.replaceFirst("^(00:)+", "");
    }
}

