from .countries import Russia, USA
from . import unit
from .mission import Mission
from . import mapping


class VehicleTemplate:
    class Russia:
        @staticmethod
        def sa10_site(mission: Mission, position: mapping.Point, heading, prefix="", skill=unit.Skill.Average):
            russia = mission.country("Russia")
            vg = mission.vehicle_group(russia, prefix + "SA10 site",
                                       Russia.Vehicle.AirDefence.SAM_SA_10_S_300PS_CP_54K6, position, heading)
            u = mission.vehicle("Operator 1", Russia.Vehicle.Infantry.Infantry_Soldier_Rus)
            u.position = position.point_from_heading(heading + 180, 10)
            u.heading = heading
            vg.add_unit(u)

            hdg = 90
            for i in range(0, 3):  # 3 launchers
                u = mission.vehicle("launcher #" + str(i+1), Russia.Vehicle.AirDefence.SAM_SA_10_S_300PS_LN_5P85C)
                u.position = position.point_from_heading(heading + hdg, 50)
                u.heading = heading
                vg.add_unit(u)
                hdg += 90

            u = mission.vehicle("radar", Russia.Vehicle.AirDefence.SAM_SA_10_S_300PS_TR_30N6)
            u.position = position.point_from_heading(heading, 80)
            u.heading = heading
            vg.add_unit(u)

            u = mission.vehicle("radar", Russia.Vehicle.AirDefence.SAM_SA_10_S_300PS_SR_64H6E)
            u.position = position.point_from_heading(heading + 180, 100)
            u.heading = heading
            vg.add_unit(u)

            for u in vg.units:
                u.skill = skill

            return vg

    class USA:
        @staticmethod
        def patriot_site(mission: Mission, position, heading, prefix="", skill=unit.Skill.Average):
            usa = mission.country("USA")
            vg = mission.vehicle_group(usa, prefix + "Patriot site", USA.Vehicle.AirDefence.SAM_Patriot_ICC, position, heading)
            u = mission.vehicle("Operator 1", USA.Vehicle.Infantry.Infantry_M4)
            u.position = position.point_from_heading(heading + 180, 5)
            u.heading = heading
            vg.add_unit(u)

            hdg = 90
            for i in range(0, 2):  # 2 launchers
                u = mission.vehicle("launcher #" + str(i+1), USA.Vehicle.AirDefence.SAM_Patriot_LN_M901)
                u.position = position.point_from_heading(heading + hdg, 50)
                u.heading = heading
                vg.add_unit(u)
                hdg += 90

            u = mission.vehicle("Electronic power plant", USA.Vehicle.AirDefence.SAM_Patriot_EPP_III)
            u.position = position.point_from_heading(heading + 180, 50)
            u.heading = heading
            vg.add_unit(u)

            u = mission.vehicle("radar", USA.Vehicle.AirDefence.SAM_Patriot_STR_AN_MPQ_53)
            u.position = position.point_from_heading(heading, 80)
            u.heading = heading
            vg.add_unit(u)

            inf = mission.vehicle("Operator 2", USA.Vehicle.Infantry.Infantry_M4)
            inf.position = position.point_from_heading(heading + 270, 5)
            vg.add_unit(inf)

            u = mission.vehicle("Antenna", USA.Vehicle.AirDefence.SAM_Patriot_AMG_AN_MRC_137)
            u.position = position.point_from_heading(heading + 180, 100)
            u.heading = heading
            vg.add_unit(u)

            u = mission.vehicle("ECS", USA.Vehicle.AirDefence.SAM_Patriot_ECS_AN_MSQ_104)
            u.position = position.point_from_heading(heading + 120, 80)
            u.heading = heading
            vg.add_unit(u)

            for u in vg.units:
                u.skill = skill

        @staticmethod
        def hawk_site(mission: Mission, position, heading, prefix="", skill=unit.Skill.Average):
            usa = mission.country("USA")
            vg = mission.vehicle_group(usa, prefix + "Hawk site", USA.Vehicle.AirDefence.SAM_Hawk_PCP, position, heading)

            u = mission.vehicle("Operator 1", USA.Vehicle.Infantry.Infantry_M4)
            u.position = position.point_from_heading(heading + 180, 5)
            u.heading = heading
            vg.add_unit(u)

            hdg = 90
            for i in range(0, 2):  # 2 launchers
                u = mission.vehicle("launcher #" + str(i+1), USA.Vehicle.AirDefence.SAM_Hawk_LN_M192)
                u.position = position.point_from_heading(heading + hdg, 50)
                u.heading = heading
                vg.add_unit(u)
                hdg += 90

            u = mission.vehicle("Radar", USA.Vehicle.AirDefence.SAM_Hawk_SR_AN_MPQ_50)
            u.position = position.point_from_heading(heading + 180, 20)
            u.heading = heading
            vg.add_unit(u)

            inf = mission.vehicle("Operator 2", USA.Vehicle.Infantry.Infantry_M4)
            inf.position = position.point_from_heading(heading + 270, 5)
            vg.add_unit(inf)

            u = mission.vehicle("Tower", USA.Vehicle.AirDefence.SAM_Hawk_TR_AN_MPQ_46)
            u.position = position.point_from_heading(heading + 80, 80)
            u.heading = heading
            vg.add_unit(u)

            u = mission.vehicle("Wave Radar", USA.Vehicle.AirDefence.SAM_Hawk_CWAR_AN_MPQ_55)
            u.position = position.point_from_heading(heading + 180, 100)
            u.heading = heading
            vg.add_unit(u)

            for u in vg.units:
                u.skill = skill
