# -*- coding: utf-8 -*-
# Generated by Django 1.9.8 on 2016-07-24 15:16
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import simple_files.settings


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Files',
            fields=[
                ('file_id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('file_uri', models.FileField(max_length=255, upload_to=simple_files.settings.get_upload_to, verbose_name='文件')),
                ('file_size', models.BigIntegerField(default=0, verbose_name='文件大小')),
                ('file_hash', models.CharField(max_length=32, verbose_name='文件hash')),
                ('time_created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='上传时间')),
                ('uploader_uid', models.IntegerField(default=0, verbose_name='上传者UID')),
            ],
            options={
                'verbose_name_plural': '文件存档',
                'verbose_name': '文件存档',
                'ordering': ['-file_id'],
            },
        ),
        migrations.CreateModel(
            name='FilesRelated',
            fields=[
                ('related_id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('file_uri', models.CharField(max_length=255, verbose_name='文件')),
                ('related_object_id', models.CharField(db_index=True, max_length=191, verbose_name='对象PK')),
                ('related_object', models.CharField(db_index=True, max_length=100, verbose_name='对象名')),
                ('time_created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='上传时间')),
                ('file', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simple_files.Files')),
            ],
            options={
                'verbose_name_plural': '文件关系存储',
                'verbose_name': '文件关系存储',
                'ordering': ['-related_id'],
            },
        ),
    ]
