from numpy import atleast_2d
from flopy.mbase import Package

class ModflowChd(Package):
    'Constant-head boundary package class\n'
    def __init__(self, model, layer_row_column_shead_ehead=None, cosines=None, extension ='chd', unitnumber=24):
        Package.__init__(self, model, extension, 'CHD', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.url = 'chd.htm'
        self.heading = '# CHD for MODFLOW, generated by Flopy.'
        self.mxactc, self.layer_row_column_shead_ehead = self.assign_layer_row_column_data(layer_row_column_shead_ehead, 5)
        self.np = 0
        self.parent.add_package(self)
    def __repr__(self):
        return 'CHD package class'
    def ncells( self):
        # Returns the  maximum number of cells that have recharge (developped for MT3DMS SSM package)
        return self.mxactc
    def write_file(self):
        f_chd = open(self.fn_path, 'w')
        f_chd.write('%s\n' % self.heading)
        f_chd.write('%10i\n' % (self.mxactc))
        self.write_layer_row_column_data(f_chd, self.layer_row_column_shead_ehead)
        f_chd.close()

