/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Dimension;
import javax.swing.JTextPane;
import org.sikuli.guide.Visual;

class HTMLTextPane
extends JTextPane {
    int maximum_width;
    String text;
    public Dimension preferredDimension;
    Visual comp = null;
    String htmltxt;

    public HTMLTextPane(Visual comp) {
        this.comp = comp;
        this.maximum_width = comp.maxWidth - 10;
        this.init();
    }

    public HTMLTextPane() {
        this.maximum_width = 400;
        this.init();
    }

    private void init() {
        this.setContentType("text/html");
    }

    @Override
    public void setText(String text) {
        this.text = text;
        if (this.comp != null) {
            this.maximum_width = this.comp.maxWidth - 2 * this.comp.PADDING_X;
            this.htmltxt = "<html><div style='" + this.comp.getStyleString() + "'>" + text + "</div></html>";
        } else {
            this.htmltxt = "<html><font size=5>" + text + "</font></html>";
        }
        super.setText(this.htmltxt);
        JTextPane tp = new JTextPane();
        tp.setText(this.htmltxt);
        if (this.getPreferredSize().getWidth() > (double)this.maximum_width) {
            this.htmltxt = this.comp != null ? "<html><div style='width:" + this.maximum_width + ";" + this.comp.getStyleString() + "'>" + text + "</div></html>" : "<html><div width='" + this.maximum_width + "'><font size=5>" + text + "</font></div></html>";
            super.setText(this.htmltxt);
        }
        this.setSize(this.getPreferredSize());
    }

    @Override
    public String getText() {
        return this.text;
    }
}

