<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:col="http://cnx.rice.edu/collxml"
  xmlns:c="http://cnx.rice.edu/cnxml"
  xmlns:m="http://www.w3.org/1998/Math/MathML"
  xmlns:md="http://cnx.rice.edu/mdml"
  xmlns:qml="http://cnx.rice.edu/qml/1.0"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:mod="http://cnx.rice.edu/#moduleIds"
  xmlns:bib="http://bibtexml.sf.net/"
  xmlns:data="http://dev.w3.org/html5/spec/#custom"
  >

<xsl:output omit-xml-declaration="yes" encoding="ASCII"/>

<xsl:include href="cnxml-to-html5.xsl"/>


<xsl:template match="col:*|md:*"/>

<xsl:template match="@*">
  <xsl:attribute name="data-{local-name()}">
    <xsl:value-of select="."/>
  </xsl:attribute>
</xsl:template>


<!-- Add the Book title and abstract -->
<xsl:template match="/col:collection/col:metadata/md:title">
  <h1><xsl:apply-templates select="@*|node()"/></h1>
</xsl:template>

<xsl:template match="/col:collection/col:metadata/md:abstract">
  <div data-type="abstract">
    <xsl:apply-templates select="@*|node()"/>
  </div>
</xsl:template>

<xsl:template match="col:collection">
	<xsl:variable name="url">
		<xsl:value-of select="col:metadata/md:content-url/text()"/>
	</xsl:variable>
	<xsl:variable name="id">
		<xsl:value-of select="col:metadata/md:content-id/text()"/>
	</xsl:variable>
  <body>
    <xsl:apply-templates select="col:metadata/md:title|col:metadata/md:abstract"/>
  	<nav class="book" data-url="{col:metadata/md:content-url/text()}" data-id="{col:metadata/md:content-id/text()}" data-repository="{col:metadata/md:repository/text()}">
  		<xsl:apply-templates select="@*|node()"/>
  	</nav>
  </body>
</xsl:template>


<!--adding units as subcollection-->

<xsl:template match="col:collection/col:content/col:subcollection[col:content/col:subcollection]">
  <li class="part">
    <xsl:apply-templates select="node()"/> <!-- this wil match cnx:title and col:subcollection -->
  </li>
</xsl:template>




<!-- end of test TOC -->


<!-- Modules before the first subcollection are preface frontmatter -->
<xsl:template match="col:collection/col:content[col:subcollection and col:module]/col:module[not(preceding-sibling::col:subcollection)]" priority="100">
	<li class="preface">
		<xsl:apply-templates select="@*"/>
		<xsl:call-template name="cnx.xinclude.module"/>
	</li>
</xsl:template>

<!-- Modules after the last subcollection are appendices -->
<xsl:template match="col:collection/col:content[col:subcollection and col:module]/col:module[not(following-sibling::col:subcollection)]" priority="100">
  <li class="appendix">
		<xsl:apply-templates select="@*"/>
		<xsl:call-template name="cnx.xinclude.module"/>
  </li>
</xsl:template>


<!-- Free-floating Modules in a col:collection should be treated as Chapters -->
<xsl:template match="col:collection/col:content/col:subcollection/col:module">
  <li class="chapter">
		<xsl:apply-templates select="@*"/>
		<xsl:call-template name="cnx.xinclude.module"/>
	</li>
</xsl:template>

<xsl:template match="col:collection/col:content/col:subcollection[not(col:content/col:subcollection)]">
	<li class="chapter">
		<xsl:apply-templates select="@*|node()"/>
	</li>
</xsl:template>

<xsl:template match="col:collection/col:content/col:subcollection/col:content/col:subcollection" priority="10">
  <li class="chapter">
    <xsl:apply-templates select="@*|node()"/>
  </li>
</xsl:template>

<xsl:template match="col:collection/col:content[not(col:subcollection)]/col:module">
  <li class="chapter">
    <xsl:apply-templates select="@*"/>
		<xsl:call-template name="cnx.xinclude.module"/>
  </li>
</xsl:template>


<!-- Subcollections in a chapter should be treated as a li -->
<xsl:template match="col:subcollection/col:content/col:subcollection">
	<li><xsl:apply-templates select="@*|node()"/></li>
</xsl:template>

<xsl:template match="col:content">
  <ol>
	  <xsl:apply-templates/>
  </ol>
</xsl:template>

<xsl:template match="col:module">
  <li>
    <xsl:apply-templates select="@*"/>
    <xsl:call-template name="cnx.xinclude.module"/>
  </li>
</xsl:template>


<xsl:template match="@id|@xml:id|comment()|processing-instruction()">
  <xsl:copy/>
</xsl:template>

<xsl:template match="col:subcollection/md:title">
  <span class="title"><xsl:apply-templates select="node()"/></span>
</xsl:template>

<xsl:template match="col:module/md:title"/>

<xsl:template name="cnx.xinclude.module">
  <a class="xinclude" href="{@document}.xhtml">
    <xsl:choose>
      <xsl:when test="md:title">
        <xsl:attribute name="class">
          <xsl:text>xinclude overridden-content</xsl:text>
        </xsl:attribute>
        <xsl:apply-templates select="md:title/node()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="class">
          <xsl:text>xinclude autogenerated-content</xsl:text>
        </xsl:attribute>
        <xsl:text>[xinclude]</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </a>
</xsl:template>


</xsl:stylesheet>
