/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import com.ibm.icu.util.ULocale;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.URL;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

public final class LanguageDetectingXMLReaderWrapper
implements XMLReader,
ContentHandler {
    private static final Logger log4j = Logger.getLogger(LanguageDetectingXMLReaderWrapper.class);
    private static final String languageList = "nu/validator/localentities/files/language-profiles-list.txt";
    private static final String profilesDir = "nu/validator/localentities/files/language-profiles/";
    private static List<String> profiles = new ArrayList<String>();
    private static List<String> languageTags = new ArrayList<String>();
    private static final Map<String, String[]> LANG_TAGS_BY_TLD = new HashMap<String, String[]>();
    private final XMLReader wrappedReader;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private HttpServletRequest request;
    private String systemId;
    private String tld;
    private Locator locator = null;
    private Locator htmlStartTagLocator;
    private StringBuilder elementContent;
    private StringBuilder documentContent;
    private String httpContentLangHeader;
    private String htmlElementLangAttrValue;
    private String declaredLangCode;
    private boolean htmlElementHasLang;
    private String dirAttrValue;
    private boolean hasDir;
    private boolean inBody;
    private int currentOpenElementsInDifferentLang;
    private boolean loggedLinkWithCharset;
    private boolean loggedScriptWithCharset;
    private boolean loggedStyleInBody;
    private boolean loggedRelAlternate;
    private boolean loggedRelAuthor;
    private boolean loggedRelBookmark;
    private boolean loggedRelCanonical;
    private boolean loggedRelDnsPrefetch;
    private boolean loggedRelExternal;
    private boolean loggedRelHelp;
    private boolean loggedRelIcon;
    private boolean loggedRelLicense;
    private boolean loggedRelNext;
    private boolean loggedRelNofollow;
    private boolean loggedRelNoopener;
    private boolean loggedRelNoreferrer;
    private boolean loggedRelPingback;
    private boolean loggedRelPreconnect;
    private boolean loggedRelPrefetch;
    private boolean loggedRelPreload;
    private boolean loggedRelPrerender;
    private boolean loggedRelPrev;
    private boolean loggedRelSearch;
    private boolean loggedRelServiceworker;
    private boolean loggedRelStylesheet;
    private boolean loggedRelTag;
    private boolean collectingCharacters;
    private int nonWhitespaceCharacterCount;
    private static final int MAX_CHARS = 30720;
    private static final int MIN_CHARS = 1024;
    private static final double MIN_PROBABILITY = 0.9;
    private static final String[] RTL_LANGS;
    private static final String[] COMMON_LANGS;

    public static void initialize() throws LangDetectException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(LanguageDetectingXMLReaderWrapper.class.getClassLoader().getResourceAsStream(languageList)));
            String languageTagAndName = br.readLine();
            while (languageTagAndName != null) {
                languageTags.add(languageTagAndName.split("\t")[0]);
                languageTagAndName = br.readLine();
            }
            for (String languageTag : languageTags) {
                profiles.add(new BufferedReader(new InputStreamReader(LanguageDetectingXMLReaderWrapper.class.getClassLoader().getResourceAsStream(profilesDir + languageTag))).readLine());
            }
            DetectorFactory.clear();
            DetectorFactory.loadProfile(profiles);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LanguageDetectingXMLReaderWrapper(XMLReader wrappedReader, HttpServletRequest request, ErrorHandler errorHandler, String httpContentLangHeader, String systemId) {
        this.wrappedReader = wrappedReader;
        this.contentHandler = wrappedReader.getContentHandler();
        this.errorHandler = errorHandler;
        this.request = request;
        this.systemId = systemId;
        this.tld = "";
        this.htmlStartTagLocator = null;
        this.inBody = false;
        this.currentOpenElementsInDifferentLang = 0;
        this.loggedLinkWithCharset = false;
        this.loggedScriptWithCharset = false;
        this.loggedStyleInBody = false;
        this.loggedRelAlternate = false;
        this.loggedRelAuthor = false;
        this.loggedRelBookmark = false;
        this.loggedRelCanonical = false;
        this.loggedStyleInBody = false;
        this.loggedRelAlternate = false;
        this.loggedRelAuthor = false;
        this.loggedRelBookmark = false;
        this.loggedRelCanonical = false;
        this.loggedRelDnsPrefetch = false;
        this.loggedRelExternal = false;
        this.loggedRelHelp = false;
        this.loggedRelIcon = false;
        this.loggedRelLicense = false;
        this.loggedRelNext = false;
        this.loggedRelNofollow = false;
        this.loggedRelNoopener = false;
        this.loggedRelNoreferrer = false;
        this.loggedRelPingback = false;
        this.loggedRelPreconnect = false;
        this.loggedRelPrefetch = false;
        this.loggedRelPreload = false;
        this.loggedRelPrerender = false;
        this.loggedRelPrev = false;
        this.loggedRelSearch = false;
        this.loggedRelServiceworker = false;
        this.loggedRelStylesheet = false;
        this.loggedRelTag = false;
        this.collectingCharacters = false;
        this.nonWhitespaceCharacterCount = 0;
        this.elementContent = new StringBuilder();
        this.documentContent = new StringBuilder();
        this.httpContentLangHeader = httpContentLangHeader;
        this.htmlElementHasLang = false;
        this.htmlElementLangAttrValue = "";
        this.declaredLangCode = "";
        this.hasDir = false;
        this.dirAttrValue = "";
        try {
            Host hostname;
            if (systemId != null && systemId.startsWith("http") && (hostname = URL.parse(systemId).host()) != null) {
                String host = hostname.toString();
                this.tld = host.substring(host.lastIndexOf(".") + 1);
            }
        }
        catch (GalimatiasParseException e) {
            throw new RuntimeException(e);
        }
        wrappedReader.setContentHandler(this);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.collectingCharacters && this.nonWhitespaceCharacterCount < 30720) {
            block3: for (int i = start; i < start + length; ++i) {
                switch (ch[i]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        ++this.nonWhitespaceCharacterCount;
                    }
                }
            }
            this.elementContent.append(ch, start, length);
        }
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.nonWhitespaceCharacterCount < 30720) {
            this.documentContent.append((CharSequence)this.elementContent);
            this.elementContent.setLength(0);
        }
        if ("body".equals(localName)) {
            this.inBody = false;
            this.collectingCharacters = false;
        }
        if (this.currentOpenElementsInDifferentLang > 0) {
            --this.currentOpenElementsInDifferentLang;
            if (this.currentOpenElementsInDifferentLang == 0) {
                this.collectingCharacters = true;
            }
        } else if (this.inBody && ("script".equals(localName) || "style".equals(localName) || "pre".equals(localName) || "a".equals(localName) || "td".equals(localName) || "select".equals(localName) || "ul".equals(localName) || "nav".equals(localName) || "form".equals(localName))) {
            this.collectingCharacters = true;
        }
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.documentContent.setLength(0);
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int i;
        if (this.contentHandler == null) {
            return;
        }
        if ("html".equals(localName)) {
            this.htmlStartTagLocator = new LocatorImpl(this.locator);
            for (i = 0; i < atts.getLength(); ++i) {
                if ("lang".equals(atts.getLocalName(i))) {
                    if (this.request != null) {
                        this.request.setAttribute("http://validator.nu/properties/lang-found", true);
                    }
                    this.htmlElementHasLang = true;
                    this.htmlElementLangAttrValue = atts.getValue(i);
                    this.declaredLangCode = new ULocale(this.htmlElementLangAttrValue).getLanguage();
                    continue;
                }
                if (!"dir".equals(atts.getLocalName(i))) continue;
                this.hasDir = true;
                this.dirAttrValue = atts.getValue(i);
            }
        } else if ("link".equals(localName)) {
            boolean hasAppleTouchIcon = false;
            boolean hasSizes = false;
            for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                if ("rel".equals(atts.getLocalName(i2))) {
                    if (!atts.getValue(i2).contains("apple-touch-icon")) continue;
                    hasAppleTouchIcon = true;
                    continue;
                }
                if ("sizes".equals(atts.getLocalName(i2))) {
                    hasSizes = true;
                    continue;
                }
                if (!"charset".equals(atts.getLocalName(i2)) || this.loggedLinkWithCharset) continue;
                this.loggedLinkWithCharset = true;
                if (this.request == null) continue;
                this.request.setAttribute("http://validator.nu/properties/link-with-charset-found", true);
            }
            if (this.request != null && hasAppleTouchIcon && hasSizes) {
                this.request.setAttribute("http://validator.nu/properties/apple-touch-icon-with-sizes-found", true);
            }
        } else if ("script".equals(localName) && !this.loggedScriptWithCharset) {
            for (i = 0; i < atts.getLength(); ++i) {
                if (!"charset".equals(atts.getLocalName(i))) continue;
                this.loggedScriptWithCharset = true;
                if (this.request == null) continue;
                this.request.setAttribute("http://validator.nu/properties/script-with-charset-found", true);
            }
        } else if (this.inBody && "style".equals(localName) && !this.loggedStyleInBody) {
            this.loggedStyleInBody = true;
            if (this.request != null) {
                this.request.setAttribute("http://validator.nu/properties/style-in-body-found", true);
            }
        } else if ("body".equals(localName)) {
            this.inBody = true;
            this.collectingCharacters = true;
        } else if (this.inBody) {
            if (this.currentOpenElementsInDifferentLang > 0) {
                ++this.currentOpenElementsInDifferentLang;
            } else {
                for (i = 0; i < atts.getLength(); ++i) {
                    if (!"lang".equals(atts.getLocalName(i)) || "".equals(this.htmlElementLangAttrValue) || this.htmlElementLangAttrValue.equals(atts.getValue(i))) continue;
                    ++this.currentOpenElementsInDifferentLang;
                    this.collectingCharacters = false;
                }
            }
        }
        if (atts.getIndex("", "rel") > -1 && ("link".equals(localName) || "a".equals(localName))) {
            List<String> relValues = Arrays.asList(atts.getValue("", "rel").trim().toLowerCase().split("\\s+"));
            if (relValues.contains("alternate") && !this.loggedRelAlternate) {
                this.loggedRelAlternate = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-alternate-found", true);
                }
            }
            if (relValues.contains("author") && !this.loggedRelAuthor) {
                this.loggedRelAuthor = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-author-found", true);
                }
            }
            if (relValues.contains("bookmark") && !this.loggedRelBookmark) {
                this.loggedRelBookmark = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-bookmark-found", true);
                }
            }
            if (relValues.contains("canonical") && !this.loggedRelCanonical) {
                this.loggedRelCanonical = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-canonical-found", true);
                }
            }
            if (relValues.contains("dns-prefetch") && !this.loggedRelDnsPrefetch) {
                this.loggedRelDnsPrefetch = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-dns-prefetch-found", true);
                }
            }
            if (relValues.contains("external") && !this.loggedRelExternal) {
                this.loggedRelExternal = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-external-found", true);
                }
            }
            if (relValues.contains("help") && !this.loggedRelHelp) {
                this.loggedRelHelp = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-help-found", true);
                }
            }
            if (relValues.contains("icon") && !this.loggedRelIcon) {
                this.loggedRelIcon = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-icon-found", true);
                }
            }
            if (relValues.contains("license") && !this.loggedRelLicense) {
                this.loggedRelLicense = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-license-found", true);
                }
            }
            if (relValues.contains("next") && !this.loggedRelNext) {
                this.loggedRelNext = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-next-found", true);
                }
            }
            if (relValues.contains("nofollow") && !this.loggedRelNofollow) {
                this.loggedRelNofollow = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-nofollow-found", true);
                }
            }
            if (relValues.contains("noopener") && !this.loggedRelNoopener) {
                this.loggedRelNoopener = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-noopener-found", true);
                }
            }
            if (relValues.contains("noreferrer") && !this.loggedRelNoreferrer) {
                this.loggedRelNoreferrer = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-noreferrer-found", true);
                }
            }
            if (relValues.contains("pingback") && !this.loggedRelPingback) {
                this.loggedRelPingback = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-pingback-found", true);
                }
            }
            if (relValues.contains("preconnect") && !this.loggedRelPreconnect) {
                this.loggedRelPreconnect = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-preconnect-found", true);
                }
            }
            if (relValues.contains("prefetch") && !this.loggedRelPrefetch) {
                this.loggedRelPrefetch = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-prefetch-found", true);
                }
            }
            if (relValues.contains("preload") && !this.loggedRelPreload) {
                this.loggedRelPreload = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-preload-found", true);
                }
            }
            if (relValues.contains("prerender") && !this.loggedRelPrerender) {
                this.loggedRelPrerender = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-prerender-found", true);
                }
            }
            if (relValues.contains("prev") && !this.loggedRelPrev) {
                this.loggedRelPrev = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-prev-found", true);
                }
            }
            if (relValues.contains("search") && !this.loggedRelSearch) {
                this.loggedRelSearch = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-search-found", true);
                }
            }
            if (relValues.contains("serviceworker") && !this.loggedRelServiceworker) {
                this.loggedRelServiceworker = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-serviceworker-found", true);
                }
            }
            if (relValues.contains("stylesheet") && !this.loggedRelStylesheet) {
                this.loggedRelStylesheet = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-stylesheet-found", true);
                }
            }
            if (relValues.contains("tag") && !this.loggedRelTag) {
                this.loggedRelTag = true;
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/rel-tag-found", true);
                }
            }
        }
        if ("script".equals(localName) || "style".equals(localName) || "pre".equals(localName) || "a".equals(localName) || "td".equals(localName) || "select".equals(localName) || "ul".equals(localName) || "nav".equals(localName) || "textarea".equals(localName) || "figcaption".equals(localName) || "form".equals(localName)) {
            this.collectingCharacters = false;
        }
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler == null) {
            return;
        }
        this.locator = locator;
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.detectLanguageAndCheckAgainstDeclaredLanguage();
        this.contentHandler.endDocument();
    }

    private void detectLanguageAndCheckAgainstDeclaredLanguage() throws SAXException {
        if (this.nonWhitespaceCharacterCount < 1024) {
            return;
        }
        if ("zxx".equals(this.declaredLangCode) || "eo".equals(this.declaredLangCode) || "la".equals(this.declaredLangCode)) {
            return;
        }
        if (LANG_TAGS_BY_TLD.containsKey(this.tld) && Arrays.binarySearch(LANG_TAGS_BY_TLD.get(this.tld), this.declaredLangCode) >= 0) {
            return;
        }
        try {
            String textContent = this.documentContent.toString().replaceAll("\\s+", " ");
            String detectedLanguage = "";
            Detector detector = DetectorFactory.create();
            detector.append(textContent);
            detector.getProbabilities();
            ArrayList<String> possibileLanguages = new ArrayList<String>();
            ArrayList<Language> possibilities = detector.getProbabilities();
            for (Language possibility : possibilities) {
                possibileLanguages.add(possibility.lang);
                ULocale plocale = new ULocale(possibility.lang);
                if (Arrays.binarySearch(COMMON_LANGS, possibility.lang) < 0 && this.systemId != null) {
                    log4j.info(String.format("%s %s %s", plocale.getDisplayName(), possibility.prob, this.systemId));
                }
                if (possibility.prob > 0.9) {
                    detectedLanguage = possibility.lang;
                    this.setDocumentLanguage(detectedLanguage);
                    continue;
                }
                if ((!possibileLanguages.contains("hr") || !possibileLanguages.contains("sr-latn") && !possibileLanguages.contains("bs")) && (!possibileLanguages.contains("sr-latn") || !possibileLanguages.contains("hr") && !possibileLanguages.contains("bs")) && (!possibileLanguages.contains("bs") || !possibileLanguages.contains("hr") && !possibileLanguages.contains("sr-latn"))) continue;
                if (this.htmlElementHasLang || this.systemId != null) {
                    detectedLanguage = this.getDetectedLanguageSerboCroatian();
                    this.setDocumentLanguage(detectedLanguage);
                }
                if (!"sh".equals(detectedLanguage)) continue;
                this.checkLangAttributeSerboCroatian();
                return;
            }
            if ("".equals(detectedLanguage)) {
                if (!this.htmlElementHasLang && this.errorHandler != null) {
                    String message = "Consider adding a \u201clang\u201d attribute to the \u201chtml\u201d start tag to declare the language of this document.";
                    SAXParseException spe = new SAXParseException(message, this.htmlStartTagLocator);
                    this.errorHandler.warning(spe);
                }
                this.contentHandler.endDocument();
                return;
            }
            String detectedLanguageName = "";
            String preferredLanguageCode = "";
            ULocale locale = new ULocale(detectedLanguage);
            String detectedLanguageCode = locale.getLanguage();
            if ("no".equals(detectedLanguage)) {
                this.checkLangAttributeNorwegian();
                this.checkContentLanguageHeaderNorwegian(detectedLanguage, detectedLanguageName, detectedLanguageCode);
                return;
            }
            if ("zh-hans".equals(detectedLanguage)) {
                detectedLanguageName = "Simplified Chinese";
                preferredLanguageCode = "zh-hans";
            } else if ("zh-hant".equals(detectedLanguage)) {
                detectedLanguageName = "Traditional Chinese";
                preferredLanguageCode = "zh-hant";
            } else if ("mhr".equals(detectedLanguage)) {
                detectedLanguageName = "Meadow Mari";
                preferredLanguageCode = "mhr";
            } else if ("mrj".equals(detectedLanguage)) {
                detectedLanguageName = "Hill Mari";
                preferredLanguageCode = "mrj";
            } else if ("nah".equals(detectedLanguage)) {
                detectedLanguageName = "Nahuatl";
                preferredLanguageCode = "nah";
            } else if ("pnb".equals(detectedLanguage)) {
                detectedLanguageName = "Western Panjabi";
                preferredLanguageCode = "pnb";
            } else if ("sr-cyrl".equals(detectedLanguage)) {
                detectedLanguageName = "Serbian";
                preferredLanguageCode = "sr";
            } else if ("sr-latn".equals(detectedLanguage)) {
                detectedLanguageName = "Serbian";
                preferredLanguageCode = "sr";
            } else if ("uz-cyrl".equals(detectedLanguage)) {
                detectedLanguageName = "Uzbek";
                preferredLanguageCode = "uz";
            } else if ("uz-latn".equals(detectedLanguage)) {
                detectedLanguageName = "Uzbek";
                preferredLanguageCode = "uz";
            } else if ("zxx".equals(detectedLanguage)) {
                detectedLanguageName = "Lorem ipsum text";
                preferredLanguageCode = "zxx";
            } else {
                detectedLanguageName = locale.getDisplayName();
                preferredLanguageCode = detectedLanguageCode;
            }
            this.checkLangAttribute(detectedLanguage, detectedLanguageName, detectedLanguageCode, preferredLanguageCode);
            this.checkDirAttribute(detectedLanguage, detectedLanguageName, detectedLanguageCode, preferredLanguageCode);
            this.checkContentLanguageHeader(detectedLanguage, detectedLanguageName, detectedLanguageCode, preferredLanguageCode);
        }
        catch (LangDetectException langDetectException) {
            // empty catch block
        }
    }

    private void setDocumentLanguage(String languageTag) {
        if (this.request != null) {
            this.request.setAttribute("http://validator.nu/properties/document-language", languageTag);
        }
    }

    private String getDetectedLanguageSerboCroatian() throws SAXException {
        if ("hr".equals(this.declaredLangCode) || "hr".equals(this.tld)) {
            return "hr";
        }
        if ("sr".equals(this.declaredLangCode) || ".rs".equals(this.tld)) {
            return "sr-latn";
        }
        if ("bs".equals(this.declaredLangCode) || ".ba".equals(this.tld)) {
            return "bs";
        }
        return "sh";
    }

    private void checkLangAttributeSerboCroatian() throws SAXException {
        String lowerCaseLang = this.htmlElementLangAttrValue.toLowerCase();
        String langWarning = "";
        if (!this.htmlElementHasLang) {
            langWarning = "This document appears to be written in either Croatian, Serbian, or Bosnian. Consider adding either \u201clang=\"hr\"\u201d, \u201clang=\"sr\"\u201d, or \u201clang=\"bs\"\u201d to the \u201chtml\u201d start tag.";
        } else if (!("hr".equals(this.declaredLangCode) || "sr".equals(this.declaredLangCode) || "bs".equals(this.declaredLangCode))) {
            langWarning = String.format("This document appears to be written in either Croatian, Serbian, or Bosnian, but the \u201chtml\u201d start tag has %s. Consider using either \u201clang=\"hr\"\u201d, \u201clang=\"sr\"\u201d, or \u201clang=\"bs\"\u201d instead.", this.getAttValueExpr("lang", lowerCaseLang));
        }
        if (!"".equals(langWarning)) {
            this.warn(langWarning);
        }
    }

    private void checkLangAttributeNorwegian() throws SAXException {
        String lowerCaseLang = this.htmlElementLangAttrValue.toLowerCase();
        String langWarning = "";
        if (!this.htmlElementHasLang) {
            langWarning = "This document appears to be written in Norwegian Consider adding either \u201clang=\"nn\"\u201d or \u201clang=\"nb\"\u201d (or variant) to the \u201chtml\u201d start tag.";
        } else if (!("no".equals(this.declaredLangCode) || "nn".equals(this.declaredLangCode) || "nb".equals(this.declaredLangCode))) {
            langWarning = String.format("This document appears to be written in Norwegian, but the \u201chtml\u201d start tag has %s. Consider using either \u201clang=\"nn\"\u201d or \u201clang=\"nb\"\u201d (or variant) instead.", this.getAttValueExpr("lang", lowerCaseLang));
        }
        if (!"".equals(langWarning)) {
            this.warn(langWarning);
        }
    }

    private void checkContentLanguageHeaderNorwegian(String detectedLanguage, String detectedLanguageName, String detectedLanguageCode) throws SAXException {
        if ("".equals(this.httpContentLangHeader) || this.httpContentLangHeader.contains(",")) {
            return;
        }
        String lowerCaseContentLang = this.httpContentLangHeader.toLowerCase();
        String contentLangCode = new ULocale(lowerCaseContentLang).getLanguage();
        if (!("no".equals(contentLangCode) || "nn".equals(contentLangCode) || "nb".equals(contentLangCode))) {
            this.warn("This document appears to be written in Norwegian but the value of the HTTP \u201cContent-Language\u201d header is \u201c" + lowerCaseContentLang + "\u201d. Consider" + " changing it to \u201cnn\u201d or \u201cnn\u201d" + " (or variant) instead.");
        }
    }

    private void checkLangAttribute(String detectedLanguage, String detectedLanguageName, String detectedLanguageCode, String preferredLanguageCode) throws SAXException {
        String langWarning = "";
        String lowerCaseLang = this.htmlElementLangAttrValue.toLowerCase();
        if (!this.htmlElementHasLang) {
            langWarning = String.format("This document appears to be written in %s. Consider adding \u201clang=\"%s\"\u201d (or variant) to the \u201chtml\u201d start tag.", detectedLanguageName, preferredLanguageCode);
        } else {
            if (this.request != null) {
                if ("".equals(lowerCaseLang)) {
                    this.request.setAttribute("http://validator.nu/properties/lang-empty", true);
                } else {
                    this.request.setAttribute("http://validator.nu/properties/lang-value", lowerCaseLang);
                }
            }
            if ("tl".equals(detectedLanguageCode) && ("ceb".equals(this.declaredLangCode) || "ilo".equals(this.declaredLangCode) || "pag".equals(this.declaredLangCode) || "war".equals(this.declaredLangCode))) {
                return;
            }
            if ("id".equals(detectedLanguageCode) && "min".equals(this.declaredLangCode)) {
                return;
            }
            if ("ms".equals(detectedLanguageCode) && "min".equals(this.declaredLangCode)) {
                return;
            }
            if ("hr".equals(detectedLanguageCode) && ("sr".equals(this.declaredLangCode) || "bs".equals(this.declaredLangCode) || "sh".equals(this.declaredLangCode))) {
                return;
            }
            if ("sr".equals(detectedLanguageCode) && ("hr".equals(this.declaredLangCode) || "bs".equals(this.declaredLangCode) || "sh".equals(this.declaredLangCode))) {
                return;
            }
            if ("bs".equals(detectedLanguageCode) && ("hr".equals(this.declaredLangCode) || "sr".equals(this.declaredLangCode) || "sh".equals(this.declaredLangCode))) {
                return;
            }
            if ("de".equals(detectedLanguageCode) && ("bar".equals(this.declaredLangCode) || "gsw".equals(this.declaredLangCode) || "lb".equals(this.declaredLangCode))) {
                return;
            }
            if ("zh".equals(detectedLanguageCode) && "yue".equals(lowerCaseLang)) {
                return;
            }
            if ("es".equals(detectedLanguageCode) && ("an".equals(this.declaredLangCode) || "ast".equals(this.declaredLangCode))) {
                return;
            }
            if ("it".equals(detectedLanguageCode) && ("co".equals(this.declaredLangCode) || "pms".equals(this.declaredLangCode) || "vec".equals(this.declaredLangCode) || "lmo".equals(this.declaredLangCode) || "scn".equals(this.declaredLangCode) || "nap".equals(this.declaredLangCode))) {
                return;
            }
            if ("rw".equals(detectedLanguageCode) && "rn".equals(this.declaredLangCode)) {
                return;
            }
            if ("mhr".equals(detectedLanguageCode) && ("chm".equals(this.declaredLangCode) || "mrj".equals(this.declaredLangCode))) {
                return;
            }
            if ("mrj".equals(detectedLanguageCode) && ("chm".equals(this.declaredLangCode) || "mhr".equals(this.declaredLangCode))) {
                return;
            }
            if ("ru".equals(detectedLanguageCode) && "bg".equals(this.declaredLangCode)) {
                return;
            }
            String message = "This document appears to be written in %s but the \u201chtml\u201d start tag has %s. Consider using \u201clang=\"%s\"\u201d (or variant) instead.";
            if (this.zhSubtagMismatch(detectedLanguage, lowerCaseLang) || !this.declaredLangCode.equals(detectedLanguageCode)) {
                if (this.request != null) {
                    this.request.setAttribute("http://validator.nu/properties/lang-wrong", true);
                }
                langWarning = String.format(message, detectedLanguageName, this.getAttValueExpr("lang", this.htmlElementLangAttrValue), preferredLanguageCode);
            }
        }
        if (!"".equals(langWarning)) {
            this.warn(langWarning);
        }
    }

    private void checkContentLanguageHeader(String detectedLanguage, String detectedLanguageName, String detectedLanguageCode, String preferredLanguageCode) throws SAXException {
        if ("".equals(this.httpContentLangHeader) || this.httpContentLangHeader.contains(",")) {
            return;
        }
        String message = "";
        String lowerCaseContentLang = this.httpContentLangHeader.toLowerCase();
        String contentLangCode = new ULocale(lowerCaseContentLang).getLanguage();
        if ("tl".equals(detectedLanguageCode) && ("ceb".equals(contentLangCode) || "ilo".equals(contentLangCode) || "pag".equals(contentLangCode) || "war".equals(contentLangCode))) {
            return;
        }
        if ("id".equals(detectedLanguageCode) && "min".equals(contentLangCode)) {
            return;
        }
        if ("ms".equals(detectedLanguageCode) && "min".equals(contentLangCode)) {
            return;
        }
        if ("hr".equals(detectedLanguageCode) && ("sr".equals(contentLangCode) || "bs".equals(contentLangCode) || "sh".equals(contentLangCode))) {
            return;
        }
        if ("sr".equals(detectedLanguageCode) && ("hr".equals(contentLangCode) || "bs".equals(contentLangCode) || "sh".equals(contentLangCode))) {
            return;
        }
        if ("bs".equals(detectedLanguageCode) && ("hr".equals(contentLangCode) || "sr".equals(contentLangCode) || "sh".equals(contentLangCode))) {
            return;
        }
        if ("de".equals(detectedLanguageCode) && ("bar".equals(contentLangCode) || "gsw".equals(contentLangCode) || "lb".equals(contentLangCode))) {
            return;
        }
        if ("zh".equals(detectedLanguageCode) && "yue".equals(lowerCaseContentLang)) {
            return;
        }
        if ("es".equals(detectedLanguageCode) && ("an".equals(contentLangCode) || "ast".equals(contentLangCode))) {
            return;
        }
        if ("it".equals(detectedLanguageCode) && ("co".equals(contentLangCode) || "pms".equals(contentLangCode) || "vec".equals(contentLangCode) || "lmo".equals(contentLangCode) || "scn".equals(contentLangCode) || "nap".equals(contentLangCode))) {
            return;
        }
        if ("rw".equals(detectedLanguageCode) && "rn".equals(contentLangCode)) {
            return;
        }
        if ("mhr".equals(detectedLanguageCode) && ("chm".equals(contentLangCode) || "mrj".equals(contentLangCode))) {
            return;
        }
        if ("mrj".equals(detectedLanguageCode) && ("chm".equals(contentLangCode) || "mhr".equals(contentLangCode))) {
            return;
        }
        if ("ru".equals(detectedLanguageCode) && "bg".equals(contentLangCode)) {
            return;
        }
        if (this.zhSubtagMismatch(detectedLanguage, lowerCaseContentLang) || !contentLangCode.equals(detectedLanguageCode)) {
            message = "This document appears to be written in %s but the value of the HTTP \u201cContent-Language\u201d header is \u201c%s\u201d. Consider changing it to \u201c%s\u201d (or variant).";
            String warning = String.format(message, detectedLanguageName, lowerCaseContentLang, preferredLanguageCode, preferredLanguageCode);
            if (this.errorHandler != null) {
                SAXParseException spe = new SAXParseException(warning, null);
                this.errorHandler.warning(spe);
            }
        }
        if (this.htmlElementHasLang) {
            message = "The value of the HTTP \u201cContent-Language\u201d header is \u201c%s\u201d but it will be ignored because the \u201chtml\u201d start tag has %s.";
            String lowerCaseLang = this.htmlElementLangAttrValue.toLowerCase();
            if (this.htmlElementHasLang && (this.zhSubtagMismatch(lowerCaseContentLang, lowerCaseLang) || !contentLangCode.equals(this.declaredLangCode))) {
                this.warn(String.format(message, this.httpContentLangHeader, this.getAttValueExpr("lang", this.htmlElementLangAttrValue)));
            }
        }
    }

    private void checkDirAttribute(String detectedLanguage, String detectedLanguageName, String detectedLanguageCode, String preferredLanguageCode) throws SAXException {
        if (Arrays.binarySearch(RTL_LANGS, detectedLanguageCode) < 0) {
            return;
        }
        String dirWarning = "";
        if (!this.hasDir) {
            dirWarning = String.format("This document appears to be written in %s. Consider adding \u201cdir=\"rtl\"\u201d to the \u201chtml\u201d start tag.", detectedLanguageName, preferredLanguageCode);
        } else if (!"rtl".equals(this.dirAttrValue)) {
            String message = "This document appears to be written in %s but the \u201chtml\u201d start tag has %s. Consider using \u201cdir=\"rtl\"\u201d instead.";
            dirWarning = String.format(message, detectedLanguageName, this.getAttValueExpr("dir", this.dirAttrValue));
        }
        if (!"".equals(dirWarning)) {
            this.warn(dirWarning);
        }
    }

    private boolean zhSubtagMismatch(String expectedLanguage, String declaredLanguage) {
        return "zh-hans".equals(expectedLanguage) && (declaredLanguage.contains("zh-tw") || declaredLanguage.contains("zh-hant")) || "zh-hant".equals(expectedLanguage) && (declaredLanguage.contains("zh-cn") || declaredLanguage.contains("zh-hans"));
    }

    private String getAttValueExpr(String attName, String attValue) {
        if ("".equals(attValue)) {
            return String.format("an empty \u201c%s\u201d attribute", attName);
        }
        return String.format("\u201c%s=\"%s\"\u201d", attName, attValue);
    }

    private void warn(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this.htmlStartTagLocator);
            this.errorHandler.warning(spe);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.wrappedReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.wrappedReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getProperty(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.wrappedReader.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.wrappedReader.parse(systemId);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.wrappedReader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.wrappedReader.setEntityResolver(resolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.wrappedReader.setErrorHandler(handler);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setFeature(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setProperty(name, value);
    }

    static {
        LANG_TAGS_BY_TLD.put("ae", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("af", new String[]{"ps"});
        LANG_TAGS_BY_TLD.put("am", new String[]{"hy"});
        LANG_TAGS_BY_TLD.put("ar", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("at", new String[]{"de"});
        LANG_TAGS_BY_TLD.put("az", new String[]{"az"});
        LANG_TAGS_BY_TLD.put("ba", new String[]{"bs", "hr", "sr"});
        LANG_TAGS_BY_TLD.put("bd", new String[]{"bn"});
        LANG_TAGS_BY_TLD.put("be", new String[]{"de", "fr", "nl"});
        LANG_TAGS_BY_TLD.put("bg", new String[]{"bg"});
        LANG_TAGS_BY_TLD.put("bh", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("bo", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("br", new String[]{"pt"});
        LANG_TAGS_BY_TLD.put("by", new String[]{"be"});
        LANG_TAGS_BY_TLD.put("bz", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("ch", new String[]{"de", "fr", "it", "rm"});
        LANG_TAGS_BY_TLD.put("cl", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("co", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("cu", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("cr", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("cz", new String[]{"cs"});
        LANG_TAGS_BY_TLD.put("de", new String[]{"de"});
        LANG_TAGS_BY_TLD.put("dk", new String[]{"da"});
        LANG_TAGS_BY_TLD.put("do", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("ec", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("ee", new String[]{"et"});
        LANG_TAGS_BY_TLD.put("eg", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("es", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("fi", new String[]{"fi"});
        LANG_TAGS_BY_TLD.put("fr", new String[]{"fr"});
        LANG_TAGS_BY_TLD.put("ge", new String[]{"ka"});
        LANG_TAGS_BY_TLD.put("gr", new String[]{"el"});
        LANG_TAGS_BY_TLD.put("gt", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("hn", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("hr", new String[]{"hr"});
        LANG_TAGS_BY_TLD.put("hu", new String[]{"hu"});
        LANG_TAGS_BY_TLD.put("id", new String[]{"id"});
        LANG_TAGS_BY_TLD.put("is", new String[]{"is"});
        LANG_TAGS_BY_TLD.put("it", new String[]{"it"});
        LANG_TAGS_BY_TLD.put("il", new String[]{"iw"});
        LANG_TAGS_BY_TLD.put("in", new String[]{"bn", "gu", "hi", "kn", "ml", "mr", "pa", "ta", "te"});
        LANG_TAGS_BY_TLD.put("ja", new String[]{"jp"});
        LANG_TAGS_BY_TLD.put("jo", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("ke", new String[]{"sw"});
        LANG_TAGS_BY_TLD.put("kg", new String[]{"ky"});
        LANG_TAGS_BY_TLD.put("kh", new String[]{"km"});
        LANG_TAGS_BY_TLD.put("kr", new String[]{"ko"});
        LANG_TAGS_BY_TLD.put("kw", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("kz", new String[]{"kk"});
        LANG_TAGS_BY_TLD.put("la", new String[]{"lo"});
        LANG_TAGS_BY_TLD.put("li", new String[]{"de"});
        LANG_TAGS_BY_TLD.put("lb", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("lk", new String[]{"si", "ta"});
        LANG_TAGS_BY_TLD.put("lt", new String[]{"lt"});
        LANG_TAGS_BY_TLD.put("lu", new String[]{"de"});
        LANG_TAGS_BY_TLD.put("lv", new String[]{"lv"});
        LANG_TAGS_BY_TLD.put("md", new String[]{"mo"});
        LANG_TAGS_BY_TLD.put("mk", new String[]{"mk"});
        LANG_TAGS_BY_TLD.put("mn", new String[]{"mn"});
        LANG_TAGS_BY_TLD.put("mx", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("my", new String[]{"ms"});
        LANG_TAGS_BY_TLD.put("ni", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("nl", new String[]{"nl"});
        LANG_TAGS_BY_TLD.put("no", new String[]{"nn", "no"});
        LANG_TAGS_BY_TLD.put("np", new String[]{"ne"});
        LANG_TAGS_BY_TLD.put("pa", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("pe", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("ph", new String[]{"tl"});
        LANG_TAGS_BY_TLD.put("pl", new String[]{"pl"});
        LANG_TAGS_BY_TLD.put("pk", new String[]{"ur"});
        LANG_TAGS_BY_TLD.put("pr", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("pt", new String[]{"pt"});
        LANG_TAGS_BY_TLD.put("py", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("qa", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("ro", new String[]{"ro"});
        LANG_TAGS_BY_TLD.put("rs", new String[]{"sr"});
        LANG_TAGS_BY_TLD.put("ru", new String[]{"ru"});
        LANG_TAGS_BY_TLD.put("sa", new String[]{"ar"});
        LANG_TAGS_BY_TLD.put("se", new String[]{"sv"});
        LANG_TAGS_BY_TLD.put("si", new String[]{"sl"});
        LANG_TAGS_BY_TLD.put("sk", new String[]{"sk"});
        LANG_TAGS_BY_TLD.put("sv", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("th", new String[]{"th"});
        LANG_TAGS_BY_TLD.put("tj", new String[]{"tg"});
        LANG_TAGS_BY_TLD.put("tm", new String[]{"tk"});
        LANG_TAGS_BY_TLD.put("ua", new String[]{"uk"});
        LANG_TAGS_BY_TLD.put("uy", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("uz", new String[]{"uz"});
        LANG_TAGS_BY_TLD.put("ve", new String[]{"es"});
        LANG_TAGS_BY_TLD.put("vn", new String[]{"vi"});
        LANG_TAGS_BY_TLD.put("za", new String[]{"af"});
        RTL_LANGS = new String[]{"ar", "azb", "ckb", "dv", "fa", "he", "pnb", "ps", "sd", "ug", "ur"};
        COMMON_LANGS = new String[]{"ar", "ca", "cs", "da", "de", "el", "en", "es", "et", "fa", "fi", "fr", "he", "hi", "hu", "id", "it", "ja", "ka", "ko", "lt", "lv", "ms", "nl", "no", "pl", "pt", "ro", "ru", "sk", "sq", "sv", "th", "tr", "uk", "vi", "zh-hans", "zh-hant"};
    }
}

