/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.dom;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nu.validator.htmlparser.common.CharacterHandler;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.TransitionHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.dom.DOMTreeBuilder;
import nu.validator.htmlparser.impl.ErrorReportingTokenizer;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.io.Driver;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HtmlDocumentBuilder
extends DocumentBuilder {
    private Driver driver;
    private final DOMTreeBuilder treeBuilder;
    private final DOMImplementation implementation;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = null;
    private DocumentModeHandler documentModeHandler = null;
    private DoctypeExpectation doctypeExpectation = DoctypeExpectation.HTML;
    private boolean checkingNormalization = false;
    private boolean scriptingEnabled = false;
    private final List<CharacterHandler> characterHandlers = new LinkedList<CharacterHandler>();
    private XmlViolationPolicy contentSpacePolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy contentNonXmlCharPolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy commentPolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy streamabilityViolationPolicy = XmlViolationPolicy.ALLOW;
    private boolean html4ModeCompatibleWithXhtml1Schemata = false;
    private boolean mappingLangToXmlLang = false;
    private XmlViolationPolicy xmlnsPolicy = XmlViolationPolicy.FATAL;
    private boolean reportingDoctype = true;
    private ErrorHandler treeBuilderErrorHandler = null;
    private Heuristics heuristics = Heuristics.NONE;
    private TransitionHandler transitionHandler = null;

    private static DOMImplementation jaxpDOMImplementation() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return builder.getDOMImplementation();
    }

    public HtmlDocumentBuilder(DOMImplementation implementation, XmlViolationPolicy xmlPolicy) {
        this.implementation = implementation;
        this.treeBuilder = new DOMTreeBuilder(implementation);
        this.driver = null;
        this.setXmlPolicy(xmlPolicy);
    }

    public HtmlDocumentBuilder(DOMImplementation implementation) {
        this(implementation, XmlViolationPolicy.ALTER_INFOSET);
    }

    public HtmlDocumentBuilder() {
        this(XmlViolationPolicy.ALTER_INFOSET);
    }

    public HtmlDocumentBuilder(XmlViolationPolicy xmlPolicy) {
        this(HtmlDocumentBuilder.jaxpDOMImplementation(), xmlPolicy);
    }

    private Tokenizer newTokenizer(TokenHandler handler, boolean newAttributesEachTime) {
        if (this.errorHandler == null && this.transitionHandler == null && this.contentNonXmlCharPolicy == XmlViolationPolicy.ALLOW) {
            return new Tokenizer(handler, newAttributesEachTime);
        }
        return new ErrorReportingTokenizer(handler, newAttributesEachTime);
    }

    private void lazyInit() {
        if (this.driver == null) {
            this.driver = new Driver(this.newTokenizer(this.treeBuilder, false));
            this.driver.setErrorHandler(this.errorHandler);
            this.driver.setTransitionHandler(this.transitionHandler);
            this.treeBuilder.setErrorHandler(this.treeBuilderErrorHandler);
            this.driver.setCheckingNormalization(this.checkingNormalization);
            this.driver.setCommentPolicy(this.commentPolicy);
            this.driver.setContentNonXmlCharPolicy(this.contentNonXmlCharPolicy);
            this.driver.setContentSpacePolicy(this.contentSpacePolicy);
            this.driver.setHtml4ModeCompatibleWithXhtml1Schemata(this.html4ModeCompatibleWithXhtml1Schemata);
            this.driver.setMappingLangToXmlLang(this.mappingLangToXmlLang);
            this.driver.setXmlnsPolicy(this.xmlnsPolicy);
            this.driver.setHeuristics(this.heuristics);
            for (CharacterHandler characterHandler : this.characterHandlers) {
                this.driver.addCharacterHandler(characterHandler);
            }
            this.treeBuilder.setDoctypeExpectation(this.doctypeExpectation);
            this.treeBuilder.setDocumentModeHandler(this.documentModeHandler);
            this.treeBuilder.setScriptingEnabled(this.scriptingEnabled);
            this.treeBuilder.setReportingDoctype(this.reportingDoctype);
            this.treeBuilder.setNamePolicy(this.namePolicy);
        }
    }

    private void tokenize(InputSource is) throws SAXException, IOException, MalformedURLException {
        if (is == null) {
            throw new IllegalArgumentException("Null input.");
        }
        if (is.getByteStream() == null && is.getCharacterStream() == null) {
            String systemId = is.getSystemId();
            if (systemId == null) {
                throw new IllegalArgumentException("No byte stream, no character stream nor URI.");
            }
            if (this.entityResolver != null) {
                is = this.entityResolver.resolveEntity(is.getPublicId(), systemId);
            }
            if (is.getByteStream() == null || is.getCharacterStream() == null) {
                is = new InputSource();
                is.setSystemId(systemId);
                is.setByteStream(new URL(systemId).openStream());
            }
        }
        if (this.driver == null) {
            this.lazyInit();
        }
        this.driver.tokenize(is);
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.implementation;
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public Document newDocument() {
        return this.implementation.createDocument(null, null, null);
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        this.treeBuilder.setFragmentContext(null);
        this.tokenize(is);
        return this.treeBuilder.getDocument();
    }

    public DocumentFragment parseFragment(InputSource is, String context) throws IOException, SAXException {
        this.treeBuilder.setFragmentContext(context.intern());
        this.tokenize(is);
        return this.treeBuilder.getDocumentFragment();
    }

    public DocumentFragment parseFragment(InputSource is, String contextLocal, String contextNamespace) throws IOException, SAXException {
        this.treeBuilder.setFragmentContext(contextLocal.intern(), contextNamespace.intern(), null, false);
        this.tokenize(is);
        return this.treeBuilder.getDocumentFragment();
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.treeBuilder.setErrorHandler(errorHandler);
        if (this.driver != null) {
            this.driver.setErrorHandler(errorHandler);
        }
    }

    public void setTransitionHander(TransitionHandler handler) {
        this.transitionHandler = handler;
        this.driver = null;
    }

    public boolean isCheckingNormalization() {
        return this.checkingNormalization;
    }

    public void setCheckingNormalization(boolean enable) {
        this.checkingNormalization = enable;
        if (this.driver != null) {
            this.driver.setCheckingNormalization(this.checkingNormalization);
        }
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.commentPolicy = commentPolicy;
        if (this.driver != null) {
            this.driver.setCommentPolicy(commentPolicy);
        }
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.contentNonXmlCharPolicy = contentNonXmlCharPolicy;
        this.driver = null;
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.contentSpacePolicy = contentSpacePolicy;
        if (this.driver != null) {
            this.driver.setContentSpacePolicy(contentSpacePolicy);
        }
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
        if (this.treeBuilder != null) {
            this.treeBuilder.setScriptingEnabled(scriptingEnabled);
        }
    }

    public DoctypeExpectation getDoctypeExpectation() {
        return this.doctypeExpectation;
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.doctypeExpectation = doctypeExpectation;
        if (this.treeBuilder != null) {
            this.treeBuilder.setDoctypeExpectation(doctypeExpectation);
        }
    }

    public DocumentModeHandler getDocumentModeHandler() {
        return this.documentModeHandler;
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.documentModeHandler = documentModeHandler;
    }

    public XmlViolationPolicy getStreamabilityViolationPolicy() {
        return this.streamabilityViolationPolicy;
    }

    public void setStreamabilityViolationPolicy(XmlViolationPolicy streamabilityViolationPolicy) {
        this.streamabilityViolationPolicy = streamabilityViolationPolicy;
        this.driver = null;
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.html4ModeCompatibleWithXhtml1Schemata = html4ModeCompatibleWithXhtml1Schemata;
        if (this.driver != null) {
            this.driver.setHtml4ModeCompatibleWithXhtml1Schemata(html4ModeCompatibleWithXhtml1Schemata);
        }
    }

    public Locator getDocumentLocator() {
        return this.driver.getDocumentLocator();
    }

    public boolean isHtml4ModeCompatibleWithXhtml1Schemata() {
        return this.html4ModeCompatibleWithXhtml1Schemata;
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.mappingLangToXmlLang = mappingLangToXmlLang;
        if (this.driver != null) {
            this.driver.setMappingLangToXmlLang(mappingLangToXmlLang);
        }
    }

    public boolean isMappingLangToXmlLang() {
        return this.mappingLangToXmlLang;
    }

    public void setXmlnsPolicy(XmlViolationPolicy xmlnsPolicy) {
        if (xmlnsPolicy == XmlViolationPolicy.FATAL) {
            throw new IllegalArgumentException("Can't use FATAL here.");
        }
        this.xmlnsPolicy = xmlnsPolicy;
        if (this.driver != null) {
            this.driver.setXmlnsPolicy(xmlnsPolicy);
        }
    }

    public XmlViolationPolicy getXmlnsPolicy() {
        return this.xmlnsPolicy;
    }

    public XmlViolationPolicy getCommentPolicy() {
        return this.commentPolicy;
    }

    public XmlViolationPolicy getContentNonXmlCharPolicy() {
        return this.contentNonXmlCharPolicy;
    }

    public XmlViolationPolicy getContentSpacePolicy() {
        return this.contentSpacePolicy;
    }

    public void setReportingDoctype(boolean reportingDoctype) {
        this.reportingDoctype = reportingDoctype;
        if (this.treeBuilder != null) {
            this.treeBuilder.setReportingDoctype(reportingDoctype);
        }
    }

    public boolean isReportingDoctype() {
        return this.reportingDoctype;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
        if (this.driver != null) {
            this.driver.setNamePolicy(namePolicy);
            this.treeBuilder.setNamePolicy(namePolicy);
        }
    }

    public void setHeuristics(Heuristics heuristics) {
        this.heuristics = heuristics;
        if (this.driver != null) {
            this.driver.setHeuristics(heuristics);
        }
    }

    public Heuristics getHeuristics() {
        return this.heuristics;
    }

    public void setXmlPolicy(XmlViolationPolicy xmlPolicy) {
        this.setNamePolicy(xmlPolicy);
        this.setXmlnsPolicy(xmlPolicy == XmlViolationPolicy.FATAL ? XmlViolationPolicy.ALTER_INFOSET : xmlPolicy);
        this.setContentSpacePolicy(xmlPolicy);
        this.setContentNonXmlCharPolicy(xmlPolicy);
        this.setCommentPolicy(xmlPolicy);
    }

    public XmlViolationPolicy getNamePolicy() {
        return this.namePolicy;
    }

    public void setBogusXmlnsPolicy(XmlViolationPolicy bogusXmlnsPolicy) {
    }

    public XmlViolationPolicy getBogusXmlnsPolicy() {
        return XmlViolationPolicy.ALTER_INFOSET;
    }

    public void addCharacterHandler(CharacterHandler characterHandler) {
        this.characterHandlers.add(characterHandler);
        if (this.driver != null) {
            this.driver.addCharacterHandler(characterHandler);
        }
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.treeBuilder.setIgnoringComments(ignoreComments);
    }
}

