/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.ArrayList;
import java.util.HashSet;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

abstract class AbstractAutocompleteDetails
extends AbstractDatatype {
    private static final HashSet<String> contactTypes = new HashSet();
    private static final HashSet<String> allFieldnames = new HashSet();
    private static final HashSet<String> allowedFieldnames = new HashSet();
    private static final HashSet<String> allowedContactFieldnames = new HashSet();

    AbstractAutocompleteDetails() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        if (literal.length() == 0) {
            throw this.newDatatypeException("Must not be empty.");
        }
        StringBuilder builder = new StringBuilder();
        ArrayList<String> detailTokens = new ArrayList<String>();
        int len = literal.length();
        for (int i = 0; i < len; ++i) {
            char c = literal.charAt(i);
            if (this.isWhitespace(c) && builder.length() > 0) {
                detailTokens.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (this.isWhitespace(c)) continue;
            builder.append(AbstractAutocompleteDetails.toAsciiLowerCase(c));
        }
        if (builder.length() > 0) {
            detailTokens.add(builder.toString());
        }
        if (detailTokens.size() > 0) {
            this.checkTokens(detailTokens);
        }
    }

    private void checkTokens(ArrayList<String> detailTokens) throws DatatypeException {
        boolean isContactDetails = false;
        String contactType = "";
        String firstRemainingToken = "";
        if (contactTypes.contains(detailTokens.get(0))) {
            isContactDetails = true;
            contactType = detailTokens.get(0);
            detailTokens.remove(0);
        }
        if (detailTokens.size() > 0 && detailTokens.get(0).startsWith("section-")) {
            if (isContactDetails) {
                throw this.newDatatypeException("A \u201csection-*\u201d indicator is not allowed when the first token in a list of autofill detail tokens is \u201c" + contactType + "\u201d.");
            }
            detailTokens.remove(0);
        }
        if (detailTokens.size() < 1) {
            return;
        }
        firstRemainingToken = detailTokens.get(0);
        if (firstRemainingToken.equals("shipping") || firstRemainingToken.equals("billing")) {
            if (isContactDetails) {
                throw this.newDatatypeException("The token \u201c" + firstRemainingToken + "\u201d is" + " not allowed when the first token in a list" + " of autofill detail tokens is" + " \u201c" + contactType + "\u201d.");
            }
            detailTokens.remove(0);
        }
        for (String token : detailTokens) {
            if (contactTypes.contains(token)) {
                throw this.newDatatypeException("The token \u201c" + token + "\u201d must only" + " appear as the first token in a list" + " of autofill detail tokens.");
            }
            if (token.startsWith("section-")) {
                throw this.newDatatypeException("A \u201csection-*\u201d indicator must only appear as the first token in a list of autofill detail tokens.");
            }
            if ("shipping".equals(token) || "billing".equals(token)) {
                throw this.newDatatypeException("The token \u201c" + token + "\u201d must only" + " appear as either the first token in a list" + " of autofill detail tokens, or, if the first" + " token is a \u201csection-*\u201d indicator," + " as the second token.");
            }
            if (!allFieldnames.contains(token)) {
                throw this.newDatatypeException("The string \u201c" + token + "\u201d is not a valid autofill field name.");
            }
            if (isContactDetails && !this.getAllowedContactFieldnames().contains(token)) {
                throw this.newDatatypeException("The autofill field name \u201c" + token + "\u201d is not allowed in this context.");
            }
            if (this.getAllowedFieldnames().contains(token)) continue;
            throw this.newDatatypeException("The autofill field name \u201c" + token + "\u201d is not allowed in this context.");
        }
        if (detailTokens.size() > 1) {
            throw this.newDatatypeException("A list of autofill details tokens must not contain more than one autofill field name.");
        }
    }

    public HashSet<String> getAllowedFieldnames() {
        return allowedFieldnames;
    }

    public HashSet<String> getAllowedContactFieldnames() {
        return allowedContactFieldnames;
    }

    static {
        contactTypes.add("home");
        contactTypes.add("work");
        contactTypes.add("mobile");
        contactTypes.add("fax");
        contactTypes.add("pager");
        allFieldnames.add("name");
        allFieldnames.add("honorific-prefix");
        allFieldnames.add("given-name");
        allFieldnames.add("additional-name");
        allFieldnames.add("family-name");
        allFieldnames.add("honorific-suffix");
        allFieldnames.add("nickname");
        allFieldnames.add("organization-title");
        allFieldnames.add("username");
        allFieldnames.add("new-password");
        allFieldnames.add("current-password");
        allFieldnames.add("organization");
        allFieldnames.add("street-address");
        allFieldnames.add("address-line1");
        allFieldnames.add("address-line2");
        allFieldnames.add("address-line3");
        allFieldnames.add("address-level4");
        allFieldnames.add("address-level3");
        allFieldnames.add("address-level2");
        allFieldnames.add("address-level1");
        allFieldnames.add("country");
        allFieldnames.add("country-name");
        allFieldnames.add("postal-code");
        allFieldnames.add("cc-name");
        allFieldnames.add("cc-given-name");
        allFieldnames.add("cc-additional-name");
        allFieldnames.add("cc-family-name");
        allFieldnames.add("cc-number");
        allFieldnames.add("cc-exp");
        allFieldnames.add("cc-exp-month");
        allFieldnames.add("cc-exp-year");
        allFieldnames.add("cc-csc");
        allFieldnames.add("cc-type");
        allFieldnames.add("transaction-currency");
        allFieldnames.add("transaction-amount");
        allFieldnames.add("language");
        allFieldnames.add("bday");
        allFieldnames.add("bday-day");
        allFieldnames.add("bday-month");
        allFieldnames.add("bday-year");
        allFieldnames.add("sex");
        allFieldnames.add("url");
        allFieldnames.add("photo");
        allFieldnames.add("tel");
        allFieldnames.add("tel-country-code");
        allFieldnames.add("tel-national");
        allFieldnames.add("tel-area-code");
        allFieldnames.add("tel-local");
        allFieldnames.add("tel-local-prefix");
        allFieldnames.add("tel-local-suffix");
        allFieldnames.add("tel-extension");
        allFieldnames.add("email");
        allFieldnames.add("impp");
    }
}

