# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .signal_rupdate_parameters import SignalRUpdateParameters


class SignalRCreateParameters(SignalRUpdateParameters):
    """Parameters for SignalR service create/update operation.
    Keep the same schema as AzSignalR.Models.SignalRResource.

    All required parameters must be populated in order to send to Azure.

    :param tags: A list of key value pairs that describe the resource.
    :type tags: dict[str, str]
    :param sku: The billing information of the resource.(e.g. basic vs.
     standard)
    :type sku: ~azure.mgmt.signalr.models.ResourceSku
    :param properties: Settings used to provision or configure the resource
    :type properties:
     ~azure.mgmt.signalr.models.SignalRCreateOrUpdateProperties
    :param location: Required. Azure GEO region: e.g. West US | East US |
     North Central US | South Central US | West Europe | North Europe | East
     Asia | Southeast Asia | etc.
     The geo region of a resource never changes after it is created.
    :type location: str
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'properties': {'key': 'properties', 'type': 'SignalRCreateOrUpdateProperties'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, sku=None, properties=None, **kwargs) -> None:
        super(SignalRCreateParameters, self).__init__(tags=tags, sku=sku, properties=properties, **kwargs)
        self.location = location
