/*
  knockback.js 0.17.0 (full version)
  (c) 2011-2013 Kevin Malakoff - http://kmalakoff.github.com/knockback/
  License: MIT (http://www.opensource.org/licenses/mit-license.php)
  Dependencies: Knockout.js, Backbone.js, and Underscore.js.
*/
(function() {
  return (function(factory) {
    // AMD
    if (typeof define === 'function' && define.amd) {
      return define('knockback', ['underscore', 'backbone', 'knockout'], factory);
    }
    // CommonJS/NodeJS or No Loader
    else {
      return factory.call(this);
    }
  })(function() {// Generated by CoffeeScript 1.6.2
/*
  knockback-core.js 0.17.0
  (c) 2011-2013 Kevin Malakoff.
  Knockback.js is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
  Dependencies: Knockout.js, Backbone.js, and Underscore.js.
*/

var COMPARE_ASCENDING, COMPARE_DESCENDING, COMPARE_EQUAL, EMAIL_REGEXP, KB_TYPE_ARRAY, KB_TYPE_COLLECTION, KB_TYPE_MODEL, KB_TYPE_SIMPLE, KB_TYPE_UNKNOWN, NUMBER_REGEXP, URL_REGEXP, addStatisticsEvent, arraySlice, callOrGet, collapseOptions, copyProps, e, kb, ko, onReady, _, _argumentsAddKey, _arraySplice, _legacyWarning, _throwMissing, _throwUnexpected, _unwrapModels, _unwrapObservable, _wrappedKey,
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

kb = (function() {
  function kb() {}

  kb.VERSION = '0.17.0';

  kb.TYPE_UNKNOWN = 0;

  kb.TYPE_SIMPLE = 1;

  kb.TYPE_ARRAY = 2;

  kb.TYPE_MODEL = 3;

  kb.TYPE_COLLECTION = 4;

  kb.wasReleased = function(obj) {
    return !obj || obj.__kb_released;
  };

  kb.release = function(obj, pre_release_fn) {
    var array, item, view_model, view_models, _i, _j, _len, _len1;

    if ((!obj || (obj !== Object(obj))) || ((typeof obj === 'function') && !ko.isObservable(obj)) || obj.__kb_released || ((obj instanceof kb.Model) || (obj instanceof kb.Collection))) {
      return this;
    }
    if (_.isArray(obj)) {
      array = obj.splice(0, obj.length);
      for (_i = 0, _len = array.length; _i < _len; _i++) {
        item = array[_i];
        kb.release(item);
      }
      return this;
    }
    obj.__kb_released = true;
    !pre_release_fn || pre_release_fn();
    if (ko.isObservable(obj) || (typeof obj.dispose === 'function') || (typeof obj.destroy === 'function') || (typeof obj.release === 'function')) {
      if (ko.isObservable(obj) && _.isArray(array = obj())) {
        if (obj.__kb_is_co || (obj.__kb_is_o && (obj.valueType() === KB_TYPE_COLLECTION))) {
          if (obj.destroy) {
            obj.destroy();
          } else if (obj.dispose) {
            obj.dispose();
          }
        } else if (array.length) {
          view_models = array.slice(0);
          array.splice(0, array.length);
          for (_j = 0, _len1 = view_models.length; _j < _len1; _j++) {
            view_model = view_models[_j];
            kb.release(view_model);
          }
        }
      } else if (obj.release) {
        obj.release();
      } else if (obj.destroy) {
        obj.destroy();
      } else if (obj.dispose) {
        obj.dispose();
      }
    } else {
      this.releaseKeys(obj);
    }
    return this;
  };

  kb.releaseKeys = function(obj) {
    var key, value;

    for (key in obj) {
      value = obj[key];
      (key === '__kb') || kb.release(value, (function() {
        return obj[key] = null;
      }));
    }
    return this;
  };

  kb.releaseOnNodeRemove = function(view_model, node) {
    view_model || _throwUnexpected(this, 'missing view model');
    node || _throwUnexpected(this, 'missing node');
    return ko.utils.domNodeDisposal.addDisposeCallback(node, function() {
      return kb.release(view_model);
    });
  };

  kb.renderTemplate = function(template, view_model, options) {
    var el, observable;

    if (options == null) {
      options = {};
    }
    el = document.createElement('div');
    observable = ko.renderTemplate(template, view_model, options, el, 'replaceChildren');
    if (el.children.length === 1) {
      el = el.children[0];
    }
    kb.releaseOnNodeRemove(view_model, el);
    observable.dispose();
    if (view_model.afterRender && !options.afterRender) {
      view_model.afterRender(el);
    }
    return el;
  };

  kb.applyBindings = function(view_model, node) {
    ko.applyBindings(view_model, node);
    return kb.releaseOnNodeRemove(view_model, node);
  };

  return kb;

})();

this.Knockback = this.kb = kb;

if (typeof exports !== 'undefined') {
  module.exports = kb;
}

if (this.Parse) {
  kb._ = _ = this.Parse._;
  kb.Parse = this.Parse;
  kb.Collection = this.Parse.Collection;
  kb.Model = this.Parse.Object;
  kb.Events = this.Parse.Events;
} else {
  if (!this._ && (typeof require !== 'undefined')) {
    try {
      _ = require('lodash');
    } catch (_error) {
      e = _error;
      _ = require('underscore');
    }
  } else {
    _ = this._;
  }
  kb._ = _ = _.hasOwnProperty('_') ? _._ : _;
  if (_.where && !_.findWhere) {
    _.mixin({
      findWhere: function(obj, attrs) {
        var result;

        result = _.where(obj, attrs);
        if (result.length) {
          return result[0];
        } else {
          return null;
        }
      }
    });
  }
  kb.Backbone = !this.Backbone && (typeof require !== 'undefined') ? require('backbone') : this.Backbone;
  kb.Collection = kb.Backbone.Collection;
  kb.Model = kb.Backbone.Model;
  kb.Events = kb.Backbone.Events;
}

kb.ko = ko = !this.ko && (typeof require !== 'undefined') ? require('knockout') : this.ko;

_throwMissing = function(instance, message) {
  throw "" + (_.isString(instance) ? instance : instance.constructor.name) + ": " + message + " is missing";
};

_throwUnexpected = function(instance, message) {
  throw "" + (_.isString(instance) ? instance : instance.constructor.name) + ": " + message + " is unexpected";
};

_legacyWarning = function(identifier, last_version, message) {
  var _base;

  this._legacy_warnings || (this._legacy_warnings = {});
  (_base = this._legacy_warnings)[identifier] || (_base[identifier] = 0);
  this._legacy_warnings[identifier]++;
  return console.warn("warning: '" + identifier + "' has been deprecated (will be removed in Knockback after " + last_version + "). " + message + ".");
};

_arraySplice = Array.prototype.splice;

_unwrapObservable = ko.utils.unwrapObservable;

collapseOptions = function(options) {
  var result;

  result = _.clone(options);
  while (options.options) {
    _.defaults(result, options.options);
    options = options.options;
  }
  delete result.options;
  return result;
};

copyProps = function(dest, source) {
  var key, value;

  for (key in source) {
    value = source[key];
    dest[key] = value;
  }
  return dest;
};

// Shared empty constructor function to aid in prototype-chain creation.
var ctor = function(){};

// Helper function to correctly set up the prototype chain, for subclasses.
// Similar to 'goog.inherits', but uses a hash of prototype properties and
// class properties to be extended.
var inherits = function(parent, protoProps, staticProps) {
  var child;

  // The constructor function for the new subclass is either defined by you
  // (the "constructor" property in your extend definition), or defaulted
  // by us to simply call the parent's constructor.
  if (protoProps && protoProps.hasOwnProperty('constructor')) {
    child = protoProps.constructor;
  } else {
    child = function(){ parent.apply(this, arguments); };
  }

  // Inherit class (static) properties from parent.
  copyProps(child, parent);

  // Set the prototype chain to inherit from parent, without calling
  // parent's constructor function.
  ctor.prototype = parent.prototype;
  child.prototype = new ctor();

  // Add prototype properties (instance properties) to the subclass,
  // if supplied.
  if (protoProps) copyProps(child.prototype, protoProps);

  // Add static properties to the constructor function, if supplied.
  if (staticProps) copyProps(child, staticProps);

  // Correctly set child's 'prototype.constructor'.
  child.prototype.constructor = child;

  // Set a convenience property in case the parent's prototype is needed later.
  child.__super__ = parent.prototype;

  return child;
};

// The self-propagating extend function that BacLCone classes use.
var extend = function (protoProps, classProps) {
  var child = inherits(this, protoProps, classProps);
  child.extend = this.extend;
  return child;
};
;

kb.extend = extend;

KB_TYPE_UNKNOWN = kb.TYPE_UNKNOWN;

KB_TYPE_SIMPLE = kb.TYPE_SIMPLE;

KB_TYPE_ARRAY = kb.TYPE_ARRAY;

KB_TYPE_MODEL = kb.TYPE_MODEL;

KB_TYPE_COLLECTION = kb.TYPE_COLLECTION;

/*
  knockback-utils.js
  (c) 2011-2013 Kevin Malakoff.
  Knockback.js is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
  Dependencies: Knockout.js, Backbone.js, and Underscore.js.
    Optional dependency: Backbone.ModelRef.js.
*/


_wrappedKey = function(obj, key, value) {
  if (arguments.length === 2) {
    if (obj && obj.__kb && obj.__kb.hasOwnProperty(key)) {
      return obj.__kb[key];
    } else {
      return void 0;
    }
  }
  obj || _throwUnexpected(this, "no obj for wrapping " + key);
  obj.__kb || (obj.__kb = {});
  obj.__kb[key] = value;
  return value;
};

_argumentsAddKey = function(args, key) {
  _arraySplice.call(args, 1, 0, key);
  return args;
};

_unwrapModels = function(obj) {
  var key, result, value;

  if (!obj) {
    return obj;
  }
  if (obj.__kb) {
    if ('object' in obj.__kb) {
      return obj.__kb.object;
    } else {
      return obj;
    }
  } else if (_.isArray(obj)) {
    return _.map(obj, function(test) {
      return _unwrapModels(test);
    });
  } else if (_.isObject(obj) && (obj.constructor === {}.constructor)) {
    result = {};
    for (key in obj) {
      value = obj[key];
      result[key] = _unwrapModels(value);
    }
    return result;
  }
  return obj;
};

kb.utils = (function() {
  function utils() {}

  utils.wrappedObservable = function(obj, value) {
    return _wrappedKey.apply(this, _argumentsAddKey(arguments, 'observable'));
  };

  utils.wrappedObject = function(obj, value) {
    return _wrappedKey.apply(this, _argumentsAddKey(arguments, 'object'));
  };

  utils.wrappedModel = function(obj, value) {
    if (arguments.length === 1) {
      value = _wrappedKey(obj, 'object');
      if (_.isUndefined(value)) {
        return obj;
      } else {
        return value;
      }
    } else {
      return _wrappedKey(obj, 'object', value);
    }
  };

  utils.wrappedStore = function(obj, value) {
    return _wrappedKey.apply(this, _argumentsAddKey(arguments, 'store'));
  };

  utils.wrappedStoreIsOwned = function(obj, value) {
    return _wrappedKey.apply(this, _argumentsAddKey(arguments, 'store_is_owned'));
  };

  utils.wrappedFactory = function(obj, value) {
    return _wrappedKey.apply(this, _argumentsAddKey(arguments, 'factory'));
  };

  utils.wrappedEventWatcher = function(obj, value) {
    return _wrappedKey.apply(this, _argumentsAddKey(arguments, 'event_watcher'));
  };

  utils.wrappedEventWatcherIsOwned = function(obj, value) {
    return _wrappedKey.apply(this, _argumentsAddKey(arguments, 'event_watcher_is_owned'));
  };

  utils.wrappedDestroy = function(obj) {
    var __kb;

    if (!obj.__kb) {
      return;
    }
    if (obj.__kb.event_watcher) {
      obj.__kb.event_watcher.releaseCallbacks(obj);
    }
    __kb = obj.__kb;
    obj.__kb = null;
    if (__kb.observable) {
      __kb.observable.destroy = __kb.observable.release = null;
      this.wrappedDestroy(__kb.observable);
      __kb.observable = null;
    }
    __kb.factory = null;
    if (__kb.event_watcher_is_owned) {
      __kb.event_watcher.destroy();
    }
    __kb.event_watcher = null;
    if (__kb.store_is_owned) {
      __kb.store.destroy();
    }
    return __kb.store = null;
  };

  utils.valueType = function(observable) {
    if (!observable) {
      return KB_TYPE_UNKNOWN;
    }
    if (observable.__kb_is_o) {
      return observable.valueType();
    }
    if (observable.__kb_is_co || (observable instanceof kb.Collection)) {
      return KB_TYPE_COLLECTION;
    }
    if ((observable instanceof kb.ViewModel) || (observable instanceof kb.Model)) {
      return KB_TYPE_MODEL;
    }
    if (_.isArray(observable)) {
      return KB_TYPE_ARRAY;
    }
    return KB_TYPE_SIMPLE;
  };

  utils.pathJoin = function(path1, path2) {
    return (path1 ? (path1[path1.length - 1] !== '.' ? "" + path1 + "." : path1) : '') + path2;
  };

  utils.optionsPathJoin = function(options, path) {
    return _.defaults({
      path: this.pathJoin(options.path, path)
    }, options);
  };

  utils.inferCreator = function(value, factory, path, owner, key) {
    var creator, relation;

    if (factory) {
      creator = factory.creatorForPath(value, path);
    }
    if (creator) {
      return creator;
    }
    if (owner && kb.Backbone && kb.Backbone.RelationalModel && (owner instanceof kb.Backbone.RelationalModel)) {
      key = _unwrapObservable(key);
      relation = _.find(owner.getRelations(), function(test) {
        return test.key === key;
      });
      if (relation) {
        if (relation.collectionType || _.isArray(relation.keyContents)) {
          return kb.CollectionObservable;
        } else {
          return kb.ViewModel;
        }
      }
    }
    if (!value) {
      return null;
    }
    if (value instanceof kb.Model) {
      return kb.ViewModel;
    }
    if (value instanceof kb.Collection) {
      return kb.CollectionObservable;
    }
    return null;
  };

  utils.createFromDefaultCreator = function(obj, options) {
    if (obj instanceof kb.Model) {
      return kb.viewModel(obj, options);
    }
    if (obj instanceof kb.Collection) {
      return kb.collectionObservable(obj, options);
    }
    if (_.isArray(obj)) {
      return ko.observableArray(obj);
    }
    return ko.observable(obj);
  };

  utils.hasModelSignature = function(obj) {
    return obj && (obj.attributes && !obj.models) && (typeof obj.get === 'function') && (typeof obj.trigger === 'function');
  };

  utils.hasCollectionSignature = function(obj) {
    return obj && obj.models && (typeof obj.get === 'function') && (typeof obj.trigger === 'function');
  };

  return utils;

})();

/*
  knockback_factory.js
  (c) 2011-2013 Kevin Malakoff.
  Knockback.Factory is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


kb.Factory = (function() {
  Factory.useOptionsOrCreate = function(options, obj, owner_path) {
    var factory;

    if (options.factory && (!options.factories || (options.factories && options.factory.hasPathMappings(options.factories, owner_path)))) {
      return kb.utils.wrappedFactory(obj, options.factory);
    }
    factory = kb.utils.wrappedFactory(obj, new kb.Factory(options.factory));
    if (options.factories) {
      factory.addPathMappings(options.factories, owner_path);
    }
    return factory;
  };

  function Factory(parent_factory) {
    this.parent_factory = parent_factory;
    this.paths = {};
  }

  Factory.prototype.hasPath = function(path) {
    return this.paths.hasOwnProperty(path) || (this.parent_factory && this.parent_factory.hasPath(path));
  };

  Factory.prototype.addPathMapping = function(path, create_info) {
    return this.paths[path] = create_info;
  };

  Factory.prototype.addPathMappings = function(factories, owner_path) {
    var create_info, path;

    for (path in factories) {
      create_info = factories[path];
      this.paths[kb.utils.pathJoin(owner_path, path)] = create_info;
    }
  };

  Factory.prototype.hasPathMappings = function(factories, owner_path) {
    var all_exist, creator, existing_creator, path;

    all_exist = true;
    for (path in factories) {
      creator = factories[path];
      all_exist &= (existing_creator = this.creatorForPath(null, kb.utils.pathJoin(owner_path, path))) && (creator === existing_creator);
    }
    return all_exist;
  };

  Factory.prototype.creatorForPath = function(obj, path) {
    var creator;

    if ((creator = this.paths[path])) {
      if (creator.view_model) {
        return creator.view_model;
      } else {
        return creator;
      }
    }
    if (this.parent_factory) {
      if ((creator = this.parent_factory.creatorForPath(obj, path))) {
        return creator;
      }
    }
    return null;
  };

  return Factory;

})();

/*
  knockback_store.js
  (c) 2012 Kevin Malakoff.
  Knockback.Store is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


kb.Store = (function() {
  Store.useOptionsOrCreate = function(options, obj, observable) {
    if (options.store) {
      options.store.register(obj, observable, options);
      return kb.utils.wrappedStore(observable, options.store);
    } else {
      kb.utils.wrappedStoreIsOwned(observable, true);
      return kb.utils.wrappedStore(observable, new kb.Store());
    }
  };

  function Store() {
    this.observable_records = [];
    this.replaced_observables = [];
  }

  Store.prototype.destroy = function() {
    return this.clear();
  };

  Store.prototype.clear = function() {
    var record, _i, _len, _ref;

    _ref = this.observable_records.splice(0, this.observable_records.length);
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      record = _ref[_i];
      kb.release(record.observable);
    }
    kb.release(this.replaced_observables);
  };

  Store.prototype.register = function(obj, observable, options) {
    var creator;

    if (!observable) {
      return;
    }
    if (ko.isObservable(observable) || observable.__kb_is_co) {
      return;
    }
    kb.utils.wrappedObject(observable, obj);
    obj || (observable.__kb_null = true);
    creator = options.creator ? options.creator : (options.path && options.factory ? options.factory.creatorForPath(obj, options.path) : null);
    if (!creator) {
      creator = observable.constructor;
    }
    this.observable_records.push({
      obj: obj,
      observable: observable,
      creator: creator
    });
    return observable;
  };

  Store.prototype.findIndex = function(obj, creator) {
    var index, record, _ref;

    if (!obj || (obj instanceof kb.Model)) {
      _ref = this.observable_records;
      for (index in _ref) {
        record = _ref[index];
        if (!record.observable) {
          continue;
        }
        if (record.observable.__kb_released) {
          record.obj = null;
          record.observable = null;
          continue;
        }
        if ((!obj && !record.observable.__kb_null) || (obj && (record.observable.__kb_null || (record.obj !== obj)))) {
          continue;
        } else if ((record.creator === creator) || (record.creator.create && (record.creator.create === creator.create))) {
          return index;
        }
      }
    }
    return -1;
  };

  Store.prototype.find = function(obj, creator) {
    var index;

    if ((index = this.findIndex(obj, creator)) < 0) {
      return null;
    } else {
      return this.observable_records[index].observable;
    }
  };

  Store.prototype.isRegistered = function(observable) {
    var record, _i, _len, _ref;

    _ref = this.observable_records;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      record = _ref[_i];
      if (record.observable === observable) {
        return true;
      }
    }
    return false;
  };

  Store.prototype.findOrCreate = function(obj, options) {
    var creator, observable;

    options.store = this;
    options.creator || (options.creator = kb.utils.inferCreator(obj, options.factory, options.path));
    if (!options.creator && (obj instanceof kb.Model)) {
      options.creator = kv.ViewModel;
    }
    creator = options.creator;
    if (!creator) {
      return kb.utils.createFromDefaultCreator(obj, options);
    } else if (creator.models_only) {
      return obj;
    }
    if (creator) {
      observable = this.find(obj, creator);
    }
    if (observable) {
      return observable;
    }
    if (creator.create) {
      observable = creator.create(obj, options);
    } else {
      observable = new creator(obj, options);
    }
    observable || (observable = ko.observable(null));
    if (!ko.isObservable(observable)) {
      this.isRegistered(observable) || this.register(obj, observable, options);
    }
    return observable;
  };

  Store.prototype.findOrReplace = function(obj, creator, observable) {
    var index, record;

    obj || _throwUnexpected(this, 'obj missing');
    if ((index = this.findIndex(obj, creator)) < 0) {
      return this.register(obj, observable, {
        creator: creator
      });
    } else {
      record = this.observable_records[index];
      (kb.utils.wrappedObject(record.observable) === obj) || _throwUnexpected(this, 'different object');
      if (record.observable !== observable) {
        (record.observable.constructor === observable.constructor) || _throwUnexpected(this, 'replacing different type');
        this.replaced_observables.push(record.observable);
        record.observable = observable;
      }
      return observable;
    }
  };

  return Store;

})();

/*
  knockback_event_watcher.js
  (c) 2011-2013 Kevin Malakoff.
  Knockback.Observable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


addStatisticsEvent = function(emitter, event_name, info) {
  return !kb.statistics || kb.statistics.addModelEvent({
    name: event_name,
    emitter: emitter,
    key: info.key,
    path: info.path
  });
};

kb.EventWatcher = (function() {
  EventWatcher.useOptionsOrCreate = function(options, emitter, obj, callback_options) {
    if (options.event_watcher) {
      if (!(options.event_watcher.emitter() === emitter || (options.event_watcher.model_ref === emitter))) {
        _throwUnexpected(this, 'emitter not matching');
      }
      return kb.utils.wrappedEventWatcher(obj, options.event_watcher).registerCallbacks(obj, callback_options);
    } else {
      kb.utils.wrappedEventWatcherIsOwned(obj, true);
      return kb.utils.wrappedEventWatcher(obj, new kb.EventWatcher(emitter)).registerCallbacks(obj, callback_options);
    }
  };

  function EventWatcher(emitter, obj, callback_options) {
    this._onModelUnloaded = __bind(this._onModelUnloaded, this);
    this._onModelLoaded = __bind(this._onModelLoaded, this);    this.__kb || (this.__kb = {});
    this.__kb.callbacks = {};
    this.__kb._onModelLoaded = _.bind(this._onModelLoaded, this);
    this.__kb._onModelUnloaded = _.bind(this._onModelUnloaded, this);
    if (callback_options) {
      this.registerCallbacks(obj, callback_options);
    }
    if (emitter) {
      this.emitter(emitter);
    } else {
      this.ee = null;
    }
  }

  EventWatcher.prototype.destroy = function() {
    this.emitter(null);
    this.__kb.callbacks = null;
    return kb.utils.wrappedDestroy(this);
  };

  EventWatcher.prototype.emitter = function(new_emitter) {
    var callbacks, event_name, info, list, previous_emitter, _i, _len, _ref;

    if ((arguments.length === 0) || (this.ee === new_emitter)) {
      return this.ee;
    }
    if (this.model_ref) {
      this.model_ref.unbind('loaded', this.__kb._onModelLoaded);
      this.model_ref.unbind('unloaded', this.__kb._onModelUnloaded);
      this.model_ref.release();
      this.model_ref = null;
    }
    if (kb.Backbone && kb.Backbone.ModelRef && (new_emitter instanceof kb.Backbone.ModelRef)) {
      this.model_ref = new_emitter;
      this.model_ref.retain();
      this.model_ref.bind('loaded', this.__kb._onModelLoaded);
      this.model_ref.bind('unloaded', this.__kb._onModelUnloaded);
      new_emitter = this.model_ref.model();
    } else {
      delete this.model_ref;
    }
    previous_emitter = this.ee;
    this.ee = new_emitter;
    _ref = this.__kb.callbacks;
    for (event_name in _ref) {
      callbacks = _ref[event_name];
      if (previous_emitter) {
        previous_emitter.unbind(event_name, callbacks.fn);
      }
      if (new_emitter) {
        this.ee.bind(event_name, callbacks.fn);
      }
      list = callbacks.list;
      for (_i = 0, _len = list.length; _i < _len; _i++) {
        info = list[_i];
        if (info.emitter) {
          info.emitter(this.ee);
        }
      }
    }
    return new_emitter;
  };

  EventWatcher.prototype.registerCallbacks = function(obj, callback_info) {
    var callbacks, event_name, event_names, event_selector, info, list, _i, _len,
      _this = this;

    obj || _throwMissing(this, 'obj');
    callback_info || _throwMissing(this, 'info');
    event_selector = callback_info.event_selector ? callback_info.event_selector : 'change';
    event_names = event_selector.split(' ');
    for (_i = 0, _len = event_names.length; _i < _len; _i++) {
      event_name = event_names[_i];
      if (!event_name) {
        continue;
      }
      callbacks = this.__kb.callbacks[event_name];
      if (!callbacks) {
        list = [];
        callbacks = {
          list: list,
          fn: function(emitter) {
            var info, _j, _len1;

            for (_j = 0, _len1 = list.length; _j < _len1; _j++) {
              info = list[_j];
              if (info.update && !info.rel_fn) {
                if (emitter && info.key && (emitter.hasChanged && !emitter.hasChanged(_unwrapObservable(info.key)))) {
                  continue;
                }
                !kb.statistics || addStatisticsEvent(emitter, event_name, info);
                info.update();
              }
            }
            return null;
          }
        };
        this.__kb.callbacks[event_name] = callbacks;
        if (this.ee) {
          this.ee.bind(event_name, callbacks.fn);
        }
      }
      info = _.defaults({
        obj: obj
      }, callback_info);
      callbacks.list.push(info);
    }
    if (this.ee) {
      if (kb.Backbone && kb.Backbone.RelationalModel && (this.ee instanceof kb.Backbone.RelationalModel) && _.contains(event_names, 'change')) {
        this._modelBindRelatationalInfo('change', info);
      }
      info.emitter(this.ee) && info.emitter;
    }
  };

  EventWatcher.prototype.releaseCallbacks = function(obj) {
    var callbacks, event_name, index, info, _ref, _ref1;

    if (!this.__kb.callbacks) {
      return;
    }
    _ref = this.__kb.callbacks;
    for (event_name in _ref) {
      callbacks = _ref[event_name];
      _ref1 = callbacks.list;
      for (index in _ref1) {
        info = _ref1[index];
        if (info.obj !== obj) {
          continue;
        }
        callbacks.list.splice(index, 1);
        if (info.rel_fn) {
          this._modelUnbindRelatationalInfo(event_name, info);
        }
        if (!kb.wasReleased(obj) && info.emitter) {
          info.emitter(null);
        }
        return;
      }
    }
  };

  EventWatcher.prototype._onModelLoaded = function(model) {
    var callbacks, event_name, info, is_relational, list, _i, _len, _ref;

    is_relational = kb.Backbone && kb.Backbone.RelationalModel && (model instanceof kb.Backbone.RelationalModel);
    this.ee = model;
    _ref = this.__kb.callbacks;
    for (event_name in _ref) {
      callbacks = _ref[event_name];
      this.ee.bind(event_name, callbacks.fn);
      list = callbacks.list;
      for (_i = 0, _len = list.length; _i < _len; _i++) {
        info = list[_i];
        if (is_relational) {
          this._modelBindRelatationalInfo(event_name, info);
        }
        if (info.emitter) {
          info.emitter(this.ee);
        }
      }
    }
  };

  EventWatcher.prototype._onModelUnloaded = function(model) {
    var callbacks, event_name, info, list, _i, _len, _ref;

    this.ee = null;
    _ref = this.__kb.callbacks;
    for (event_name in _ref) {
      callbacks = _ref[event_name];
      model.unbind(event_name, callbacks.fn);
      list = callbacks.list;
      for (_i = 0, _len = list.length; _i < _len; _i++) {
        info = list[_i];
        if (info.rel_fn) {
          this._modelUnbindRelatationalInfo(event_name, info);
        }
        if (info.emitter) {
          info.emitter(null);
        }
      }
    }
  };

  EventWatcher.prototype._modelBindRelatationalInfo = function(event_name, info) {
    var key, relation;

    if ((event_name === 'change') && info.key && info.update) {
      key = _unwrapObservable(info.key);
      relation = _.find(this.ee.getRelations(), function(test) {
        return test.key === key;
      });
      if (!relation) {
        return;
      }
      info.rel_fn = function(emitter) {
        !kb.statistics || addStatisticsEvent(emitter, "" + event_name + " (relational)", info);
        return info.update();
      };
      if (relation.collectionType || _.isArray(relation.keyContents)) {
        info.is_collection = true;
        this.ee.bind("add:" + info.key, info.rel_fn);
        this.ee.bind("remove:" + info.key, info.rel_fn);
      } else {
        this.ee.bind((Backbone.Relation.prototype.sanitizeOptions ? "update:" + info.key : "change:" + info.key), info.rel_fn);
      }
    }
  };

  EventWatcher.prototype._modelUnbindRelatationalInfo = function(event_name, info) {
    if (!info.rel_fn) {
      return;
    }
    if (info.is_collection) {
      this.ee.unbind("add:" + info.key, info.rel_fn);
      this.ee.unbind("remove:" + info.key, info.rel_fn);
    } else {
      this.ee.unbind((Backbone.Relation.prototype.sanitizeOptions ? "update:" + info.key : "change:" + info.key), info.rel_fn);
    }
    info.rel_fn = null;
  };

  return EventWatcher;

})();

kb.emitterObservable = function(emitter, observable) {
  return new kb.EventWatcher(emitter, observable);
};

/*
  knockback-observable.js
  (c) 2012 Kevin Malakoff.
  Knockback.Observable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


kb.Observable = (function() {
  function Observable(model, options, vm) {
    var create_options, event_watcher, observable,
      _this = this;

    this.vm = vm;
    options || _throwMissing(this, 'options');
    this.vm || (this.vm = {});
    if (_.isString(options) || ko.isObservable(options)) {
      create_options = this.create_options = {
        key: options
      };
    } else {
      create_options = this.create_options = collapseOptions(options);
    }
    this.key = create_options.key;
    delete create_options.key;
    this.key || _throwMissing(this, 'key');
    !create_options.args || (this.args = create_options.args, delete create_options.args);
    !create_options.read || (this.read = create_options.read, delete create_options.read);
    !create_options.write || (this.write = create_options.write, delete create_options.write);
    event_watcher = create_options.event_watcher;
    delete create_options.event_watcher;
    this.vo = ko.observable(null);
    this._model = ko.observable();
    observable = kb.utils.wrappedObservable(this, ko.dependentObservable({
      read: function() {
        var arg, args, new_value, _i, _len, _ref;

        args = [_unwrapObservable(_this.key)];
        if (_this.args) {
          if (_.isArray(_this.args)) {
            _ref = _this.args;
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              arg = _ref[_i];
              args.push(_unwrapObservable(arg));
            }
          } else {
            args.push(_unwrapObservable(_this.args));
          }
        }
        if (_this._mdl === _this._model() && _this._mdl) {
          new_value = _this.read ? _this.read.apply(_this.vm, args) : _this._mdl.get.apply(_this._mdl, args);
          _this.update(new_value);
        }
        return _unwrapObservable(_this.vo());
      },
      write: function(new_value) {
        var arg, args, set_info, unwrapped_new_value, _i, _len, _ref;

        unwrapped_new_value = _unwrapModels(new_value);
        set_info = {};
        set_info[_unwrapObservable(_this.key)] = unwrapped_new_value;
        args = _this.write ? [unwrapped_new_value] : [set_info];
        if (_this.args) {
          if (_.isArray(_this.args)) {
            _ref = _this.args;
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              arg = _ref[_i];
              args.push(_unwrapObservable(arg));
            }
          } else {
            args.push(_unwrapObservable(_this.args));
          }
        }
        if (_this._mdl) {
          if (_this.write) {
            _this.write.apply(_this.vm, args);
          } else {
            _this._mdl.set.apply(_this._mdl, args);
          }
        }
        return _this.update(new_value);
      },
      owner: this.vm
    }));
    observable.__kb_is_o = true;
    create_options.store = kb.utils.wrappedStore(observable, create_options.store);
    create_options.path = kb.utils.pathJoin(create_options.path, this.key);
    if (create_options.factories && ((typeof create_options.factories === 'function') || create_options.factories.create)) {
      create_options.factory = kb.utils.wrappedFactory(observable, new kb.Factory(create_options.factory));
      create_options.factory.addPathMapping(create_options.path, create_options.factories);
    } else {
      create_options.factory = kb.Factory.useOptionsOrCreate(create_options, observable, create_options.path);
    }
    delete create_options.factories;
    observable.value = _.bind(this.value, this);
    observable.valueType = _.bind(this.valueType, this);
    observable.destroy = _.bind(this.destroy, this);
    observable.model = this.model = ko.dependentObservable({
      read: function() {
        _this._model();
        return _this._mdl;
      },
      write: function(new_model) {
        if (_this.__kb_released || (_this._mdl === new_model)) {
          return;
        }
        _this._mdl = new_model;
        _this.update(null);
        return _this._model(new_model);
      }
    });
    kb.EventWatcher.useOptionsOrCreate({
      event_watcher: event_watcher
    }, model, this, {
      emitter: this.model,
      update: _.bind(this.update, this),
      key: this.key,
      path: create_options.path
    });
    this.__kb_value || this.update();
    if (kb.LocalizedObservable && create_options.localizer) {
      observable = new create_options.localizer(observable);
      delete create_options.localizer;
    }
    if (kb.DefaultObservable && create_options.hasOwnProperty('default')) {
      observable = kb.defaultObservable(observable, create_options["default"]);
      delete create_options["default"];
    }
    return observable;
  }

  Observable.prototype.destroy = function() {
    var observable;

    observable = kb.utils.wrappedObservable(this);
    this.__kb_released = true;
    kb.release(this.__kb_value);
    this.__kb_value = null;
    this.model.dispose();
    this._mdl = this.model = observable.model = null;
    return kb.utils.wrappedDestroy(this);
  };

  Observable.prototype.value = function() {
    return this.__kb_value;
  };

  Observable.prototype.valueType = function() {
    var new_value;

    new_value = this._mdl ? this._mdl.get(this.key) : null;
    this.value_type || this._updateValueObservable(new_value);
    return this.value_type;
  };

  Observable.prototype.update = function(new_value) {
    var new_type, value;

    if (this.__kb_released) {
      return;
    }
    if (this._mdl && !arguments.length) {
      new_value = this._mdl.get(_unwrapObservable(this.key));
    }
    (new_value !== void 0) || (new_value = null);
    new_type = kb.utils.valueType(new_value);
    if (!this.__kb_value || (this.__kb_value.__kb_released || (this.__kb_value.__kb_null && new_value))) {
      this.__kb_value = void 0;
      this.value_type = void 0;
    }
    value = this.__kb_value;
    if (_.isUndefined(this.value_type) || (this.value_type !== new_type && new_type !== KB_TYPE_UNKNOWN)) {
      if ((this.value_type === KB_TYPE_COLLECTION) && (new_type === KB_TYPE_ARRAY)) {
        return value(new_value);
      } else {
        return this._updateValueObservable(new_value);
      }
    } else if (this.value_type === KB_TYPE_MODEL) {
      if (typeof value.model === 'function') {
        if (value.model() !== new_value) {
          return value.model(new_value);
        }
      } else if (kb.utils.wrappedObject(value) !== new_value) {
        return this._updateValueObservable(new_value);
      }
    } else if (this.value_type === KB_TYPE_COLLECTION) {
      if (value.collection() !== new_value) {
        return value.collection(new_value);
      }
    } else {
      if (value() !== new_value) {
        return value(new_value);
      }
    }
  };

  Observable.prototype._updateValueObservable = function(new_value) {
    var create_options, creator, previous_value, value;

    create_options = this.create_options;
    create_options.creator = kb.utils.inferCreator(new_value, create_options.factory, create_options.path, this._mdl, this.key);
    this.value_type = KB_TYPE_UNKNOWN;
    creator = create_options.creator;
    previous_value = this.__kb_value;
    this.__kb_value = void 0;
    if (previous_value) {
      kb.release(previous_value);
    }
    if (creator) {
      if (create_options.store) {
        value = create_options.store.findOrCreate(new_value, create_options);
      } else {
        if (creator.models_only) {
          value = new_value;
          this.value_type = KB_TYPE_SIMPLE;
        } else if (creator.create) {
          value = creator.create(new_value, create_options);
        } else {
          value = new creator(new_value, create_options);
        }
      }
    } else {
      if (_.isArray(new_value)) {
        this.value_type = KB_TYPE_ARRAY;
        value = ko.observableArray(new_value);
      } else {
        this.value_type = KB_TYPE_SIMPLE;
        value = ko.observable(new_value);
      }
    }
    if (this.value_type === KB_TYPE_UNKNOWN) {
      if (!ko.isObservable(value)) {
        this.value_type = KB_TYPE_MODEL;
        if (typeof value.model !== 'function') {
          kb.utils.wrappedObject(value, new_value);
        }
      } else if (value.__kb_is_co) {
        this.value_type = KB_TYPE_COLLECTION;
      } else {
        this.value_type = KB_TYPE_SIMPLE;
      }
    }
    this.__kb_value = value;
    return this.vo(value);
  };

  return Observable;

})();

kb.observable = function(model, options, view_model) {
  return new kb.Observable(model, options, view_model);
};

/*
  knockback-view-model.js
  (c) 2011-2013 Kevin Malakoff.
  Knockback.Observable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


kb.ViewModel = (function() {
  ViewModel.extend = kb.extend;

  function ViewModel(model, options, view_model) {
    var attribute_keys, bb_model, event_watcher, keys, mapped_keys, mapping_info, vm_key, _mdl, _ref,
      _this = this;

    !model || (model instanceof kb.Model) || ((typeof model.get === 'function') && (typeof model.bind === 'function')) || _throwUnexpected(this, 'not a model');
    options || (options = {});
    view_model || (view_model = {});
    if (_.isArray(options)) {
      options = {
        keys: options
      };
    } else {
      options = collapseOptions(options);
    }
    this.__kb || (this.__kb = {});
    this.__kb.vm_keys = {};
    this.__kb.model_keys = {};
    this.__kb.view_model = _.isUndefined(view_model) ? this : view_model;
    !options.internals || (this.__kb.internals = options.internals);
    !options.excludes || (this.__kb.excludes = options.excludes);
    kb.Store.useOptionsOrCreate(options, model, this);
    this.__kb.path = options.path;
    kb.Factory.useOptionsOrCreate(options, this, options.path);
    _mdl = _wrappedKey(this, '_mdl', ko.observable());
    this.model = ko.dependentObservable({
      read: function() {
        _mdl();
        return kb.utils.wrappedObject(_this);
      },
      write: function(new_model) {
        var event_watcher, missing;

        if (kb.utils.wrappedObject(_this) === new_model) {
          return;
        }
        if (_this.__kb_null) {
          !new_model || _throwUnexpected(_this, 'model set on shared null');
          return;
        }
        kb.utils.wrappedObject(_this, new_model);
        event_watcher = kb.utils.wrappedEventWatcher(_this);
        if (!event_watcher) {
          _mdl(new_model);
          return;
        }
        event_watcher.emitter(new_model);
        if (!(_this.__kb.keys || !new_model || !new_model.attributes)) {
          missing = _.difference(_.keys(new_model.attributes), _.keys(_this.__kb.model_keys));
          if (missing) {
            _this._createObservables(new_model, missing);
          }
        }
        _mdl(new_model);
      }
    });
    event_watcher = kb.utils.wrappedEventWatcher(this, new kb.EventWatcher(model, this, {
      emitter: this.model
    }));
    if (options.requires && _.isArray(options.requires)) {
      keys = _.clone(options.requires);
    }
    if (this.__kb.internals) {
      keys = keys ? _.union(keys, this.__kb.internals) : _.clone(this.__kb.internals);
    }
    if (options.keys) {
      if (_.isArray(options.keys)) {
        this.__kb.keys = options.keys;
        keys = keys ? _.union(keys, options.keys) : _.clone(options.keys);
      } else {
        mapped_keys = {};
        _ref = options.keys;
        for (vm_key in _ref) {
          mapping_info = _ref[vm_key];
          mapped_keys[_.isString(mapping_info) ? mapping_info : (mapping_info.key ? mapping_info.key : vm_key)] = true;
        }
        this.__kb.keys = _.keys(mapped_keys);
      }
    } else {
      bb_model = event_watcher.emitter();
      if (bb_model && bb_model.attributes) {
        attribute_keys = _.keys(bb_model.attributes);
        keys = keys ? _.union(keys, attribute_keys) : attribute_keys;
      }
    }
    if (keys && this.__kb.excludes) {
      keys = _.difference(keys, this.__kb.excludes);
    }
    if (_.isObject(options.keys) && !_.isArray(options.keys)) {
      this._mapObservables(model, options.keys);
    }
    if (_.isObject(options.requires) && !_.isArray(options.requires)) {
      this._mapObservables(model, options.requires);
    }
    !options.mappings || this._mapObservables(model, options.mappings);
    !keys || this._createObservables(model, keys);
    !kb.statistics || kb.statistics.register('ViewModel', this);
  }

  ViewModel.prototype.destroy = function() {
    var vm_key;

    if (this.__kb.view_model !== this) {
      for (vm_key in this.__kb.vm_keys) {
        this.__kb.view_model[vm_key] = null;
      }
    }
    this.__kb.view_model = null;
    kb.releaseKeys(this);
    kb.utils.wrappedDestroy(this);
    return !kb.statistics || kb.statistics.unregister('ViewModel', this);
  };

  ViewModel.prototype.shareOptions = function() {
    return {
      store: kb.utils.wrappedStore(this),
      factory: kb.utils.wrappedFactory(this)
    };
  };

  ViewModel.prototype._createObservables = function(model, keys) {
    var create_options, key, vm_key, _i, _len;

    create_options = {
      store: kb.utils.wrappedStore(this),
      factory: kb.utils.wrappedFactory(this),
      path: this.__kb.path,
      event_watcher: kb.utils.wrappedEventWatcher(this)
    };
    for (_i = 0, _len = keys.length; _i < _len; _i++) {
      key = keys[_i];
      vm_key = this.__kb.internals && _.contains(this.__kb.internals, key) ? "_" + key : key;
      if (this[vm_key]) {
        continue;
      }
      this.__kb.vm_keys[vm_key] = true;
      this.__kb.model_keys[key] = true;
      create_options.key = key;
      this[vm_key] = this.__kb.view_model[vm_key] = kb.observable(model, create_options, this);
    }
  };

  ViewModel.prototype._mapObservables = function(model, mappings) {
    var create_options, mapping_info, vm_key;

    create_options = {
      store: kb.utils.wrappedStore(this),
      factory: kb.utils.wrappedFactory(this),
      path: this.__kb.path,
      event_watcher: kb.utils.wrappedEventWatcher(this)
    };
    for (vm_key in mappings) {
      mapping_info = mappings[vm_key];
      if (this[vm_key]) {
        continue;
      }
      mapping_info = _.isString(mapping_info) ? {
        key: mapping_info
      } : _.clone(mapping_info);
      mapping_info.key || (mapping_info.key = vm_key);
      this.__kb.vm_keys[vm_key] = true;
      this.__kb.model_keys[mapping_info.key] = true;
      this[vm_key] = this.__kb.view_model[vm_key] = kb.observable(model, _.defaults(mapping_info, create_options), this);
    }
  };

  return ViewModel;

})();

kb.viewModel = function(model, options, view_model) {
  return new kb.ViewModel(model, options, view_model);
};

/*
  knockback-collection-observable.js
  (c) 2011-2013 Kevin Malakoff.
  Knockback.CollectionObservable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


COMPARE_EQUAL = 0;

COMPARE_ASCENDING = -1;

COMPARE_DESCENDING = 1;

kb.compare = function(value_a, value_b) {
  if (_.isString(value_a)) {
    return value_a.localeCompare("" + value_b);
  }
  if (_.isString(value_b)) {
    return value_b.localeCompare("" + value_a);
  }
  if (value_a === value_b) {
    return COMPARE_EQUAL;
  } else {
    if (value_a < value_b) {
      return COMPARE_ASCENDING;
    } else {
      return COMPARE_DESCENDING;
    }
  }
};

kb.CollectionObservable = (function() {
  CollectionObservable.extend = kb.extend;

  function CollectionObservable(collection, options) {
    var create_options, observable,
      _this = this;

    !collection || (collection instanceof kb.Collection) || _throwUnexpected(this, 'not a collection');
    options || (options = {});
    observable = kb.utils.wrappedObservable(this, ko.observableArray([]));
    observable.__kb_is_co = true;
    this.in_edit = 0;
    this.__kb || (this.__kb = {});
    this.__kb._onCollectionChange = _.bind(this._onCollectionChange, this);
    options = collapseOptions(options);
    if (options.sort_attribute) {
      this._comparator = ko.observable(this._attributeComparator(options.sort_attribute));
    } else {
      this._comparator = ko.observable(options.comparator);
    }
    if (options.filters) {
      this._filters = ko.observableArray(_.isArray(options.filters) ? options.filters : options.filters ? [options.filters] : void 0);
    } else {
      this._filters = ko.observableArray([]);
    }
    create_options = this.create_options = {
      store: kb.Store.useOptionsOrCreate(options, collection, observable)
    };
    this.path = options.path;
    create_options.factory = kb.utils.wrappedFactory(observable, this._shareOrCreateFactory(options));
    create_options.path = kb.utils.pathJoin(options.path, 'models');
    create_options.creator = create_options.factory.creatorForPath(null, create_options.path);
    if (create_options.creator) {
      this.models_only = create_options.creator.models_only;
    }
    observable.destroy = _.bind(this.destroy, this);
    observable.shareOptions = _.bind(this.shareOptions, this);
    observable.filters = _.bind(this.filters, this);
    observable.comparator = _.bind(this.comparator, this);
    observable.sortAttribute = _.bind(this.sortAttribute, this);
    observable.viewModelByModel = _.bind(this.viewModelByModel, this);
    observable.hasViewModels = _.bind(this.hasViewModels, this);
    this._collection = ko.observable(collection);
    observable.collection = this.collection = ko.dependentObservable({
      read: function() {
        return _this._collection();
      },
      write: function(new_collection) {
        var previous_collection;

        if ((previous_collection = _this._collection()) === new_collection) {
          return;
        }
        if (previous_collection) {
          previous_collection.unbind('all', _this.__kb._onCollectionChange);
        }
        if (new_collection) {
          new_collection.bind('all', _this.__kb._onCollectionChange);
        }
        return _this._collection(new_collection);
      }
    });
    if (collection) {
      collection.bind('all', this.__kb._onCollectionChange);
    }
    this._mapper = ko.dependentObservable(function() {
      var comparator, current_collection, filter, filters, models, view_models, _i, _len;

      comparator = _this._comparator();
      filters = _this._filters();
      if (filters) {
        for (_i = 0, _len = filters.length; _i < _len; _i++) {
          filter = filters[_i];
          _unwrapObservable(filter);
        }
      }
      current_collection = _this._collection();
      if (_this.in_edit) {
        return;
      }
      observable = kb.utils.wrappedObservable(_this);
      if (current_collection) {
        models = current_collection.models;
      }
      if (!models || (current_collection.models.length === 0)) {
        view_models = [];
      } else {
        if (filters.length) {
          models = _.filter(models, function(model) {
            return !_this._modelIsFiltered(model);
          });
        }
        if (comparator) {
          view_models = _.map(models, function(model) {
            return _this._createViewModel(model);
          }).sort(comparator);
        } else {
          if (_this.models_only) {
            view_models = filters.length ? models : models.slice();
          } else {
            view_models = _.map(models, function(model) {
              return _this._createViewModel(model);
            });
          }
        }
      }
      _this.in_edit++;
      observable(view_models);
      return _this.in_edit--;
    });
    observable.subscribe(_.bind(this._onObservableArrayChange, this));
    !kb.statistics || kb.statistics.register('CollectionObservable', this);
    return observable;
  }

  CollectionObservable.prototype.destroy = function() {
    var array, collection, observable;

    observable = kb.utils.wrappedObservable(this);
    collection = this._collection();
    if (collection) {
      collection.unbind('all', this.__kb._onCollectionChange);
      array = observable();
      array.splice(0, array.length);
    }
    this._mapper.dispose();
    this._mapper = null;
    kb.release(this._filters);
    this._comparator(null);
    this.collection.dispose();
    observable.collection = this.collection = null;
    observable.collection = null;
    kb.utils.wrappedDestroy(this);
    return !kb.statistics || kb.statistics.unregister('CollectionObservable', this);
  };

  CollectionObservable.prototype.shareOptions = function() {
    var observable;

    observable = kb.utils.wrappedObservable(this);
    return {
      store: kb.utils.wrappedStore(observable),
      factory: kb.utils.wrappedFactory(observable)
    };
  };

  CollectionObservable.prototype.filters = function(filters) {
    if (filters) {
      return this._filters(_.isArray(filters) ? filters : [filters]);
    } else {
      return this._filters([]);
    }
  };

  CollectionObservable.prototype.comparator = function(comparator) {
    return this._comparator(comparator);
  };

  CollectionObservable.prototype.sortAttribute = function(sort_attribute) {
    return this._comparator(sort_attribute ? this._attributeComparator(sort_attribute) : null);
  };

  CollectionObservable.prototype.viewModelByModel = function(model) {
    var id_attribute;

    if (this.models_only) {
      return null;
    }
    id_attribute = model.hasOwnProperty(model.idAttribute) ? model.idAttribute : 'cid';
    return _.find(kb.utils.wrappedObservable(this)(), function(test) {
      var _ref;

      if (test != null ? (_ref = test.__kb) != null ? _ref.object : void 0 : void 0) {
        return test.__kb.object[id_attribute] === model[id_attribute];
      } else {
        return false;
      }
    });
  };

  CollectionObservable.prototype.hasViewModels = function() {
    return !this.models_only;
  };

  CollectionObservable.prototype._shareOrCreateFactory = function(options) {
    var absolute_models_path, existing_creator, factories, factory;

    absolute_models_path = kb.utils.pathJoin(options.path, 'models');
    factories = options.factories;
    if ((factory = options.factory)) {
      if ((existing_creator = factory.creatorForPath(null, absolute_models_path)) && (!factories || (factories['models'] === existing_creator))) {
        if (!factories) {
          return factory;
        }
        if (factory.hasPathMappings(factories, options.path)) {
          return factory;
        }
      }
    }
    factory = new kb.Factory(options.factory);
    if (factories) {
      factory.addPathMappings(factories, options.path);
    }
    if (!factory.creatorForPath(null, absolute_models_path)) {
      if (options.hasOwnProperty('models_only')) {
        if (options.models_only) {
          factory.addPathMapping(absolute_models_path, {
            models_only: true
          });
        } else {
          factory.addPathMapping(absolute_models_path, kb.ViewModel);
        }
      } else if (options.view_model) {
        factory.addPathMapping(absolute_models_path, options.view_model);
      } else if (options.create) {
        factory.addPathMapping(absolute_models_path, {
          create: options.create
        });
      } else {
        factory.addPathMapping(absolute_models_path, kb.ViewModel);
      }
    }
    return factory;
  };

  CollectionObservable.prototype._onCollectionChange = function(event, arg) {
    var collection, comparator, observable, view_model;

    if (this.in_edit) {
      return;
    }
    switch (event) {
      case 'reset':
      case 'resort':
        this._collection.notifySubscribers(this._collection());
        break;
      case 'new':
      case 'add':
        if (this._modelIsFiltered(arg)) {
          return;
        }
        observable = kb.utils.wrappedObservable(this);
        collection = this._collection();
        if ((view_model = this.viewModelByModel(arg))) {
          return;
        }
        this.in_edit++;
        view_model = this._createViewModel(arg);
        if ((comparator = this._comparator())) {
          observable().push(view_model);
          observable.sort(comparator);
        } else {
          observable.splice(collection.indexOf(arg), 0, view_model);
        }
        this.in_edit--;
        break;
      case 'remove':
      case 'destroy':
        this._onModelRemove(arg);
        break;
      case 'change':
        if (this._modelIsFiltered(arg)) {
          this._onModelRemove(arg);
        } else {
          view_model = this.models_only ? arg : this.viewModelByModel(arg);
          if (view_model) {
            if ((comparator = this._comparator())) {
              observable = kb.utils.wrappedObservable(this);
              this.in_edit++;
              observable.sort(comparator);
              this.in_edit--;
            }
          } else {
            this._onCollectionChange('add', arg);
          }
        }
    }
  };

  CollectionObservable.prototype._onModelRemove = function(model) {
    var observable, view_model;

    view_model = this.models_only ? model : this.viewModelByModel(model);
    if (!view_model) {
      return;
    }
    observable = kb.utils.wrappedObservable(this);
    this.in_edit++;
    observable.remove(view_model);
    return this.in_edit--;
  };

  CollectionObservable.prototype._onObservableArrayChange = function(models_or_view_models) {
    var collection, has_filters, model, models, observable, view_model, view_models, _i, _len,
      _this = this;

    if (this.in_edit) {
      return;
    }
    (this.models_only && (!models_or_view_models.length || kb.utils.hasModelSignature(models_or_view_models[0]))) || (!this.models_only && (!models_or_view_models.length || (_.isObject(models_or_view_models[0]) && !kb.utils.hasModelSignature(models_or_view_models[0])))) || _throwUnexpected(this, 'incorrect type passed');
    observable = kb.utils.wrappedObservable(this);
    collection = this._collection();
    has_filters = this._filters().length;
    if (!collection) {
      return;
    }
    view_models = models_or_view_models;
    if (this.models_only) {
      if (has_filters) {
        models = _.filter(models_or_view_models, function(model) {
          return !_this._modelIsFiltered(model);
        });
      }
    } else {
      !has_filters || (view_models = []);
      models = [];
      for (_i = 0, _len = models_or_view_models.length; _i < _len; _i++) {
        view_model = models_or_view_models[_i];
        model = kb.utils.wrappedObject(view_model);
        if (has_filters) {
          if (this._modelIsFiltered(model)) {
            continue;
          }
          view_models.push(view_model);
        }
        this.create_options.store.findOrReplace(model, this.create_options.creator, view_model);
        models.push(model);
      }
    }
    this.in_edit++;
    (models_or_view_models.length === view_models.length) || observable(view_models);
    _.isEqual(collection.models, models) || collection.reset(models);
    this.in_edit--;
  };

  CollectionObservable.prototype._attributeComparator = function(sort_attribute) {
    var modelAttributeCompare;

    modelAttributeCompare = function(model_a, model_b) {
      var attribute_name;

      attribute_name = _unwrapObservable(sort_attribute);
      return kb.compare(model_a.get(attribute_name), model_b.get(attribute_name));
    };
    return (this.models_only ? modelAttributeCompare : function(model_a, model_b) {
      return modelAttributeCompare(kb.utils.wrappedModel(model_a), kb.utils.wrappedModel(model_b));
    });
  };

  CollectionObservable.prototype._createViewModel = function(model) {
    if (this.models_only) {
      return model;
    } else {
      return this.create_options.store.findOrCreate(model, this.create_options);
    }
  };

  CollectionObservable.prototype._modelIsFiltered = function(model) {
    var filter, filters, _i, _len;

    filters = this._filters();
    for (_i = 0, _len = filters.length; _i < _len; _i++) {
      filter = filters[_i];
      filter = _unwrapObservable(filter);
      if (((typeof filter === 'function') && filter(model)) || (model && (model.id === filter))) {
        return true;
      }
    }
    return false;
  };

  return CollectionObservable;

})();

kb.collectionObservable = function(collection, options) {
  return new kb.CollectionObservable(collection, options);
};

/*
  knockback-inject.js
  (c) 2011-2013 Kevin Malakoff.
  Knockback.Inject is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


ko.bindingHandlers['inject'] = {
  'init': function(element, value_accessor, all_bindings_accessor, view_model) {
    return kb.Inject.inject(_unwrapObservable(value_accessor()), view_model, element, value_accessor, all_bindings_accessor);
  }
};

kb.Inject = (function() {
  function Inject() {}

  Inject.inject = function(data, view_model, element, value_accessor, all_bindings_accessor, nested) {
    var inject, result, wrapper;

    inject = function(data) {
      var key, target, value;

      if (_.isFunction(data)) {
        view_model = new data(view_model, element, value_accessor, all_bindings_accessor);
        kb.releaseOnNodeRemove(view_model, element);
      } else {
        if (data.view_model) {
          view_model = new data.view_model(view_model, element, value_accessor, all_bindings_accessor);
          kb.releaseOnNodeRemove(view_model, element);
        }
        for (key in data) {
          value = data[key];
          if (key === 'view_model') {
            continue;
          }
          if (key === 'create') {
            value(view_model, element, value_accessor, all_bindings_accessor);
          } else if (_.isObject(value) && !_.isFunction(value)) {
            target = nested || (value && value.create) ? {} : view_model;
            view_model[key] = kb.Inject.inject(value, target, element, value_accessor, all_bindings_accessor, true);
          } else {
            view_model[key] = value;
          }
        }
      }
      return view_model;
    };
    if (nested) {
      return inject(data);
    } else {
      result = (wrapper = ko.dependentObservable(function() {
        return inject(data);
      }))();
      wrapper.dispose();
      return result;
    }
  };

  Inject.injectViewModels = function(root) {
    var afterBinding, app, beforeBinding, data, expression, findElements, options, results, _i, _len;

    results = [];
    findElements = function(el) {
      var attr, child_el, _i, _len, _ref;

      if (!el.__kb_injected) {
        if (el.attributes && (attr = _.find(el.attributes, function(attr) {
          return attr.name === 'kb-inject';
        }))) {
          el.__kb_injected = true;
          results.push({
            el: el,
            view_model: {},
            binding: attr.value
          });
        }
      }
      _ref = el.childNodes;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        child_el = _ref[_i];
        findElements(child_el);
      }
    };
    findElements(root || document);
    for (_i = 0, _len = results.length; _i < _len; _i++) {
      app = results[_i];
      if (expression = app.binding) {
        (expression.search(/[:]/) < 0) || (expression = "{" + expression + "}");
        data = (new Function("", "return ( " + expression + " )"))();
        data || (data = {});
        (!data.options) || (options = data.options, delete data.options);
        options || (options = {});
        app.view_model = kb.Inject.inject(data, app.view_model, app.el, null, null, true);
        afterBinding = app.view_model.afterBinding || options.afterBinding;
        beforeBinding = app.view_model.beforeBinding || options.beforeBinding;
      }
      if (beforeBinding) {
        beforeBinding(app.view_model, app.el, options);
      }
      kb.applyBindings(app.view_model, app.el, options);
      if (afterBinding) {
        afterBinding(app.view_model, app.el, options);
      }
    }
    return results;
  };

  return Inject;

})();

kb.injectViewModels = kb.Inject.injectViewModels;

if (this.$) {
  this.$(function() {
    return kb.injectViewModels();
  });
} else {
  (onReady = function() {
    if (document.readyState !== "complete") {
      return setTimeout(onReady, 0);
    }
    return kb.injectViewModels();
  })();
}

/*
  knockback_default_observable.js 0.17.0
  (c) 2011-2013 Kevin Malakoff.
  Knockback.DefaultObservable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


kb.DefaultObservable = (function() {
  function DefaultObservable(target_observable, dv) {
    var observable,
      _this = this;

    this.dv = dv;
    observable = kb.utils.wrappedObservable(this, ko.dependentObservable({
      read: function() {
        var current_target;

        if ((current_target = _unwrapObservable(target_observable()))) {
          return current_target;
        } else {
          return _unwrapObservable(_this.dv);
        }
      },
      write: function(value) {
        return target_observable(value);
      }
    }));
    observable.destroy = _.bind(this.destroy, this);
    observable.setToDefault = _.bind(this.setToDefault, this);
    return observable;
  }

  DefaultObservable.prototype.destroy = function() {
    return kb.utils.wrappedDestroy(this);
  };

  DefaultObservable.prototype.setToDefault = function() {
    return kb.utils.wrappedObservable(this)(this.dv);
  };

  return DefaultObservable;

})();

kb.defaultObservable = function(target, default_value) {
  return new kb.DefaultObservable(target, default_value);
};

/*
  knockback-extensions.js (knockback-defaults)
  (c) 2011-2013 Kevin Malakoff.
  Knockback.js is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
  Dependencies: Knockout.js, Backbone.js, and Underscore.js.
    Optional dependency: Backbone.ModelRef.js.
*/


kb.Observable.prototype.setToDefault = function() {
  var _ref;

  if ((_ref = this.__kb_value) != null) {
    if (typeof _ref.setToDefault === "function") {
      _ref.setToDefault();
    }
  }
};

kb.ViewModel.prototype.setToDefault = function() {
  var vm_key, _ref;

  for (vm_key in this.__kb.vm_keys) {
    if ((_ref = this[vm_key]) != null) {
      if (typeof _ref.setToDefault === "function") {
        _ref.setToDefault();
      }
    }
  }
};

kb.utils.setToDefault = function(obj) {
  var key, value;

  if (!obj) {
    return;
  }
  if (ko.isObservable(obj)) {
    if (typeof obj.setToDefault === "function") {
      obj.setToDefault();
    }
  } else if (_.isObject(obj)) {
    for (key in obj) {
      value = obj[key];
      if (value && (ko.isObservable(value) || (typeof value !== 'function')) && ((key[0] !== '_') || key.search('__kb'))) {
        this.setToDefault(value);
      }
    }
  }
  return obj;
};

/*
  knockback-formatted-observable.js 0.17.0
  (c) 2011-2013 Kevin Malakoff.
  Knockback.FormattedObservable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


arraySlice = Array.prototype.slice;

kb.toFormattedString = function(format) {
  var arg, args, index, parameter_index, result, value;

  result = format.slice();
  args = arraySlice.call(arguments, 1);
  for (index in args) {
    arg = args[index];
    value = _unwrapObservable(arg);
    value || (value = '');
    parameter_index = format.indexOf("\{" + index + "\}");
    while (parameter_index >= 0) {
      result = result.replace("{" + index + "}", value);
      parameter_index = format.indexOf("\{" + index + "\}", parameter_index + 1);
    }
  }
  return result;
};

kb.parseFormattedString = function(string, format) {
  var count, format_indices_to_matched_indices, index, match_index, matches, parameter_count, parameter_index, positions, regex, regex_string, result, results, sorted_positions;

  regex_string = format.slice();
  index = 0;
  parameter_count = 0;
  positions = {};
  while (regex_string.search("\\{" + index + "\\}") >= 0) {
    parameter_index = format.indexOf("\{" + index + "\}");
    while (parameter_index >= 0) {
      regex_string = regex_string.replace("\{" + index + "\}", '(.*)');
      positions[parameter_index] = index;
      parameter_count++;
      parameter_index = format.indexOf("\{" + index + "\}", parameter_index + 1);
    }
    index++;
  }
  count = index;
  regex = new RegExp(regex_string);
  matches = regex.exec(string);
  if (matches) {
    matches.shift();
  }
  if (!matches || (matches.length !== parameter_count)) {
    result = [];
    while (count-- > 0) {
      result.push('');
    }
    return result;
  }
  sorted_positions = _.sortBy(_.keys(positions), function(parameter_index, format_index) {
    return parseInt(parameter_index, 10);
  });
  format_indices_to_matched_indices = {};
  for (match_index in sorted_positions) {
    parameter_index = sorted_positions[match_index];
    index = positions[parameter_index];
    if (format_indices_to_matched_indices.hasOwnProperty(index)) {
      continue;
    }
    format_indices_to_matched_indices[index] = match_index;
  }
  results = [];
  index = 0;
  while (index < count) {
    results.push(matches[format_indices_to_matched_indices[index]]);
    index++;
  }
  return results;
};

kb.FormattedObservable = (function() {
  function FormattedObservable(format, args) {
    var observable, observable_args;

    if (_.isArray(args)) {
      format = format;
      observable_args = args;
    } else {
      observable_args = arraySlice.call(arguments, 1);
    }
    observable = kb.utils.wrappedObservable(this, ko.dependentObservable({
      read: function() {
        var arg, _i, _len;

        args = [_unwrapObservable(format)];
        for (_i = 0, _len = observable_args.length; _i < _len; _i++) {
          arg = observable_args[_i];
          args.push(_unwrapObservable(arg));
        }
        return kb.toFormattedString.apply(null, args);
      },
      write: function(value) {
        var index, matches, max_count;

        matches = kb.parseFormattedString(value, _unwrapObservable(format));
        max_count = Math.min(observable_args.length, matches.length);
        index = 0;
        while (index < max_count) {
          observable_args[index](matches[index]);
          index++;
        }
      }
    }));
    return observable;
  }

  FormattedObservable.prototype.destroy = function() {
    return kb.utils.wrappedDestroy(this);
  };

  return FormattedObservable;

})();

kb.formattedObservable = function(format, args) {
  return new kb.FormattedObservable(format, arraySlice.call(arguments, 1));
};

/*
  knockback-localized-observable.js 0.17.0
  (c) 2011-2013 Kevin Malakoff.
  Knockback.LocalizedObservable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


kb.LocalizedObservable = (function() {
  LocalizedObservable.extend = kb.extend;

  function LocalizedObservable(value, options, vm) {
    var observable,
      _this = this;

    this.value = value;
    this.vm = vm;
    options || (options = {});
    this.vm || (this.vm = {});
    this.read || _throwMissing(this, 'read');
    kb.locale_manager || _throwMissing(this, 'kb.locale_manager');
    this.__kb || (this.__kb = {});
    this.__kb._onLocaleChange = _.bind(this._onLocaleChange, this);
    this.__kb._onChange = options.onChange;
    if (this.value) {
      value = _unwrapObservable(this.value);
    }
    this.vo = ko.observable(!value ? null : this.read(value, null));
    observable = kb.utils.wrappedObservable(this, ko.dependentObservable({
      read: function() {
        if (_this.value) {
          _unwrapObservable(_this.value);
        }
        _this.vo();
        return _this.read(_unwrapObservable(_this.value));
      },
      write: function(value) {
        _this.write || _throwUnexpected(_this, 'writing to read-only');
        _this.write(value, _unwrapObservable(_this.value));
        _this.vo(value);
        if (_this.__kb._onChange) {
          return _this.__kb._onChange(value);
        }
      },
      owner: this.vm
    }));
    observable.destroy = _.bind(this.destroy, this);
    observable.observedValue = _.bind(this.observedValue, this);
    observable.resetToCurrent = _.bind(this.resetToCurrent, this);
    kb.locale_manager.bind('change', this.__kb._onLocaleChange);
    if (options.hasOwnProperty('default')) {
      observable = kb.DefaultObservable && ko.defaultObservable(observable, options["default"]);
    }
    return observable;
  }

  LocalizedObservable.prototype.destroy = function() {
    kb.locale_manager.unbind('change', this.__kb._onLocaleChange);
    this.vm = null;
    return kb.utils.wrappedDestroy(this);
  };

  LocalizedObservable.prototype.resetToCurrent = function() {
    var current_value, observable;

    observable = kb.utils.wrappedObservable(this);
    current_value = this.value ? this.read(_unwrapObservable(this.value)) : null;
    if (observable() === current_value) {
      return;
    }
    return observable(current_value);
  };

  LocalizedObservable.prototype.observedValue = function(value) {
    if (arguments.length === 0) {
      return this.value;
    }
    this.value = value;
    this._onLocaleChange();
  };

  LocalizedObservable.prototype._onLocaleChange = function() {
    var value;

    value = this.read(_unwrapObservable(this.value));
    this.vo(value);
    if (this.__kb._onChange) {
      return this.__kb._onChange(value);
    }
  };

  return LocalizedObservable;

})();

kb.localizedObservable = function(value, options, view_model) {
  return new kb.LocalizedObservable(value, options, view_model);
};

/*
  knockback-extensions.js (knockback-localization)
  (c) 2011-2013 Kevin Malakoff.
  Knockback.js is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
  Dependencies: Knockout.js, Backbone.js, and Underscore.js.
    Optional dependency: Backbone.ModelRef.js.
*/


kb.locale_manager = void 0;

/*
  knockback-triggered-observable.js 0.17.0
  (c) 2011-2013 Kevin Malakoff.
  Knockback.Observable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


kb.TriggeredObservable = (function() {
  function TriggeredObservable(emitter, event_selector) {
    var observable,
      _this = this;

    this.event_selector = event_selector;
    emitter || _throwMissing(this, 'emitter');
    this.event_selector || _throwMissing(this, 'event_selector');
    this.vo = ko.observable();
    observable = kb.utils.wrappedObservable(this, ko.dependentObservable(function() {
      return _this.vo();
    }));
    observable.destroy = _.bind(this.destroy, this);
    kb.utils.wrappedEventWatcher(this, new kb.EventWatcher(emitter, this, {
      emitter: _.bind(this.emitter, this),
      update: _.bind(this.update, this),
      event_selector: this.event_selector
    }));
    return observable;
  }

  TriggeredObservable.prototype.destroy = function() {
    return kb.utils.wrappedDestroy(this);
  };

  TriggeredObservable.prototype.emitter = function(new_emitter) {
    if ((arguments.length === 0) || (this.ee === new_emitter)) {
      return this.ee;
    }
    if ((this.ee = new_emitter)) {
      return this.update();
    }
  };

  TriggeredObservable.prototype.update = function() {
    if (!this.ee) {
      return;
    }
    if (this.vo() !== this.ee) {
      return this.vo(this.ee);
    } else {
      return this.vo.valueHasMutated();
    }
  };

  return TriggeredObservable;

})();

kb.triggeredObservable = function(emitter, event_selector) {
  return new kb.TriggeredObservable(emitter, event_selector);
};

/*
  knockback-validation.js 0.17.0
  (c) 2011-2013 Kevin Malakoff.
  Knockback.Observable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


callOrGet = function(value) {
  value = _unwrapObservable(value);
  if (typeof value === 'function') {
    return value.apply(null, Array.prototype.slice.call(arguments, 1));
  } else {
    return value;
  }
};

kb.Validation = (function() {
  function Validation() {}

  return Validation;

})();

kb.valueValidator = function(value, bindings, validation_options) {
  if (validation_options == null) {
    validation_options = {};
  }
  (validation_options && !(typeof validation_options === 'function')) || (validation_options = {});
  return ko.dependentObservable(function() {
    var active_index, current_value, disabled, identifier, identifier_index, priorities, results, validator;

    results = {
      $error_count: 0
    };
    current_value = _unwrapObservable(value);
    !('disable' in validation_options) || (disabled = callOrGet(validation_options.disable));
    !('enable' in validation_options) || (disabled = !callOrGet(validation_options.enable));
    priorities = validation_options.priorities || [];
    _.isArray(priorities) || (priorities = [priorities]);
    active_index = priorities.length + 1;
    for (identifier in bindings) {
      validator = bindings[identifier];
      results[identifier] = !disabled && callOrGet(validator, current_value);
      if (results[identifier]) {
        results.$error_count++;
        (identifier_index = _.indexOf(priorities, identifier) >= 0) || (identifier_index = priorities.length);
        if (results.$active_error && identifier_index < active_index) {
          results.$active_error = identifier;
          active_index = identifier_index;
        } else {
          results.$active_error || (results.$active_error = identifier, active_index = identifier_index);
        }
      }
    }
    results.$enabled = !disabled;
    results.$disable = !!disabled;
    results.$valid = results.$error_count === 0;
    return results;
  });
};

kb.inputValidator = function(view_model, el, validation_options) {
  var $input_el, bindings, identifier, input_name, options, result, type, validator, validators, _ref;

  if (validation_options == null) {
    validation_options = {};
  }
  (validation_options && !(typeof validation_options === 'function')) || (validation_options = {});
  validators = kb.valid;
  $input_el = $(el);
  if ((input_name = $input_el.attr('name')) && !_.isString(input_name)) {
    input_name = null;
  }
  if (!(bindings = $input_el.attr('data-bind'))) {
    return null;
  }
  options = (new Function("sc", "with(sc[0]) { return { " + bindings + " } }"))([view_model]);
  if (!(options && options.value)) {
    return null;
  }
  (!options.validation_options) || (_.defaults(options.validation_options, validation_options), validation_options = options.validation_options);
  bindings = {};
  (!validators[type = $input_el.attr('type')]) || (bindings[type] = validators[type]);
  (!$input_el.attr('required')) || (bindings.required = validators.required);
  if (options.validations) {
    _ref = options.validations;
    for (identifier in _ref) {
      validator = _ref[identifier];
      bindings[identifier] = validator;
    }
  }
  result = kb.valueValidator(options.value, bindings, validation_options);
  (!input_name && !validation_options.no_attach) || (view_model["$" + input_name] = result);
  return result;
};

kb.formValidator = function(view_model, el) {
  var $root_el, bindings, form_name, input_el, name, options, results, validation_options, validator, validators, _i, _len, _ref;

  results = {};
  validators = [];
  $root_el = $(el);
  if ((form_name = $root_el.attr('name')) && !_.isString(form_name)) {
    form_name = null;
  }
  if ((bindings = $root_el.attr('data-bind'))) {
    options = (new Function("sc", "with(sc[0]) { return { " + bindings + " } }"))([view_model]);
    validation_options = options.validation_options;
  }
  validation_options || (validation_options = {});
  validation_options.no_attach = !!form_name;
  _ref = $root_el.find('input');
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    input_el = _ref[_i];
    if (!(name = $(input_el).attr('name'))) {
      continue;
    }
    validator = kb.inputValidator(view_model, input_el, validation_options);
    !validator || validators.push(results[name] = validator);
  }
  results.$error_count = ko.dependentObservable(function() {
    var error_count, _j, _len1;

    error_count = 0;
    for (_j = 0, _len1 = validators.length; _j < _len1; _j++) {
      validator = validators[_j];
      error_count += validator().$error_count;
    }
    return error_count;
  });
  results.$valid = ko.dependentObservable(function() {
    return results.$error_count() === 0;
  });
  results.$enabled = ko.dependentObservable(function() {
    var enabled, _j, _len1;

    enabled = true;
    for (_j = 0, _len1 = validators.length; _j < _len1; _j++) {
      validator = validators[_j];
      enabled &= validator().$enabled;
    }
    return enabled;
  });
  results.$disabled = ko.dependentObservable(function() {
    return !results.$enabled();
  });
  if (form_name) {
    view_model["$" + form_name] = results;
  }
  return results;
};

/*
  knockback-validators.js 0.17.0
  (c) 2011-2013 Kevin Malakoff.
  Knockback.Observable is freely distributable under the MIT license.
  See the following for full license details:
    https://github.com/kmalakoff/knockback/blob/master/LICENSE
*/


URL_REGEXP = /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/;

EMAIL_REGEXP = /^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/;

NUMBER_REGEXP = /^\s*(\-|\+)?(\d+|(\d*(\.\d*)))\s*$/;

kb.valid = {
  required: function(value) {
    return !value;
  },
  url: function(value) {
    return !URL_REGEXP.test(value);
  },
  email: function(value) {
    return !EMAIL_REGEXP.test(value);
  },
  number: function(value) {
    return !NUMBER_REGEXP.test(value);
  }
};

kb.hasChangedFn = function(model) {
  var attributes, m;

  m = null;
  attributes = null;
  return function() {
    var current_model;

    if (m !== (current_model = _unwrapObservable(model))) {
      m = current_model;
      attributes = (m ? m.toJSON() : null);
      return false;
    }
    if (!(m && attributes)) {
      return false;
    }
    return !_.isEqual(m.toJSON(), attributes);
  };
};

kb.minLengthFn = function(length) {
  return function(value) {
    return !value || value.length < length;
  };
};

kb.uniqueValueFn = function(model, key, collection) {
  return function(value) {
    var c, k, m,
      _this = this;

    m = _unwrapObservable(model);
    k = _unwrapObservable(key);
    c = _unwrapObservable(collection);
    if (!(m && k && c)) {
      return false;
    }
    return !!_.find(c.models, function(test) {
      return (test !== m) && test.get(k) === value;
    });
  };
};

kb.untilTrueFn = function(stand_in, fn, model) {
  var was_true;

  was_true = false;
  if (model && ko.isObservable(model)) {
    model.subscribe(function() {
      return was_true = false;
    });
  }
  return function(value) {
    var f, result;

    if (!(f = _unwrapObservable(fn))) {
      return _unwrapObservable(stand_in);
    }
    was_true |= !!(result = f(_unwrapObservable(value)));
    return (was_true ? result : _unwrapObservable(stand_in));
  };
};

kb.untilFalseFn = function(stand_in, fn, model) {
  var was_false;

  was_false = false;
  if (model && ko.isObservable(model)) {
    model.subscribe(function() {
      return was_false = false;
    });
  }
  return function(value) {
    var f, result;

    if (!(f = _unwrapObservable(fn))) {
      return _unwrapObservable(stand_in);
    }
    was_false |= !(result = f(_unwrapObservable(value)));
    return (was_false ? result : _unwrapObservable(stand_in));
  };
};
; return kb;});
}).call(this);