from aces.materials  import Material
from aces.modify import get_unique_atoms
from ase import Atoms,Atom
from math import pi,sqrt,atan
import numpy as np
class structure(Material):
	def set_parameters(self):
		pass
	def setup(self):
		pass
	def lmp_structure(self):		
		col=self.unitcell(self.laty,self.latx)		
		col.set_pbc([self.xp,self.yp,self.zp])
		atoms=get_unique_atoms(col)
		cell=atoms.cell*self.bond
		atoms.set_cell(cell,scale_atoms=True)
		atoms.center()
		return atoms
		
	
	def unitcell(self,latx,laty):
		pos2=np.array([7.794450,13.500383,0.000000
,6.928400,12.000340,0.000000
,12.124700,13.000369,0.000000
,11.258650,13.500383,0.000000
,10.392600,13.000369,0.000000
,10.392600,12.000340,0.000000
,8.660500,13.000369,0.000000
,11.258650,14.500412,0.000000
,12.124700,12.000340,0.000000
,9.526550,14.500412,0.000000
,9.526550,13.500383,0.000000
,8.660500,12.000340,0.000000
,7.794450,14.500412,0.000000
,12.990750,13.500383,0.000000
,12.990750,14.500412,0.000000
,9.526550,11.500326,0.000000
,7.794450,11.500326,0.000000
,12.124700,10.000284,0.000000
,11.258650,11.500326,0.000000
,11.258650,10.500299,0.000000
,10.392600,21.000597,0.000000
,14.722850,19.500553,0.000000
,11.258650,20.500582,0.000000
,12.124700,18.000511,0.000000
,11.258650,19.500553,0.000000
,9.526550,19.500553,0.000000
,9.526550,20.500582,0.000000
,8.660500,18.000511,0.000000
,8.660500,19.000540,0.000000
,12.990750,19.500553,0.000000
,10.392600,18.000511,0.000000
,10.392600,19.000540,0.000000
,12.990750,20.500582,0.000000
,13.856800,18.000511,0.000000
,12.124700,19.000540,0.000000
,13.856800,19.000540,0.000000
,13.856800,16.000454,0.000000
,12.990750,17.500498,0.000000
,12.124700,15.000426,0.000000
,10.392600,16.000454,0.000000
,11.258650,16.500469,0.000000
,12.124700,16.000454,0.000000
,12.990750,16.500469,0.000000
,8.660500,15.000426,0.000000
,8.660500,16.000454,0.000000
,10.392600,15.000426,0.000000
,9.526550,16.500469,0.000000
,9.526550,17.500498,0.000000]).reshape(-1,3)/1.42*1.42
		pos1=[6.928400,13.000369,0.000000
			,7.794450,16.500469,0.000000]
		phi=pi/2-atan((pos1[4]-pos1[1])/(pos1[3]-pos1[0]))
		cbond=np.linalg.norm((pos1[4]-pos1[1],pos1[3]-pos1[0],0))
		dx=sqrt(3)*cbond;
		dy=3*cbond;
		atoms=Atoms()

		for i,coord in enumerate(pos2):
			ele=['C','N'][i<48]
			atom=Atom(ele,coord)
			atoms.append(atom)
		atoms.rotate('z',phi)
		atoms.set_cell([dx,dy,10.0])
		atoms=atoms.repeat((2,2,1))
		col=atoms.repeat((latx,laty,1))
		return col
		
			
		