# Copyright 2010 Boris Figovsky <borfig@gmail.com>
#
# This file is part of pybfc.

# pybfc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# pybfc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with pybfc.  If not, see <http://www.gnu.org/licenses/>.
"""
Immutable view of a (possibly mutable) sequence

>>> s = (1,2,3)
>>> i = Immutable(s)
>>> hash(i) == hash(s)
True
>>> len(i)
3
>>> i[1]
2
>>> 2 in i
True
>>> list(i)
[1, 2, 3]

"""

class Immutable(object):
    __slots__ = ['_seq']

    def __init__(self, seq):
        self._seq = seq

    def __iter__(self):
        return iter(self._seq)

    def __hash__(self):
        return hash(self._seq)

    def __getitem__(self, k):
        return self._seq[k]

    def __len__(self):
        return len(self._seq)

    def __contains__(self, x):
        return x in self._seq
