__author__ = 'Roy'

import logging

import cx_Oracle as odb
import pandas.io.sql as psql

logger = logging.getLogger(__name__)
logging.basicConfig(level=logging.DEBUG)


class OracleServerInfo:
    def __init__(self):
        self.name = ""
        self.sid = ""
        self.username = ""
        self.password = ""
        self.pandas = False

    def to_string(self):
        return self.name


class ORACLE:
    def __init__(self, server):
        self.conn_str = server.username + "/" + server.password + "@" + server.sid
        self.conn = None

    def get_conn(self):
        self.conn = odb.connect(self.conn_str)
        return self.conn

    def close_conn(self):
        self.conn.close()

    def query_pandas(self, query, *parameters):
        self.get_conn()
        try:
            return psql.read_sql(query, self.conn)
        except Exception as e:
            logger.error("ORACLE[%s] error code: %s, msg: %s", self.conn_name, str(e.args[0]), str(e.message))
            logger.error("query: %s", query)
            logger.error("parameters: %s", parameters)
        finally:
            self.close_conn()

    def query(self, query, *parameters):
        self.get_conn()
        cur = self.conn.cursor()
        try:
            return cur.execute(query)
        except Exception as e:
            logger.error("ORACLE[%s] error code: %s, msg: %s", self.conn_name, str(e.args[0]), str(e.message))
            logger.error("query: %s", query)
            logger.error("parameters: %s", parameters)
        finally:
            cur.close()
            self.close_conn()
