# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BMSPOQueryObject(Model):
    """Filters to list items that can be backed up.

    :param backup_management_type: Backup management type. Possible values
     include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM', 'AzureBackupServer',
     'AzureSql', 'AzureStorage', 'AzureWorkload', 'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param workload_type: Workload type. Possible values include: 'Invalid',
     'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange', 'Sharepoint',
     'VMwareVM', 'SystemState', 'Client', 'GenericDataSource', 'SQLDataBase',
     'AzureFileShare'
    :type workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.WorkloadType
    :param container_name: Full name of the container whose Protectable
     Objects should be returned.
    :type container_name: str
    :param status: Backup status query parameter.
    :type status: str
    :param friendly_name: Friendly name.
    :type friendly_name: str
    """

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'workload_type': {'key': 'workloadType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BMSPOQueryObject, self).__init__(**kwargs)
        self.backup_management_type = kwargs.get('backup_management_type', None)
        self.workload_type = kwargs.get('workload_type', None)
        self.container_name = kwargs.get('container_name', None)
        self.status = kwargs.get('status', None)
        self.friendly_name = kwargs.get('friendly_name', None)
