# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BMSContainerQueryObject(Model):
    """The query filters that can be used with the list containers API.

    All required parameters must be populated in order to send to Azure.

    :param backup_management_type: Required. Backup management type for this
     container. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB',
     'DPM', 'AzureBackupServer', 'AzureSql', 'AzureStorage', 'AzureWorkload',
     'DefaultBackup'
    :type backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupManagementType
    :param container_type: Type of container for filter. Possible values
     include: 'Invalid', 'Unknown', 'IaasVMContainer',
     'IaasVMServiceContainer', 'DPMContainer', 'AzureBackupServerContainer',
     'MABContainer', 'Cluster', 'AzureSqlContainer', 'Windows', 'VCenter',
     'VMAppContainer', 'SQLAGWorkLoadContainer', 'StorageContainer',
     'GenericContainer'
    :type container_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.ContainerType
    :param backup_engine_name: Backup engine name
    :type backup_engine_name: str
    :param fabric_name: Fabric name for filter
    :type fabric_name: str
    :param status: Status of registration of this container with the Recovery
     Services Vault.
    :type status: str
    :param friendly_name: Friendly name of this container.
    :type friendly_name: str
    """

    _validation = {
        'backup_management_type': {'required': True},
    }

    _attribute_map = {
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'container_type': {'key': 'containerType', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, *, backup_management_type, container_type=None, backup_engine_name: str=None, fabric_name: str=None, status: str=None, friendly_name: str=None, **kwargs) -> None:
        super(BMSContainerQueryObject, self).__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.container_type = container_type
        self.backup_engine_name = backup_engine_name
        self.fabric_name = fabric_name
        self.status = status
        self.friendly_name = friendly_name
