# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackupStatusRequest(Model):
    """BackupStatus request.

    :param resource_type: Container Type - VM, SQLPaaS, DPM, AzureFileShare.
     Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb',
     'SQLDB', 'Exchange', 'Sharepoint', 'VMwareVM', 'SystemState', 'Client',
     'GenericDataSource', 'SQLDataBase', 'AzureFileShare'
    :type resource_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.DataSourceType
    :param resource_id: Entire ARM resource id of the resource
    :type resource_id: str
    :param po_logical_name: Protectable Item Logical Name
    :type po_logical_name: str
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'po_logical_name': {'key': 'poLogicalName', 'type': 'str'},
    }

    def __init__(self, *, resource_type=None, resource_id: str=None, po_logical_name: str=None, **kwargs) -> None:
        super(BackupStatusRequest, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.po_logical_name = po_logical_name
