##############################################################################
#
# Copyright (c) 2010 Projekt01 GmbH.
# All Rights Reserved.
#
##############################################################################
"""setup

"""
__docformat__ = "reStructuredText"

import os
from setuptools import setup, find_packages

def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()

setup (
    name='p01.elasticsearch',
    version='0.5.2',
    author = "Roger Ineichen, Projekt01 GmbH",
    author_email = "dev@projekt01.ch",
    description = "Elasticsearch client for Zope3",
    long_description=(
        read('README.txt')
        + '\n\n' +
        read('src', 'p01', 'elasticsearch', 'README.txt')
        + '\n\n' +
        read('src', 'p01', 'elasticsearch', 'index.txt')
        + '\n\n' +
        read('src', 'p01', 'elasticsearch', 'mapping.txt')
        + '\n\n' +
        read('src', 'p01', 'elasticsearch', 'scan.txt')
        + '\n\n' +
        read('src', 'p01', 'elasticsearch', 'bulk.txt')
        + '\n\n' +
        read('src', 'p01', 'elasticsearch', 'simple.txt')
        + '\n\n' +
        read('CHANGES.txt')
        ),
    license = "ZPL 2.1",
    keywords = "Zope3 z3c p01 elasticsearch client",
    classifiers = [
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Zope Public License',
        'Programming Language :: Python',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Topic :: Internet :: WWW/HTTP',
        'Framework :: Zope3'],
    url = 'http://pypi.python.org/pypi/p01.elasticsearch',
    packages = find_packages('src'),
    include_package_data = True,
    package_dir = {'':'src'},
    namespace_packages = ['p01'],
    extras_require=dict(
        test=[
            'zope.testing',
            'p01.elasticstub',
            
        ]),
    install_requires = [
        'setuptools',
        'zope.interface',
        'zope.schema',
        'thrift',
        ],
    zip_safe = False,
    )
