'''
--------------------------------------------------------------------------------

    leapp_compiler.py

--------------------------------------------------------------------------------
Copyright 2013, 2014 Pierre Denis

This file is part of Lea.

Lea is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Lea is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with Lea.  If not, see <http://www.gnu.org/licenses/>.
--------------------------------------------------------------------------------
'''

import license
from leapp_translator import LeappTranslator
from toolbox import inputFunc

PY_FILE_HEADER = '''
# ----------------------------------------------------------------------------- 
# %s
# ----------------------------------------------------------------------------- 
# file generated by leapp %s, from compilation of %s
# WARNING: any update will be overwritten at next generation!
# ----------------------------------------------------------------------------- 

'''[1:]

import os
try:
    # try to activate terminal history 
    import readline
except:
    # OS dependent failure -> no terminal history
    pass            

class LeappCompiler(object):
    
    ''' 
    LeappCompiler provides static methods to compile source leapp files into
    Python files (.py). Alternatively, the generated Python code can be directly
    executed, without being dumped in a .py file
    '''

    @staticmethod
    def compileLeaFile(leaFilename):
        f = open(leaFilename)
        leaMultilineStatement = f.read()
        f.close()
        pMultilineStatement = 'from lea import *\n\n'
        pMultilineStatement += LeappTranslator.getTarget00(leaMultilineStatement)
        return pMultilineStatement

    @staticmethod
    def execPythonStatement(pStatement,leaFilename):
        code = compile(pStatement+'\n',leaFilename,'exec')
        exec(code)
            
    @staticmethod
    def compileAndExecLeaFile(leaFilename):
        pMultilineStatement = LeappCompiler.compileLeaFile(leaFilename)
        LeappCompiler.execPythonStatement(pMultilineStatement,leaFilename)

    @staticmethod
    def compileAndWriteLeaFile(leaFilename,force=False):
        pMultilineStatement = LeappCompiler.compileLeaFile(leaFilename)
        pythonFilename = os.path.splitext(leaFilename)[0] + '.py'
        if force or not os.path.exists(pythonFilename):
            canWrite = True
        else:
            res = inputFunc("overwrite %s (y/n)? "%pythonFilename)
            canWrite = res.strip().lower() == 'y'
        if canWrite:         
            pMultilineStatement = PY_FILE_HEADER%(pythonFilename,license.VER,leaFilename) + pMultilineStatement
            f = open(pythonFilename,'w')
            f.write(pMultilineStatement)
            f.close()
            print("'%s' written"%pythonFilename)
