#pragma once

namespace OpenGL {

	#ifdef _WIN64
		typedef long long int GLsizeiptr;
		typedef long long int GLintptr;
	#else
		typedef int GLsizeiptr;
		typedef int GLintptr;
	#endif 

	typedef char GLchar;
	typedef float GLfloat;
	typedef int GLint;
	typedef int GLsizei;
	typedef unsigned char GLboolean;
	typedef unsigned char GLubyte;
	typedef unsigned int GLbitfield;
	typedef unsigned int GLenum;
	typedef unsigned int GLuint;
	typedef void GLvoid;

	const GLenum GL_DEPTH_BUFFER_BIT                   = 0x0100;
	const GLenum GL_COLOR_BUFFER_BIT                   = 0x4000;
	const GLenum GL_FALSE                              = 0x0000;
	const GLenum GL_TRUE                               = 0x0001;
	const GLenum GL_POINTS                             = 0x0000;
	const GLenum GL_LINES                              = 0x0001;
	const GLenum GL_LINE_LOOP                          = 0x0002;
	const GLenum GL_LINE_STRIP                         = 0x0003;
	const GLenum GL_TRIANGLES                          = 0x0004;
	const GLenum GL_TRIANGLE_STRIP                     = 0x0005;
	const GLenum GL_TRIANGLE_FAN                       = 0x0006;
	const GLenum GL_SRC_ALPHA                          = 0x0302;
	const GLenum GL_ONE_MINUS_SRC_ALPHA                = 0x0303;
	const GLenum GL_NO_ERROR                           = 0x0000;
	const GLenum GL_INVALID_ENUM                       = 0x0500;
	const GLenum GL_INVALID_VALUE                      = 0x0501;
	const GLenum GL_INVALID_OPERATION                  = 0x0502;
	const GLenum GL_OUT_OF_MEMORY                      = 0x0505;
	const GLenum GL_CULL_FACE                          = 0x0B44;
	const GLenum GL_DEPTH_TEST                         = 0x0B71;
	const GLenum GL_VIEWPORT                           = 0x0BA2;
	const GLenum GL_BLEND                              = 0x0BE2;
	const GLenum GL_TEXTURE_2D                         = 0x0DE1;
	const GLenum GL_UNSIGNED_BYTE                      = 0x1401;
	const GLenum GL_INT                                = 0x1404;
	const GLenum GL_UNSIGNED_INT                       = 0x1405;
	const GLenum GL_FLOAT                              = 0x1406;
	const GLenum GL_STACK_OVERFLOW                     = 0x0503;
	const GLenum GL_STACK_UNDERFLOW                    = 0x0504;
	const GLenum GL_DEPTH_COMPONENT                    = 0x1902;
	const GLenum GL_RED                                = 0x1903;
	const GLenum GL_RGB                                = 0x1907;
	const GLenum GL_RGBA                               = 0x1908;
	const GLenum GL_VENDOR                             = 0x1F00;
	const GLenum GL_RENDERER                           = 0x1F01;
	const GLenum GL_EXTENSIONS                         = 0x1F03;
	const GLenum GL_NEAREST                            = 0x2600;
	const GLenum GL_LINEAR                             = 0x2601;
	const GLenum GL_LINEAR_MIPMAP_LINEAR               = 0x2703;
	const GLenum GL_TEXTURE_MAG_FILTER                 = 0x2800;
	const GLenum GL_TEXTURE_MIN_FILTER                 = 0x2801;
	const GLenum GL_TEXTURE_BASE_LEVEL                 = 0x813C;
	const GLenum GL_TEXTURE_MAX_LEVEL                  = 0x813D;
	const GLenum GL_TEXTURE0                           = 0x84C0;
	const GLenum GL_MULTISAMPLE                        = 0x809D;
	const GLenum GL_ARRAY_BUFFER                       = 0x8892;
	const GLenum GL_ELEMENT_ARRAY_BUFFER               = 0x8893;
	const GLenum GL_READ_ONLY                          = 0x88B8;
	const GLenum GL_STATIC_DRAW                        = 0x88E4;
	const GLenum GL_DYNAMIC_DRAW                       = 0x88E8;
	const GLenum GL_MAX_TEXTURE_IMAGE_UNITS            = 0x8872;
	const GLenum GL_FRAGMENT_SHADER                    = 0x8B30;
	const GLenum GL_VERTEX_SHADER                      = 0x8B31;
	const GLenum GL_COMPILE_STATUS                     = 0x8B81;
	const GLenum GL_LINK_STATUS                        = 0x8B82;
	const GLenum GL_CURRENT_PROGRAM                    = 0x8B8D;
	const GLenum GL_MAJOR_VERSION                      = 0x821B;
	const GLenum GL_MINOR_VERSION                      = 0x821C;
	const GLenum GL_NUM_EXTENSIONS                     = 0x821D;
	const GLenum GL_INVALID_FRAMEBUFFER_OPERATION      = 0x0506;
	const GLenum GL_DRAW_FRAMEBUFFER_BINDING           = 0x8CA6;
	const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1;
	const GLenum GL_COLOR_ATTACHMENT0                  = 0x8CE0;
	const GLenum GL_DEPTH_ATTACHMENT                   = 0x8D00;
	const GLenum GL_FRAMEBUFFER                        = 0x8D40;
	const GLenum GL_MAX_SAMPLES                        = 0x8D57;
	const GLenum GL_RG                                 = 0x8227;
	const GLenum GL_PRIMITIVE_RESTART                  = 0x8F9D;
	const GLenum GL_UNIFORM_BUFFER                     = 0x8A11;
	const GLenum GL_LINES_ADJACENCY                    = 0x000A;
	const GLenum GL_LINE_STRIP_ADJACENCY               = 0x000B;
	const GLenum GL_TRIANGLES_ADJACENCY                = 0x000C;
	const GLenum GL_TRIANGLE_STRIP_ADJACENCY           = 0x000D;
	const GLenum GL_GEOMETRY_SHADER                    = 0x8DD9;
	const GLenum GL_TEXTURE_2D_MULTISAMPLE             = 0x9100;
	const GLenum GL_TESS_EVALUATION_SHADER             = 0x8E87;
	const GLenum GL_TESS_CONTROL_SHADER                = 0x8E88;
	const GLenum GL_PRIMITIVE_RESTART_FIXED_INDEX      = 0x8D69;
	const GLenum GL_COMPUTE_SHADER                     = 0x91B9;
	const GLenum GL_SHADER_STORAGE_BUFFER              = 0x90D2;
	const GLenum GL_MAP_READ_BIT                       = 0x0001;
	const GLenum GL_READ_WRITE                         = 0x88BA;
	const GLenum GL_RGBA8UI                            = 0x8D7C;
	const GLenum GL_RGB8UI                             = 0x8D7D;
	const GLenum GL_RG8UI                              = 0x8238;
	const GLenum GL_R8UI                               = 0x8232;


	bool __stdcall InitializeOpenGL();

	typedef GLvoid (__stdcall * PROC_glLineWidth)(GLfloat width);
	typedef GLvoid (__stdcall * PROC_glPointSize)(GLfloat size);
	typedef GLvoid (__stdcall * PROC_glTexParameteri)(GLenum target, GLenum pname, GLint param);
	typedef GLvoid (__stdcall * PROC_glTexImage2D)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (__stdcall * PROC_glTexSubImage2D)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels);
	typedef GLvoid (__stdcall * PROC_glClear)(GLbitfield mask);
	typedef GLvoid (__stdcall * PROC_glClearColor)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
	typedef GLvoid (__stdcall * PROC_glDisable)(GLenum cap);
	typedef GLvoid (__stdcall * PROC_glEnable)(GLenum cap);
	typedef GLvoid (__stdcall * PROC_glBlendFunc)(GLenum sfactor, GLenum dfactor);
	typedef GLvoid (__stdcall * PROC_glReadPixels)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels);
	typedef GLenum (__stdcall * PROC_glGetError)();
	typedef GLvoid (__stdcall * PROC_glGetIntegerv)(GLenum pname, GLint * data);
	typedef const GLubyte * (__stdcall * PROC_glGetString)(GLenum name);
	typedef const GLubyte * (__stdcall * PROC_glGetStringi)(GLenum name, GLuint index);
	typedef GLvoid (__stdcall * PROC_glViewport)(GLint x, GLint y, GLsizei width, GLsizei height);
	typedef GLvoid (__stdcall * PROC_glBindTexture)(GLenum target, GLuint texture);
	typedef GLvoid (__stdcall * PROC_glDeleteTextures)(GLsizei n, const GLuint * textures);
	typedef GLvoid (__stdcall * PROC_glGenTextures)(GLsizei n, GLuint * textures);
	typedef GLvoid (__stdcall * PROC_glActiveTexture)(GLenum texture);
	typedef GLvoid (__stdcall * PROC_glBindBuffer)(GLenum target, GLuint buffer);
	typedef GLvoid (__stdcall * PROC_glDeleteBuffers)(GLsizei n, const GLuint * buffers);
	typedef GLvoid (__stdcall * PROC_glGenBuffers)(GLsizei n, GLuint * buffers);
	typedef GLvoid (__stdcall * PROC_glBufferData)(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage);
	typedef GLvoid (__stdcall * PROC_glBufferSubData)(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data);
	typedef GLboolean (__stdcall * PROC_glUnmapBuffer)(GLenum target);
	typedef GLvoid (__stdcall * PROC_glAttachShader)(GLuint program, GLuint shader);
	typedef GLvoid (__stdcall * PROC_glCompileShader)(GLuint shader);
	typedef GLuint (__stdcall * PROC_glCreateProgram)();
	typedef GLuint (__stdcall * PROC_glCreateShader)(GLenum type);
	typedef GLvoid (__stdcall * PROC_glDeleteProgram)(GLuint program);
	typedef GLvoid (__stdcall * PROC_glDeleteShader)(GLuint shader);
	typedef GLvoid (__stdcall * PROC_glDisableVertexAttribArray)(GLuint index);
	typedef GLvoid (__stdcall * PROC_glEnableVertexAttribArray)(GLuint index);
	typedef GLvoid (__stdcall * PROC_glGetAttachedShaders)(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders);
	typedef GLint (__stdcall * PROC_glGetAttribLocation)(GLuint program, const GLchar * name);
	typedef GLvoid (__stdcall * PROC_glGetProgramiv)(GLuint program, GLenum pname, GLint * params);
	typedef GLvoid (__stdcall * PROC_glGetProgramInfoLog)(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
	typedef GLvoid (__stdcall * PROC_glGetShaderiv)(GLuint shader, GLenum pname, GLint * params);
	typedef GLvoid (__stdcall * PROC_glGetShaderInfoLog)(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
	typedef GLint (__stdcall * PROC_glGetUniformLocation)(GLuint program, const GLchar * name);
	typedef GLvoid (__stdcall * PROC_glLinkProgram)(GLuint program);
	typedef GLvoid (__stdcall * PROC_glShaderSource)(GLuint shader, GLsizei count, const GLchar * const * string, const GLint * length);
	typedef GLvoid (__stdcall * PROC_glUseProgram)(GLuint program);
	typedef GLvoid (__stdcall * PROC_glUniform1f)(GLint location, GLfloat v0);
	typedef GLvoid (__stdcall * PROC_glUniform2f)(GLint location, GLfloat v0, GLfloat v1);
	typedef GLvoid (__stdcall * PROC_glUniform3f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
	typedef GLvoid (__stdcall * PROC_glUniform4f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
	typedef GLvoid (__stdcall * PROC_glUniform1i)(GLint location, GLint v0);
	typedef GLvoid (__stdcall * PROC_glUniform2i)(GLint location, GLint v0, GLint v1);
	typedef GLvoid (__stdcall * PROC_glUniform3i)(GLint location, GLint v0, GLint v1, GLint v2);
	typedef GLvoid (__stdcall * PROC_glUniform4i)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
	typedef GLvoid (__stdcall * PROC_glUniformMatrix4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
	typedef GLvoid (__stdcall * PROC_glVertexAttribPointer)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer);
	typedef GLvoid (__stdcall * PROC_glBindBufferBase)(GLenum target, GLuint index, GLuint buffer);
	typedef GLvoid (__stdcall * PROC_glBindFramebuffer)(GLenum target, GLuint framebuffer);
	typedef GLvoid (__stdcall * PROC_glDeleteFramebuffers)(GLsizei n, const GLuint * framebuffers);
	typedef GLvoid (__stdcall * PROC_glGenFramebuffers)(GLsizei n, GLuint * framebuffers);
	typedef GLvoid (__stdcall * PROC_glFramebufferTexture2D)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
	typedef GLvoid (__stdcall * PROC_glGetFramebufferAttachmentParameteriv)(GLenum target, GLenum attachment, GLenum pname, GLint * params);
	typedef GLvoid (__stdcall * PROC_glGenerateMipmap)(GLenum target);
	typedef GLvoid * (__stdcall * PROC_glMapBufferRange)(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
	typedef GLvoid (__stdcall * PROC_glBindVertexArray)(GLuint array);
	typedef GLvoid (__stdcall * PROC_glDeleteVertexArrays)(GLsizei n, const GLuint * arrays);
	typedef GLvoid (__stdcall * PROC_glGenVertexArrays)(GLsizei n, GLuint * arrays);
	typedef GLvoid (__stdcall * PROC_glDrawArraysInstanced)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount);
	typedef GLvoid (__stdcall * PROC_glDrawElementsInstanced)(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei instancecount);
	typedef GLvoid (__stdcall * PROC_glPrimitiveRestartIndex)(GLuint index);
	typedef GLuint (__stdcall * PROC_glGetUniformBlockIndex)(GLuint program, const GLchar * uniformBlockName);
	typedef GLvoid (__stdcall * PROC_glBindImageTexture)(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
	typedef GLvoid (__stdcall * PROC_glDispatchCompute)(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
	
	extern PROC_glLineWidth glLineWidth;
	extern PROC_glPointSize glPointSize;
	extern PROC_glTexParameteri glTexParameteri;
	extern PROC_glTexImage2D glTexImage2D;
	extern PROC_glTexSubImage2D glTexSubImage2D;
	extern PROC_glClear glClear;
	extern PROC_glClearColor glClearColor;
	extern PROC_glDisable glDisable;
	extern PROC_glEnable glEnable;
	extern PROC_glBlendFunc glBlendFunc;
	extern PROC_glReadPixels glReadPixels;
	extern PROC_glGetError glGetError;
	extern PROC_glGetIntegerv glGetIntegerv;
	extern PROC_glGetString glGetString;
	extern PROC_glGetStringi glGetStringi;
	extern PROC_glViewport glViewport;
	extern PROC_glBindTexture glBindTexture;
	extern PROC_glDeleteTextures glDeleteTextures;
	extern PROC_glGenTextures glGenTextures;
	extern PROC_glActiveTexture glActiveTexture;
	extern PROC_glBindBuffer glBindBuffer;
	extern PROC_glDeleteBuffers glDeleteBuffers;
	extern PROC_glGenBuffers glGenBuffers;
	extern PROC_glBufferData glBufferData;
	extern PROC_glBufferSubData glBufferSubData;
	extern PROC_glUnmapBuffer glUnmapBuffer;
	extern PROC_glAttachShader glAttachShader;
	extern PROC_glCompileShader glCompileShader;
	extern PROC_glCreateProgram glCreateProgram;
	extern PROC_glCreateShader glCreateShader;
	extern PROC_glDeleteProgram glDeleteProgram;
	extern PROC_glDeleteShader glDeleteShader;
	extern PROC_glDisableVertexAttribArray glDisableVertexAttribArray;
	extern PROC_glEnableVertexAttribArray glEnableVertexAttribArray;
	extern PROC_glGetAttachedShaders glGetAttachedShaders;
	extern PROC_glGetAttribLocation glGetAttribLocation;
	extern PROC_glGetProgramiv glGetProgramiv;
	extern PROC_glGetProgramInfoLog glGetProgramInfoLog;
	extern PROC_glGetShaderiv glGetShaderiv;
	extern PROC_glGetShaderInfoLog glGetShaderInfoLog;
	extern PROC_glGetUniformLocation glGetUniformLocation;
	extern PROC_glLinkProgram glLinkProgram;
	extern PROC_glShaderSource glShaderSource;
	extern PROC_glUseProgram glUseProgram;
	extern PROC_glUniform1f glUniform1f;
	extern PROC_glUniform2f glUniform2f;
	extern PROC_glUniform3f glUniform3f;
	extern PROC_glUniform4f glUniform4f;
	extern PROC_glUniform1i glUniform1i;
	extern PROC_glUniform2i glUniform2i;
	extern PROC_glUniform3i glUniform3i;
	extern PROC_glUniform4i glUniform4i;
	extern PROC_glUniformMatrix4fv glUniformMatrix4fv;
	extern PROC_glVertexAttribPointer glVertexAttribPointer;
	extern PROC_glBindBufferBase glBindBufferBase;
	extern PROC_glBindFramebuffer glBindFramebuffer;
	extern PROC_glDeleteFramebuffers glDeleteFramebuffers;
	extern PROC_glGenFramebuffers glGenFramebuffers;
	extern PROC_glFramebufferTexture2D glFramebufferTexture2D;
	extern PROC_glGetFramebufferAttachmentParameteriv glGetFramebufferAttachmentParameteriv;
	extern PROC_glGenerateMipmap glGenerateMipmap;
	extern PROC_glMapBufferRange glMapBufferRange;
	extern PROC_glBindVertexArray glBindVertexArray;
	extern PROC_glDeleteVertexArrays glDeleteVertexArrays;
	extern PROC_glGenVertexArrays glGenVertexArrays;
	extern PROC_glDrawArraysInstanced glDrawArraysInstanced;
	extern PROC_glDrawElementsInstanced glDrawElementsInstanced;
	extern PROC_glPrimitiveRestartIndex glPrimitiveRestartIndex;
	extern PROC_glGetUniformBlockIndex glGetUniformBlockIndex;
	extern PROC_glBindImageTexture glBindImageTexture;
	extern PROC_glDispatchCompute glDispatchCompute;

	extern bool __stdcall isglLineWidth();
	extern bool __stdcall isglPointSize();
	extern bool __stdcall isglTexParameteri();
	extern bool __stdcall isglTexImage2D();
	extern bool __stdcall isglTexSubImage2D();
	extern bool __stdcall isglClear();
	extern bool __stdcall isglClearColor();
	extern bool __stdcall isglDisable();
	extern bool __stdcall isglEnable();
	extern bool __stdcall isglBlendFunc();
	extern bool __stdcall isglReadPixels();
	extern bool __stdcall isglGetError();
	extern bool __stdcall isglGetIntegerv();
	extern bool __stdcall isglGetString();
	extern bool __stdcall isglGetStringi();
	extern bool __stdcall isglViewport();
	extern bool __stdcall isglBindTexture();
	extern bool __stdcall isglDeleteTextures();
	extern bool __stdcall isglGenTextures();
	extern bool __stdcall isglActiveTexture();
	extern bool __stdcall isglBindBuffer();
	extern bool __stdcall isglDeleteBuffers();
	extern bool __stdcall isglGenBuffers();
	extern bool __stdcall isglBufferData();
	extern bool __stdcall isglBufferSubData();
	extern bool __stdcall isglUnmapBuffer();
	extern bool __stdcall isglAttachShader();
	extern bool __stdcall isglCompileShader();
	extern bool __stdcall isglCreateProgram();
	extern bool __stdcall isglCreateShader();
	extern bool __stdcall isglDeleteProgram();
	extern bool __stdcall isglDeleteShader();
	extern bool __stdcall isglDisableVertexAttribArray();
	extern bool __stdcall isglEnableVertexAttribArray();
	extern bool __stdcall isglGetAttachedShaders();
	extern bool __stdcall isglGetAttribLocation();
	extern bool __stdcall isglGetProgramiv();
	extern bool __stdcall isglGetProgramInfoLog();
	extern bool __stdcall isglGetShaderiv();
	extern bool __stdcall isglGetShaderInfoLog();
	extern bool __stdcall isglGetUniformLocation();
	extern bool __stdcall isglLinkProgram();
	extern bool __stdcall isglShaderSource();
	extern bool __stdcall isglUseProgram();
	extern bool __stdcall isglUniform1f();
	extern bool __stdcall isglUniform2f();
	extern bool __stdcall isglUniform3f();
	extern bool __stdcall isglUniform4f();
	extern bool __stdcall isglUniform1i();
	extern bool __stdcall isglUniform2i();
	extern bool __stdcall isglUniform3i();
	extern bool __stdcall isglUniform4i();
	extern bool __stdcall isglUniformMatrix4fv();
	extern bool __stdcall isglVertexAttribPointer();
	extern bool __stdcall isglBindBufferBase();
	extern bool __stdcall isglBindFramebuffer();
	extern bool __stdcall isglDeleteFramebuffers();
	extern bool __stdcall isglGenFramebuffers();
	extern bool __stdcall isglFramebufferTexture2D();
	extern bool __stdcall isglGetFramebufferAttachmentParameteriv();
	extern bool __stdcall isglGenerateMipmap();
	extern bool __stdcall isglMapBufferRange();
	extern bool __stdcall isglBindVertexArray();
	extern bool __stdcall isglDeleteVertexArrays();
	extern bool __stdcall isglGenVertexArrays();
	extern bool __stdcall isglDrawArraysInstanced();
	extern bool __stdcall isglDrawElementsInstanced();
	extern bool __stdcall isglPrimitiveRestartIndex();
	extern bool __stdcall isglGetUniformBlockIndex();
	extern bool __stdcall isglBindImageTexture();
	extern bool __stdcall isglDispatchCompute();

}
