/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.discovery.tools.DiscoverClass;
import org.apache.commons.math.stat.descriptive.DescriptiveStatisticsImpl;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.Skewness;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.apache.commons.math.stat.descriptive.rank.Max;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.apache.commons.math.stat.descriptive.rank.Percentile;
import org.apache.commons.math.stat.descriptive.summary.Sum;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;

public abstract class DescriptiveStatistics
implements StatisticalSummary,
Serializable {
    private static final long serialVersionUID = 5188298269533339922L;
    public static final int INFINITE_WINDOW = -1;

    public static DescriptiveStatistics newInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return (DescriptiveStatistics)clazz.newInstance();
    }

    public static DescriptiveStatistics newInstance() {
        DescriptiveStatistics descriptiveStatistics = null;
        try {
            DiscoverClass discoverClass = new DiscoverClass();
            descriptiveStatistics = (DescriptiveStatistics)discoverClass.newInstance(DescriptiveStatistics.class, "org.apache.commons.math.stat.descriptive.DescriptiveStatisticsImpl");
        }
        catch (Throwable throwable) {
            return new DescriptiveStatisticsImpl();
        }
        return descriptiveStatistics;
    }

    public abstract void addValue(double var1);

    public double getMean() {
        return this.apply(new Mean());
    }

    public double getGeometricMean() {
        return this.apply(new GeometricMean());
    }

    public double getVariance() {
        return this.apply(new Variance());
    }

    public double getStandardDeviation() {
        double d = Double.NaN;
        if (this.getN() > 0L) {
            d = this.getN() > 1L ? Math.sqrt(this.getVariance()) : 0.0;
        }
        return d;
    }

    public double getSkewness() {
        return this.apply(new Skewness());
    }

    public double getKurtosis() {
        return this.apply(new Kurtosis());
    }

    public double getMax() {
        return this.apply(new Max());
    }

    public double getMin() {
        return this.apply(new Min());
    }

    public abstract long getN();

    public double getSum() {
        return this.apply(new Sum());
    }

    public double getSumsq() {
        return this.apply(new SumOfSquares());
    }

    public abstract void clear();

    public abstract int getWindowSize();

    public abstract void setWindowSize(int var1);

    public abstract double[] getValues();

    public double[] getSortedValues() {
        double[] dArray = this.getValues();
        Arrays.sort(dArray);
        return dArray;
    }

    public abstract double getElement(int var1);

    public double getPercentile(double d) {
        return this.apply(new Percentile(d));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DescriptiveStatistics:\n");
        stringBuffer.append("n: " + this.getN() + "\n");
        stringBuffer.append("min: " + this.getMin() + "\n");
        stringBuffer.append("max: " + this.getMax() + "\n");
        stringBuffer.append("mean: " + this.getMean() + "\n");
        stringBuffer.append("std dev: " + this.getStandardDeviation() + "\n");
        stringBuffer.append("median: " + this.getPercentile(50.0) + "\n");
        stringBuffer.append("skewness: " + this.getSkewness() + "\n");
        stringBuffer.append("kurtosis: " + this.getKurtosis() + "\n");
        return stringBuffer.toString();
    }

    public abstract double apply(UnivariateStatistic var1);
}

