/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import net.alomax.io.GeneralInputStream;
import net.alomax.swing.ApplicationJComp;
import net.alomax.util.StringExt;

public class ApplicationProperties
extends Properties {
    public ApplicationProperties() {
        this(true);
    }

    public ApplicationProperties(boolean bl) {
        if (bl) {
            try {
                this.putAll((Map<?, ?>)System.getProperties());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getProperty(String string) {
        String string2 = super.getProperty(string);
        if (string2 == null) {
            string2 = super.getProperty(StringExt.replace(string, ".", ""));
        }
        return string2;
    }

    public boolean loadFile(String string) {
        if (this.loadURLFile(string)) {
            return true;
        }
        if (this.loadFileFromClasspath(string)) {
            return true;
        }
        if (this.loadFileFromClasspath("." + string)) {
            return true;
        }
        if (this.loadFileFromUserHome(string)) {
            return true;
        }
        if (this.loadFileFromUserHome("." + string)) {
            return true;
        }
        if (this.loadFileFromUserDirectory(string)) {
            return true;
        }
        if (this.loadFileFromUserDirectory("." + string)) {
            return true;
        }
        if (this.loadFileFromName(string)) {
            return true;
        }
        return this.loadFileFromName("." + string);
    }

    public boolean loadFileFromName(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.load(new BufferedInputStream(fileInputStream));
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean loadFileFromUserDirectory(String string) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(System.getProperty("user.dir") + System.getProperty("file.separator") + string);
            this.load(new BufferedInputStream(inputStream));
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean loadFileFromUserHome(String string) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(System.getProperty("user.home") + System.getProperty("file.separator") + string);
            this.load(new BufferedInputStream(inputStream));
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean loadFileFromClasspath(String string) {
        InputStream inputStream;
        block7: {
            inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) break block7;
                this.load(new BufferedInputStream(inputStream));
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean loadURLFile(String string) {
        InputStream inputStream = null;
        try {
            inputStream = GeneralInputStream.openStream(null, string, true);
            this.load(new BufferedInputStream(inputStream));
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePropertiesToUserHome(String string, String string2, String string3, String[][] stringArray) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        String string4 = System.getProperty("user.home") + System.getProperty("file.separator") + "." + string;
        try {
            fileInputStream = new FileInputStream(string4);
            properties.load(new BufferedInputStream(fileInputStream));
        }
        catch (Exception exception) {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            string4 = System.getProperty("user.home") + System.getProperty("file.separator") + string;
            try {
                fileInputStream = new FileInputStream(string4);
                properties.load(new BufferedInputStream(fileInputStream));
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {}
        }
        for (int i = 0; i < stringArray.length; ++i) {
            properties.put(string3 + stringArray[i][0], stringArray[i][1]);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string4);
            properties.save(new BufferedOutputStream(fileOutputStream), string2);
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean getTrueFalseParameter(boolean bl, String string) {
        String string2 = this.getProperty(string);
        return ApplicationProperties.evaluateTrueFalseParameter(string2, bl);
    }

    public static boolean getTrueFalseParameter(ApplicationJComp applicationJComp, boolean bl, String string) {
        String string2 = applicationJComp.getParameter(string);
        return ApplicationProperties.evaluateTrueFalseParameter(string2, bl);
    }

    public static boolean evaluateTrueFalseParameter(String string, boolean bl) {
        if (string != null) {
            if (string.toUpperCase().indexOf("YES") >= 0 || string.toUpperCase().equals("Y") || string.toUpperCase().indexOf("TRUE") >= 0 || string.toUpperCase().indexOf("ON") >= 0 || string.toUpperCase().indexOf("1") >= 0) {
                return true;
            }
            if (string.toUpperCase().indexOf("NO") >= 0 || string.toUpperCase().equals("N") || string.toUpperCase().indexOf("FALSE") >= 0 || string.toUpperCase().indexOf("OFF") >= 0 || string.toUpperCase().indexOf("0") >= 0) {
                return false;
            }
        }
        return bl;
    }
}

