/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.BasicPicker;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainText;

public class TestPicker3
extends BasicPicker {
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    public double longTermWindow = 10.0;
    public double threshold1 = 10.0;
    public double threshold2 = 10.0;
    public double tUpEvent = 1.0;
    public double filterWindow = 2.0;
    public String errorMessage;
    private static final double THRESHOLD_MIN = Double.MIN_VALUE;
    private static final double THRESHOLD_MAX = Double.MAX_VALUE;
    private static final double TIME_MIN = -1.7976931348623157E308;
    private static final double TIME_MAX = Double.MAX_VALUE;
    private static final int INT_UNSET = -1073741823;
    private TestPicker3_Memory mem = null;
    private double deltaTime;

    public TestPicker3(String string, double d, double d2, double d3, double d4, double d5, int n) {
        super(string, n);
        this.longTermWindow = d;
        this.threshold1 = d2;
        this.threshold2 = d3;
        this.tUpEvent = d4;
        this.filterWindow = d5;
    }

    public TestPicker3(TestPicker3 testPicker3) {
        super(testPicker3.direction);
        this.resultType = testPicker3.resultType;
        this.longTermWindow = testPicker3.longTermWindow;
        this.threshold1 = testPicker3.threshold1;
        this.threshold2 = testPicker3.threshold2;
        this.tUpEvent = testPicker3.tUpEvent;
        this.filterWindow = testPicker3.filterWindow;
    }

    public void setLongTermWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + d);
        }
        this.longTermWindow = d;
    }

    public void setLongTermWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + string);
        }
        this.setLongTermWindow(d);
    }

    public void setThreshold1(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + d);
        }
        this.threshold1 = d;
    }

    public void setThreshold1(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + string);
        }
        this.setThreshold1(d);
    }

    public void setThreshold2(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + d);
        }
        this.threshold2 = d;
    }

    public void setThreshold2(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + string);
        }
        this.setThreshold2(d);
    }

    public void setTUpEvent(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + d);
        }
        this.tUpEvent = d;
    }

    public void setTUpEvent(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + string);
        }
        this.setTUpEvent(d);
    }

    public void setMeanWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_meanWindow_value + ": " + d);
        }
        this.filterWindow = d;
    }

    public void setMeanWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_meanWindow_value + ": " + string);
        }
        this.setMeanWindow(d);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String string = "";
        int n = 0;
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_long_term_window_value;
            ++n;
        }
        if (this.threshold1 < Double.MIN_VALUE || this.threshold1 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold1_value;
            ++n;
        }
        if (this.threshold2 < Double.MIN_VALUE || this.threshold2 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold2_value;
            ++n;
        }
        if (this.tUpEvent < -1.7976931348623157E308 || this.tUpEvent > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_tUpEvent_value;
            ++n;
        }
        if (this.filterWindow < -1.7976931348623157E308 || this.filterWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_meanWindow_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public void updateFields(TimeSeries timeSeries) {
        super.updateFields(timeSeries);
    }

    public final float[] apply(double d, float[] fArray) {
        this.deltaTime = d;
        if (this.mem == null) {
            this.mem = new TestPicker3_Memory(fArray);
        }
        float[] fArray2 = null;
        if (this.resultType == 2 || this.resultType == 1) {
            fArray2 = new float[fArray.length];
        }
        for (int i = 0; i < fArray.length; ++i) {
            int n;
            if (!this.mem.inTriggerEvent) {
                for (int j = 0; j < this.mem.numRecursive; ++j) {
                    this.mem.mean_xRec_ACTIVE[j] = this.mem.mean_xRec[j];
                    this.mem.mean_stdDev_xRec_ACTIVE[j] = this.mem.mean_stdDev_xRec[j];
                }
            }
            double d2 = 0.0;
            double d3 = 0.0;
            float f = fArray[i];
            this.mem.index = (this.mem.index + 1) % this.mem.numPrevious;
            this.mem.indexLast = (this.mem.indexLast + 1) % this.mem.numPrevious;
            this.mem.filteredSample[this.mem.numRecursive - 1][this.mem.index] = this.mem.filteredSample[this.mem.numRecursive - 1][this.mem.indexLast] * this.mem.decayConst[this.mem.numRecursive - 1] + (double)f * this.mem.decayFactor[this.mem.numRecursive - 1];
            for (n = this.mem.numRecursive - 2; n >= 0; --n) {
                double d4;
                this.mem.filteredSample[n][this.mem.index] = this.mem.filteredSample[n][this.mem.indexLast] * this.mem.decayConst[n] + (double)f * this.mem.decayFactor[n];
                int n2 = (2 * this.mem.numPrevious + this.mem.index - this.mem.indexDelay[n + 1]) % this.mem.numPrevious;
                this.mem.xRec[n] = this.mem.filteredSample[n][this.mem.index] - this.mem.filteredSample[n + 1][n2];
                int n3 = n;
                this.mem.xRec[n3] = this.mem.xRec[n3] * this.mem.xRec[n];
                if (!this.mem.inTriggerEvent && i <= this.mem.indexUpEventEnd + this.mem.indexDelay[n + 1] || !(this.mem.mean_stdDev_xRec_ACTIVE[n] > (double)1.4E-45f) || !((d4 = (this.mem.xRec[n] - this.mem.mean_xRec_ACTIVE[n]) / this.mem.mean_stdDev_xRec_ACTIVE[n]) > d2)) continue;
                d2 = d4;
                d3 = d / this.mem.decayFactor[n];
            }
            this.mem.charFunctUncertainty = (d2 + this.mem.charFunctLast1 + this.mem.charFunctLast2) / 3.0;
            this.mem.charFunctLast2 = this.mem.charFunctLast1;
            this.mem.charFunctLast1 = d2;
            if (this.mem.charFunctUncertainty > this.mem.uncertaintyThreshold) {
                if (this.mem.indexUncertainty == -1073741823) {
                    this.mem.indexUncertainty = i - 1;
                    this.mem.amplitudePolarity = this.mem.amplitudeUncertainty = this.mem.lastSample;
                    this.mem.countPolarity = 0;
                }
            } else if (!this.mem.inTriggerEvent) {
                this.mem.indexUncertainty = -1073741823;
            }
            if (this.mem.indexUncertainty != -1073741823 && !this.mem.inTriggerEvent) {
                this.mem.amplitudePolarity = Math.abs((double)f - this.mem.amplitudeUncertainty) > Math.abs(this.mem.amplitudePolarity) ? (double)f - this.mem.amplitudeUncertainty : this.mem.amplitudePolarity;
                this.mem.countPolarity = this.mem.countPolarity + ((double)f - this.mem.lastSample > 0.0 ? 1 : -1);
            }
            if (!this.mem.allowTriggerEvent) {
                ++this.mem.nTotal;
            }
            if (this.mem.allowTriggerEvent || this.mem.nTotal > this.mem.indexAllowTriggerEvent) {
                this.mem.allowTriggerEvent = true;
                this.mem.upEventIndex = (this.mem.upEventIndex + 1) % this.mem.nTUpEvent;
                this.mem.integralCharFunct -= this.mem.upEventCharFunctValue[this.mem.upEventIndex];
                this.mem.upEventCharFunctValue[this.mem.upEventIndex] = d2;
                if (this.mem.inTriggerEvent) {
                    if (i > this.mem.indexUpEvent + 1) {
                        this.mem.integralCharFunct += d2;
                    } else {
                        double d5 = d2 < 5.0 * this.threshold1 ? d2 : 5.0 * this.threshold1;
                        this.mem.integralCharFunct += d5;
                        this.mem.upEventCharFunctValue[this.mem.upEventIndex] = d5;
                    }
                    this.mem.ampCharFunctSum += d2;
                    if (i <= this.mem.indexUpEventEnd) {
                        if (!this.mem.willAcceptPick && this.mem.integralCharFunct >= this.mem.criticalIntegralCharFunct) {
                            this.mem.willAcceptPick = true;
                        }
                    } else {
                        if (this.mem.willAcceptPick) {
                            this.mem.acceptedPick = true;
                        } else {
                            this.mem.indexUpEventEnd = -1073741823;
                        }
                        this.mem.willAcceptPick = false;
                        this.mem.inTriggerEvent = false;
                    }
                } else if (d2 >= this.threshold1) {
                    this.mem.inTriggerEvent = true;
                    this.mem.ampCharFunctSum = d2;
                    this.mem.indexUpEvent = i;
                    this.mem.indexUpEventEnd = i + this.mem.nTUpEvent;
                    double d6 = d2 < 5.0 * this.threshold1 ? d2 : 5.0 * this.threshold1;
                    this.mem.integralCharFunct += d6;
                    this.mem.upEventCharFunctValue[this.mem.upEventIndex] = this.threshold1;
                    this.mem.pickPolarity = this.mem.countPolarity > 1 ? 1 : (this.mem.countPolarity < -1 ? -1 : 0);
                    this.mem.triggerPeriod = d3;
                } else {
                    this.mem.integralCharFunct += d2;
                }
            }
            for (n = 0; n < this.mem.numRecursive; ++n) {
                this.mem.mean_xRec[n] = this.mem.mean_xRec[n] * this.mem.longDecayConst + this.mem.xRec[n] * this.mem.longDecayFactor;
                double d7 = this.mem.xRec[n] - this.mem.mean_xRec[n];
                this.mem.mean_var_xRec[n] = this.mem.mean_var_xRec[n] * this.mem.longDecayConst + d7 * d7 * this.mem.longDecayFactor;
                this.mem.mean_stdDev_xRec[n] = Math.sqrt(this.mem.mean_var_xRec[n]);
            }
            if (this.resultType == 2) {
                fArray2[i] = this.mem.acceptedPick ? 1.0f : 0.0f;
            } else if (this.resultType == 1) {
                fArray2[i] = (float)d2;
            } else if (this.mem.acceptedPick) {
                PickData pickData = new PickData(this.mem.indexUncertainty, this.mem.indexUpEvent, this.mem.pickPolarity, Math.log(this.mem.ampCharFunctSum / this.mem.criticalIntegralCharFunct), "_CF", this.mem.triggerPeriod);
                this.triggerPickData.add(pickData);
            }
            if (this.mem.acceptedPick) {
                this.mem.indexUncertainty = -1073741823;
            }
            this.mem.acceptedPick = false;
            this.mem.lastSample = f;
        }
        if (this.useMemory) {
            this.mem.indexUncertainty -= fArray.length;
            this.mem.indexUpEvent -= fArray.length;
            this.mem.indexUpEventEnd -= fArray.length;
        } else {
            this.mem = null;
        }
        if (this.resultType == 2 || this.resultType == 1) {
            fArray = fArray2;
        }
        return fArray;
    }

    public boolean supportsMemory() {
        return true;
    }

    public class TestPicker3_Memory
    extends TimeDomainMemory {
        double uncertaintyThreshold = 2.0;
        int indexUncertainty = -1073741823;
        double amplitudeUncertainty = 0.0;
        double amplitudePolarity = 0.0;
        int countPolarity = 0;
        double longDecayFactor;
        double longDecayConst;
        int nLongTermWindow;
        int indexAllowTriggerEvent;
        boolean allowTriggerEvent;
        int nTotal;
        int numPrevious;
        int numRecursive;
        int nTemp;
        double[] xRec;
        double[] test;
        double[][] filteredSample;
        double[] mean_xRec;
        double[] mean_xRec_ACTIVE;
        double[] mean_stdDev_xRec;
        double[] mean_stdDev_xRec_ACTIVE;
        double[] mean_var_xRec;
        double[] decayFactor;
        double[] decayConst;
        int[] indexDelay;
        int index;
        int indexLast;
        double window;
        int nDelay;
        double lastSample;
        boolean dataGap;
        double charFunctTrue;
        double charFunctUncertainty;
        double charFunctLast1;
        double charFunctLast2;
        boolean inTriggerEvent;
        double ampCharFunctSum;
        int indexUpEvent;
        int indexUpEventEnd;
        int nTUpEvent;
        double criticalIntegralCharFunct;
        double integralCharFunct;
        double[] upEventCharFunctValue;
        int upEventIndex;
        boolean acceptedPick;
        boolean willAcceptPick;
        int pickPolarity;
        double triggerPeriod;
        int nvar;

        public TestPicker3_Memory(float[] fArray) {
            int n;
            this.longDecayFactor = TestPicker3.this.deltaTime / TestPicker3.this.longTermWindow;
            this.longDecayConst = 1.0 - this.longDecayFactor;
            this.indexAllowTriggerEvent = this.nLongTermWindow = 1 + (int)(TestPicker3.this.longTermWindow / TestPicker3.this.deltaTime);
            this.allowTriggerEvent = false;
            this.nTotal = -1;
            this.numPrevious = (int)(TestPicker3.this.filterWindow * 2.0 / TestPicker3.this.deltaTime);
            this.numRecursive = 1;
            this.nTemp = 1;
            while (this.nTemp < this.numPrevious) {
                ++this.numRecursive;
                this.nTemp *= 2;
            }
            this.numPrevious = this.nTemp;
            this.xRec = new double[this.numRecursive];
            this.test = new double[this.numRecursive];
            this.filteredSample = new double[this.numRecursive][this.numPrevious];
            this.mean_xRec = new double[this.numRecursive];
            this.mean_xRec_ACTIVE = new double[this.numRecursive];
            this.mean_stdDev_xRec = new double[this.numRecursive];
            this.mean_stdDev_xRec_ACTIVE = new double[this.numRecursive];
            this.mean_var_xRec = new double[this.numRecursive];
            this.decayFactor = new double[this.numRecursive];
            this.decayConst = new double[this.numRecursive];
            this.indexDelay = new int[this.numRecursive];
            this.index = -1;
            this.indexLast = this.numPrevious - 2;
            this.window = TestPicker3.this.deltaTime;
            this.nDelay = 1;
            for (n = 0; n < this.numRecursive; ++n) {
                this.mean_xRec[n] = 0.0;
                this.mean_stdDev_xRec[n] = 0.0;
                this.decayFactor[n] = TestPicker3.this.deltaTime / this.window;
                this.decayConst[n] = 1.0 - this.decayFactor[n];
                this.indexDelay[n] = this.nDelay + 1;
                this.window *= 2.0;
                this.nDelay *= 2;
            }
            this.lastSample = 0.0;
            this.dataGap = false;
            this.charFunctTrue = 0.0;
            this.charFunctUncertainty = 0.0;
            this.charFunctLast1 = 0.0;
            this.charFunctLast2 = 0.0;
            this.inTriggerEvent = false;
            this.ampCharFunctSum = 0.0;
            this.indexUpEvent = -1073741823;
            this.indexUpEventEnd = -1073741823;
            this.nTUpEvent = (int)(0.5 + TestPicker3.this.tUpEvent / TestPicker3.this.deltaTime) - 1;
            if (this.nTUpEvent < 1) {
                this.nTUpEvent = 1;
            }
            this.criticalIntegralCharFunct = (double)this.nTUpEvent * TestPicker3.this.threshold2;
            this.integralCharFunct = 0.0;
            this.upEventCharFunctValue = new double[this.nTUpEvent];
            this.upEventIndex = -1;
            this.acceptedPick = false;
            this.willAcceptPick = false;
            this.pickPolarity = 0;
            this.triggerPeriod = 0.0;
            this.nvar = 0;
            for (n = 0; n < this.numRecursive; ++n) {
                for (int i = 0; i < this.numPrevious; ++i) {
                    this.filteredSample[n][i] = fArray[0];
                }
            }
            System.out.println("TestPicker3_Memory initialized: numRecursive, numPrevious " + this.numRecursive + " " + this.numPrevious);
        }
    }
}

