/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.alomax.swing.EditorEntry;
import net.alomax.swing.SwingExt;

public class FormattedTextFieldsEditor
extends JPanel
implements PropertyChangeListener {
    protected JDialog dialog = null;
    protected String frameTitle = "";
    protected JFrame parentFrame = null;
    protected Vector editorEntries = new Vector();
    protected final EditorEntry DUMMY_EDITOR_ENTRY = new EditorEntry();
    public static final int SAVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected int currentOption = 1;
    protected String saveText;
    protected String cancelText;

    public FormattedTextFieldsEditor(JFrame jFrame, String string, String string2, String string3) {
        super(new BorderLayout());
        this.frameTitle = string;
        this.parentFrame = jFrame;
        this.saveText = string2;
        this.cancelText = string3;
    }

    public void addSeparator() {
        this.editorEntries.add(this.DUMMY_EDITOR_ENTRY);
    }

    public void addLabel(String string) {
        this.editorEntries.add(new EditorEntry(string));
    }

    public void addEntry(String string, String string2, Object object, int n) {
        if (object instanceof Number) {
            this.addEntry(string, string2, (Number)object, n, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else {
            EditorEntry editorEntry = new EditorEntry(string, string2, object, n, this);
            this.editorEntries.add(editorEntry);
        }
    }

    public void addEntry(String string, String string2, Number number, int n, NumberFormat numberFormat) {
        this.addEntry(string, string2, number, n, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, numberFormat);
    }

    public void addEntry(String string, String string2, Number number, int n, double d, double d2, NumberFormat numberFormat) {
        EditorEntry editorEntry = new EditorEntry(string, string2, number, n, d, d2, numberFormat, this);
        this.editorEntries.add(editorEntry);
    }

    public void addEntry(String string, String string2, Number number, int n, double d, double d2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (number instanceof Long || number instanceof Integer || number instanceof Short) {
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setMaximumFractionDigits(0);
        } else {
            numberFormat.setMaximumFractionDigits(999);
        }
        this.addEntry(string, string2, number, n, d, d2, numberFormat);
    }

    public void addAfter(String string, JComponent jComponent) {
        for (int i = 0; i < this.editorEntries.size(); ++i) {
            EditorEntry editorEntry = (EditorEntry)this.editorEntries.elementAt(i);
            if (!string.equals(editorEntry.id)) continue;
            editorEntry.compAfter = jComponent;
            return;
        }
    }

    public Object getValue(String string) {
        for (int i = 0; i < this.editorEntries.size(); ++i) {
            EditorEntry editorEntry = (EditorEntry)this.editorEntries.elementAt(i);
            if (!string.equals(editorEntry.id)) continue;
            return editorEntry.textField.getValue();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        for (int i = 0; i < this.editorEntries.size(); ++i) {
            EditorEntry editorEntry = (EditorEntry)this.editorEntries.elementAt(i);
            if (object != editorEntry.textField) continue;
        }
    }

    public void layoutPanel() {
        Object object;
        this.removeAll();
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        for (int i = 0; i < this.editorEntries.size(); ++i) {
            object = (EditorEntry)this.editorEntries.elementAt(i);
            if (object == this.DUMMY_EDITOR_ENTRY) {
                jPanel.add(new JPanel());
                jPanel2.add(new JPanel());
                jPanel3.add(new JPanel());
                continue;
            }
            if (((EditorEntry)object).id.equals("__LABEL")) {
                jPanel.add(((EditorEntry)object).label);
                jPanel2.add(new JPanel());
                jPanel3.add(new JPanel());
                continue;
            }
            jPanel.add(((EditorEntry)object).label);
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.add(((EditorEntry)object).textField);
            jPanel2.add(jPanel4);
            if (((EditorEntry)object).compAfter != null) {
                jPanel3.add(((EditorEntry)object).compAfter);
                continue;
            }
            jPanel3.add(new JPanel());
        }
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(SwingExt.defaultEmptyBorder);
        jPanel5.add((Component)jPanel, "Before");
        jPanel5.add((Component)jPanel2, "Center");
        jPanel5.add((Component)jPanel3, "After");
        object = new JScrollPane(jPanel5);
        this.add((Component)object, "Center");
    }

    public void show() {
        this.layoutPanel();
        JButton jButton = new JButton(this.saveText);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattedTextFieldsEditor.this.currentOption = 0;
                FormattedTextFieldsEditor.this.dialog.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(this.cancelText);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattedTextFieldsEditor.this.currentOption = 1;
                FormattedTextFieldsEditor.this.dialog.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(SwingExt.defaultBorderWidth, 0, 0, 0));
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "South");
        this.dialog = new JDialog(this.parentFrame, this.frameTitle, true);
        this.dialog.setDefaultCloseOperation(2);
        FormattedTextFieldsEditor formattedTextFieldsEditor = this;
        formattedTextFieldsEditor.setOpaque(true);
        this.dialog.setContentPane(formattedTextFieldsEditor);
        this.dialog.pack();
        SwingExt.setLocationToCenterOfScreen(this.dialog);
        this.dialog.setVisible(true);
    }

    public boolean wasCancelled() {
        return this.currentOption == 1;
    }

    public static void main(String[] stringArray) throws Exception {
        final FormattedTextFieldsEditor formattedTextFieldsEditor = new FormattedTextFieldsEditor(null, "FormattedTextFieldsEditor", "Save", "Cancel");
        formattedTextFieldsEditor.addEntry("0", "First String", "Initial Value 1", 50);
        formattedTextFieldsEditor.addEntry("1", "Second String", "Initial Value 2", 50);
        formattedTextFieldsEditor.addEntry("2", "Third Integer", new Integer(3), 5);
        formattedTextFieldsEditor.addEntry("3", "Third Float [0-10]", new Float(4.0), 10, 0.0, 10.0);
        formattedTextFieldsEditor.addEntry("4", "Fourth Float", new Float(4.0), 5);
        formattedTextFieldsEditor.addAfter("0", new JCheckBox("Apply to all traces"));
        formattedTextFieldsEditor.addAfter("1", new JLabel("After"));
        formattedTextFieldsEditor.addAfter("2", new JCheckBox("Apply to all traces"));
        formattedTextFieldsEditor.addAfter("3", new JLabel("After"));
        formattedTextFieldsEditor.addAfter("4", new JCheckBox("Apply to all traces"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.out.println("Before:");
                for (int i = 0; i < formattedTextFieldsEditor.editorEntries.size(); ++i) {
                    EditorEntry editorEntry = (EditorEntry)formattedTextFieldsEditor.editorEntries.elementAt(i);
                    System.out.println("id: " + editorEntry.id + "  Value: " + editorEntry.textField.getValue());
                }
                formattedTextFieldsEditor.show();
            }
        });
    }
}

