/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.alomax.util.StringExt;

public class AJLFileFilter
extends FileFilter {
    public static String COMPRESSED_EXTENSIONS = "gz*GZ*zip*ZIP";
    public static AJLFileFilter[] imageIOFileFilters = new AJLFileFilter[]{new AJLFileFilter("jpg", "jpg*jpeg", "JPEG (*.jpg, *.jpeg)", true), new AJLFileFilter("bmp", "bmp", "BMP (*.bmp)", true)};
    protected String primaryExtension = null;
    protected String validExtensions = null;
    protected String description = null;
    protected boolean allowCompressed = false;
    protected boolean allowAnywhere = false;

    public static AJLFileFilter[] mergeFilters(AJLFileFilter[] aJLFileFilterArray, String string) {
        int n;
        if (string == null) {
            return aJLFileFilterArray;
        }
        String[] stringArray = StringExt.parse(string, ";");
        AJLFileFilter[] aJLFileFilterArray2 = new AJLFileFilter[stringArray.length + aJLFileFilterArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2 = StringExt.parse(stringArray[n], ",");
            aJLFileFilterArray2[n] = stringArray2.length > 1 ? new AJLFileFilter(null, stringArray2[0], stringArray2[1], true, true) : (stringArray2.length > 0 ? new AJLFileFilter(null, stringArray2[0], "???", true, true) : new AJLFileFilter(null, "ERROR", "???", true, true));
        }
        for (n = stringArray.length; n < stringArray.length + aJLFileFilterArray.length; ++n) {
            aJLFileFilterArray2[n] = aJLFileFilterArray[n - stringArray.length];
        }
        return aJLFileFilterArray2;
    }

    public AJLFileFilter(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.primaryExtension = string;
        this.validExtensions = string2;
        this.description = string3;
        this.allowCompressed = bl;
        this.allowAnywhere = bl2;
        if (!bl2) {
            string2 = string2.toLowerCase();
        }
    }

    public AJLFileFilter(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, bl, false);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.validExtensions == null) {
            return false;
        }
        if (this.allowAnywhere) {
            String string = file.getName();
            if (string != null) {
                return string.indexOf(this.validExtensions) >= 0;
            }
        } else {
            return this.isValidExtension(file);
        }
        return false;
    }

    public boolean isValidExtension(File file) {
        String string = this.getExtension(file);
        if (string != null) {
            return this.validExtensions.indexOf(string) >= 0;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        if (string == null) {
            return null;
        }
        if (this.allowCompressed && COMPRESSED_EXTENSIONS.indexOf(string) >= 0 && (n = (string2 = string2.substring(0, n)).lastIndexOf(46)) > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public String getPrimaryExtension() {
        return this.primaryExtension;
    }

    public File addExtensionAuto(File file) {
        if (this.primaryExtension == null || this.getExtension(file) != null) {
            return file;
        }
        return new File(file.getAbsolutePath() + "." + this.primaryExtension);
    }
}

