/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.multicomp.MultiCompException;
import net.alomax.multicomp.MultiCompProcesses;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.toolmanager.PolarisationAnalysisToolManager;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;

public class MultiCompToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected AJLJButton buttonMagnitude;
    protected AJLJButton buttonMultiply;
    protected AJLJButton buttonDivide;
    protected AJLJButton buttonAdd;
    protected AJLJButton buttonSubtract;
    protected AJLJButton buttonDotProduct;
    protected AJLJButton buttonCrossProduct;
    protected AJLJButton buttonAngles;
    protected AJLJButton buttonPolarisation;
    protected AJLJButton buttonSumAll;
    protected JTextField textFieldOtherIndex;
    protected int otherIndex = 0;
    protected PolarisationAnalysisToolManager polarisationAnalysisToolManager = null;
    protected static int ndx = 0;
    protected static final int MAGNITUDE = ndx++;
    protected static final int MULTIPLY = ndx++;
    protected static final int DIVIDE = ndx++;
    protected static final int ADD = ndx++;
    protected static final int SUBTRACT = ndx++;
    protected static final int DOT_PRODUCT = ndx++;
    protected static final int CROSS_PRODUCT = ndx++;
    protected static final int ANGLES = ndx++;
    protected static final int POLARISATION = ndx++;
    protected static final int SUM_ALL = ndx++;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public MultiCompToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        try {
            String string = null;
            string = seisGram2KFrame.getParameter("multicomp.otherindex");
            if (string != null) {
                try {
                    this.otherIndex = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.otherIndex = 0;
                }
            }
        }
        catch (Exception exception) {
            seisGram2KFrame.writeMessage(exception.getMessage());
        }
        this.commandNames = new String[]{"magnitude", "vmultiply", "vdivide", "vadd", "vsubtract", "dotproduct", "crossproduct", "angles", "polarisation", "vsum"};
        this.commandNamesShort = new String[]{"mag", "vmul", "vdiv", "vadd", "vsub", "dpr", "cpr", "ang", "pol", "vsum"};
    }

    public void updateLabel() {
        this.label = SeisGramText.MULTI_COMPONENT;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        this.buttonMagnitude = new AJLJButton(this, this, SeisGramText.MAGNITUDE);
        jToolBar.add(this.buttonMagnitude);
        this.buttonAngles = new AJLJButton(this, this, SeisGramText.ANGLES);
        jToolBar.add(this.buttonAngles);
        this.buttonPolarisation = new AJLJButton(this, this, SeisGramText.POLARISATION);
        jToolBar.add(this.buttonPolarisation);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.OTHER_INDEX + ":", 4));
        this.textFieldOtherIndex = SwingExt.newJTextField(this, this, String.valueOf(this.otherIndex), 5);
        jToolBar.add(this.textFieldOtherIndex);
        this.buttonMultiply = new AJLJButton(this, this, SeisGramText.MULTIPLY);
        jToolBar.add(this.buttonMultiply);
        this.buttonDivide = new AJLJButton(this, this, SeisGramText.DIVIDE);
        jToolBar.add(this.buttonDivide);
        this.buttonAdd = new AJLJButton(this, this, SeisGramText.ADD);
        jToolBar.add(this.buttonAdd);
        this.buttonSubtract = new AJLJButton(this, this, SeisGramText.SUBTRACT);
        jToolBar.add(this.buttonSubtract);
        this.buttonDotProduct = new AJLJButton(this, this, SeisGramText.DOT_PRODUCT);
        jToolBar.add(this.buttonDotProduct);
        this.buttonCrossProduct = new AJLJButton(this, this, SeisGramText.CROSS_PRODUCT);
        jToolBar.add(this.buttonCrossProduct);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        this.buttonSumAll = new AJLJButton(this, this, SeisGramText.SUM_ALL);
        jToolBar.add(this.buttonSumAll);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            boolean bl = false;
            int n = -1;
            try {
                n = Integer.parseInt(this.textFieldOtherIndex.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (this.seisFrame.getGatherListElementAt(n) == null) {
                this.seisFrame.writeMessage(SeisGramText.ERROR_OTHER_INDEX_NOT_FOUND);
                bl = true;
            } else {
                this.otherIndex = n;
            }
            this.textFieldOtherIndex.setText(String.valueOf(this.otherIndex));
            if (actionEvent.getSource().equals(this.buttonMagnitude)) {
                this.variant = MAGNITUDE;
            } else if (actionEvent.getSource().equals(this.buttonMultiply)) {
                this.variant = MULTIPLY;
            } else if (actionEvent.getSource().equals(this.buttonDivide)) {
                this.variant = DIVIDE;
            } else if (actionEvent.getSource().equals(this.buttonAdd)) {
                this.variant = ADD;
            } else if (actionEvent.getSource().equals(this.buttonSumAll)) {
                this.variant = SUM_ALL;
            } else if (actionEvent.getSource().equals(this.buttonSubtract)) {
                this.variant = SUBTRACT;
            } else if (actionEvent.getSource().equals(this.buttonDotProduct)) {
                this.variant = DOT_PRODUCT;
            } else if (actionEvent.getSource().equals(this.buttonCrossProduct)) {
                this.variant = CROSS_PRODUCT;
            } else if (actionEvent.getSource().equals(this.buttonAngles)) {
                this.variant = ANGLES;
            } else {
                if (actionEvent.getSource().equals(this.buttonPolarisation)) {
                    if (this.polarisationAnalysisToolManager == null) {
                        this.polarisationAnalysisToolManager = new PolarisationAnalysisToolManager(this.seisFrame);
                    }
                    this.seisFrame.initializeInteractionPanel(this.polarisationAnalysisToolManager);
                    return;
                }
                return;
            }
            this.apply();
        }
        catch (MultiCompException multiCompException) {
            this.seisFrame.writeMessage("ERROR: " + multiCompException.toString());
        }
    }

    protected void apply() throws MultiCompException {
        GatherPanel gatherPanel = this.seisFrame.getGatherListElementAt(this.otherIndex);
        if (this.variant == MAGNITUDE) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.MAGNITUDE), this.getCommandString(), gatherPanel);
        } else if (this.variant == MULTIPLY) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.MULTIPLY), this.getCommandString(), gatherPanel);
        } else if (this.variant == DIVIDE) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.DIVIDE), this.getCommandString(), gatherPanel);
        } else if (this.variant == ADD) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.ADD), this.getCommandString(), gatherPanel);
        } else if (this.variant == SUBTRACT) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.SUBTRACT), this.getCommandString(), gatherPanel);
        } else if (this.variant == DOT_PRODUCT) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.DOT_PRODUCT), this.getCommandString(), gatherPanel);
        } else if (this.variant == CROSS_PRODUCT) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.CROSS_PRODUCT), this.getCommandString(), gatherPanel);
        } else if (this.variant == ANGLES) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.ANGLES), this.getCommandString(), gatherPanel);
        } else if (this.variant == SUM_ALL) {
            this.seisFrame.applyMultiCompProcess(new MultiCompProcesses(MultiCompProcesses.ADD), this.getCommandString(), null);
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        if (this.polarisationAnalysisToolManager == null) {
            this.polarisationAnalysisToolManager = new PolarisationAnalysisToolManager(this.seisFrame);
        }
        return this.polarisationAnalysisToolManager != null && this.polarisationAnalysisToolManager.isCommandHandler(string);
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        if (this.polarisationAnalysisToolManager != null && this.polarisationAnalysisToolManager.isCommandHandler(string)) {
            this.polarisationAnalysisToolManager.applyCommand(string);
            return;
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.toLowerCase().startsWith("ot")) continue;
                    this.otherIndex = Integer.parseInt(stringTokenizer.nextToken());
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (MultiCompException multiCompException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + multiCompException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        if (this.variant == MULTIPLY || this.variant == DIVIDE || this.variant == ADD || this.variant == SUBTRACT || this.variant == DOT_PRODUCT || this.variant == CROSS_PRODUCT) {
            string = string + " other " + this.otherIndex;
        }
        return string;
    }
}

