/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.net.URLConnection;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.net.GeneralURLConnection;
import net.alomax.seisgram2k.PhaseSet;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JTextFrame;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.util.StringExt;
import sdsu.io.ASCIIInputStream;

public class EventToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected AJLJButton buttonSendPicks;
    protected AJLJButton buttonEventInfo;
    boolean eventExists = false;
    protected long eventIdNumber = -1L;
    protected String eventURL = null;
    protected String eventInformation = null;
    protected String eventProtocol = null;
    protected boolean sendall = true;
    protected static final int EVENT_INFO = 0;
    protected static final int SEND_PICKS = 1;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public EventToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.commandNames = new String[]{"eventinfo", "sendpicks"};
        this.commandNamesShort = new String[]{"ein", "spk"};
        String string = null;
        string = seisGram2KFrame.getParameter("event.id");
        if (string != null) {
            this.eventIdNumber = Long.valueOf(string);
            this.eventExists = true;
        }
        if ((this.eventURL = seisGram2KFrame.getParameter("event.url")) != null) {
            this.eventExists = true;
        }
        if ((this.eventInformation = seisGram2KFrame.getParameter("event.info")) != null) {
            this.eventInformation = StringExt.replace(this.eventInformation, "\\n", "\n");
            this.eventExists = true;
        }
        String string2 = null;
        string2 = seisGram2KFrame.getParameter("event.protocol");
        if (string2 != null) {
            this.eventProtocol = string2;
        }
        this.sendall = seisGram2KFrame.getTrueFalseParameter(true, "event.sendall");
    }

    public void updateLabel() {
        this.label = SeisGramText.EVENT;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonEventInfo = new AJLJButton(this, this, SeisGramText.EVENT_INFO);
        jToolBar.add(this.buttonEventInfo);
        this.buttonSendPicks = new AJLJButton(this, this, SeisGramText.SEND_PICKS);
        jToolBar.add(this.buttonSendPicks);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
        this.buttonSendPicks.setEnabled(this.eventURL != null);
        this.buttonEventInfo.setEnabled(this.eventInformation != null);
    }

    public void setAWTStates() {
        this.button.setEnabled(this.eventExists && this.seisFrame.getActiveGather() != null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonEventInfo)) {
            this.variant = 0;
        } else if (actionEvent.getSource().equals(this.buttonSendPicks)) {
            this.variant = 1;
        } else {
            return;
        }
        this.apply();
    }

    protected void apply() {
        if (this.variant == 0) {
            this.displayEventInfo();
        } else if (this.variant == 1) {
            this.sendPicks();
        }
    }

    private void displayEventInfo() {
        JTextFrame jTextFrame = new JTextFrame(SeisGramText.EVENT_INFO, null, this.eventInformation, SeisGramText.CLOSE, this.seisFrame.getIconImage(), null);
        SwingExt.setLocationToCenter(jTextFrame, this.seisFrame.getJFrame(), this.seisFrame.getJFrame().getLocationOnScreen());
        jTextFrame.show();
    }

    private int sendPicks() {
        if (this.eventURL == null) {
            return -1;
        }
        URLConnection uRLConnection = null;
        try {
            uRLConnection = GeneralURLConnection.openURLConnection(null, this.eventURL);
            this.seisFrame.writeMessage("Writing picks to URL: " + uRLConnection + "...");
            if (uRLConnection == null) {
                throw new Exception();
            }
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
        }
        catch (Exception exception) {
            this.seisFrame.writeMessage("_READY");
            String string = "ERROR: Opening event URL: " + exception;
            System.out.println(string);
            this.seisFrame.writeMessage(string);
            return -1;
        }
        int n = this.writePicks(uRLConnection, this.eventIdNumber, this.eventProtocol);
        this.seisFrame.writeMessage(" " + n + " reading lines written.");
        return n;
    }

    public int writePicks(URLConnection uRLConnection, long l, String string) {
        Object object;
        Object object2;
        if (uRLConnection == null) {
            return 0;
        }
        String string2 = System.getProperty("line.separator");
        if (string != null) {
            if (string.equalsIgnoreCase("CGI_BIN_EARTHWORM")) {
                string2 = " ";
            } else if (string.equalsIgnoreCase("XML_STANDARD")) {
                string2 = System.getProperty("line.separator");
            } else if (string.equalsIgnoreCase("NON_LIN_LOC_XML")) {
                string2 = System.getProperty("line.separator");
            }
        }
        Object object3 = System.getProperty("line.separator");
        try {
            ASCIIOutputStream aSCIIOutputStream = new ASCIIOutputStream(System.out);
            aSCIIOutputStream.writeWord("<?xml version=\"1.0\"?>" + (String)object3);
            aSCIIOutputStream.writeWord("<Event id=\"" + l + "\">" + (String)object3);
            aSCIIOutputStream.writeWord("<ReadingList format=\"" + SeisPick.getFileFormatString() + "\">" + (String)object3);
            object2 = "";
            object = object3;
            this.writePickList(aSCIIOutputStream, (String)object2, (String)object);
            aSCIIOutputStream.writeWord("</ReadingList>" + (String)object3);
            aSCIIOutputStream.writeWord("</Event>" + System.getProperty("line.separator"));
            aSCIIOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = null;
        int n = 0;
        try {
            object3 = new ASCIIOutputStream(new BufferedOutputStream(uRLConnection.getOutputStream()));
            if (object3 == null) {
                throw new Exception();
            }
            ((ASCIIOutputStream)object3).writeWord("<?xml version=\"1.0\"?>" + string2);
            ((ASCIIOutputStream)object3).writeWord("<Event id=\"" + l + "\">" + string2);
            ((ASCIIOutputStream)object3).writeWord("<ReadingList format=\"" + SeisPick.getFileFormatString() + "\">" + string2);
            object2 = "";
            object = string2;
            n = this.writePickList((ASCIIOutputStream)object3, (String)object2, (String)object);
            ((ASCIIOutputStream)object3).writeWord("</ReadingList>" + string2);
            ((ASCIIOutputStream)object3).writeWord("</Event>" + System.getProperty("line.separator"));
            ((FilterOutputStream)object3).close();
        }
        catch (Exception exception) {
            this.seisFrame.writeMessage("_READY");
            object = "ERROR: Writing to event URL: " + exception;
            System.out.println((String)object);
            this.seisFrame.writeMessage((String)object);
            return -1;
        }
        object2 = null;
        try {
            object2 = new ASCIIInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            if (object2 == null) {
                throw new Exception();
            }
            while (!((ASCIIInputStream)object2).eof()) {
                object = ((ASCIIInputStream)object2).readLine();
                System.out.println((String)object);
            }
            ((FilterInputStream)object2).close();
        }
        catch (Exception exception) {
            this.seisFrame.writeMessage("_READY");
            String string3 = "ERROR: Reading from event URL: " + exception;
            System.out.println(string3);
            this.seisFrame.writeMessage(string3);
            return -1;
        }
        return n;
    }

    public int writePickList(ASCIIOutputStream aSCIIOutputStream, String string, String string2) {
        PhaseSet phaseSet = this.seisFrame.getPickList();
        String string3 = string + "<Reading status=";
        String string4 = "</Reading>" + string2;
        for (int i = 0; i < phaseSet.size(); ++i) {
            SeisPick seisPick = (SeisPick)phaseSet.elementAt(i);
            String string5 = "";
            if (!this.sendall && seisPick.getStatus() == 1 && seisPick.getSource() != 2) continue;
            int n = seisPick.getStatus();
            if (n == 0) {
                string5 = "unknown";
            } else if (n == 1) {
                string5 = "existing";
            } else if (n == 2) {
                string5 = "deleted";
            } else if (n == 3) {
                string5 = "inserted";
            }
            seisPick.write(aSCIIOutputStream, string3 + string5 + ">", string4);
        }
        return phaseSet.size();
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        if (this.variant >= 0) {
            this.seisFrame.writeProcessingMessage(this.getCommandString());
            this.apply();
            this.seisFrame.writeEndProcessingMessage();
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        return string;
    }
}

